/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5.util;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapDataDump
implements Closeable,
DataDump,
DataDiffable<MapDataDump> {
    @Nonnull
    private final Map<String, Object> map;
    @Nullable
    private final MapDataDump parent;
    @Nullable
    private MapDataDump child;
    private final String prefix;
    private boolean open = true;

    public MapDataDump() {
        this.parent = null;
        this.map = new LinkedHashMap<String, Object>();
        this.prefix = "";
    }

    private MapDataDump(@Nonnull MapDataDump parent, @Nonnull String prefix) {
        this.parent = parent;
        this.map = parent.map;
        this.prefix = prefix;
    }

    private final void put(@Nonnull String key, @Nullable Object value) {
        if (null != this.child) {
            throw new IllegalStateException("Cannot write to parent DataDump while child is open");
        }
        if (!this.open) {
            throw new IllegalStateException("Cannot write to closed DataDump");
        }
        this.map.put(this.prefix + key, value);
    }

    @Override
    @Nonnull
    public MapDataDump child(@Nonnull Class<?> childLabel) {
        return this.child(childLabel.getSimpleName());
    }

    @Override
    @Nonnull
    public MapDataDump child(@Nonnull String childLabel) {
        this.child = new MapDataDump(this, this.prefix + childLabel + ".");
        return this.child;
    }

    @Override
    @Nonnull
    public final DataDump write(@Nonnull String key, @Nullable Object value) {
        return this.write(key, null != value, value);
    }

    @Override
    @Nonnull
    public final DataDump dump(@Nonnull String key, @Nullable DataDumpable value) {
        return this.dump(key, null != value, value);
    }

    @Override
    @Nonnull
    public DataDump write(@Nonnull String key, boolean booleanValue) {
        this.put(key, booleanValue);
        return this;
    }

    @Override
    @Nonnull
    public DataDump write(@Nonnull String key, boolean condition, @Nullable Object value) {
        if (condition) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public DataDump write(@Nonnull String key, @Nullable Collection<?> values) {
        if (values != null && !values.isEmpty()) {
            return this.write(key, true, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDump write(@Nonnull String key, boolean condition, @Nullable Collection<?> values) {
        if (!condition || null == values) {
            return this;
        }
        try (MapDataDump child = this.child(key);){
            int idx = 0;
            for (Object v : values) {
                child.write(Integer.toString(++idx), v);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public DataDump dump(@Nonnull String key, boolean condition, @Nullable DataDumpable value) {
        if (condition) {
            try (MapDataDump child = this.child(key);){
                if (null != value) {
                    value.dumpData(child);
                }
            }
        }
        return this;
    }

    public String toString() {
        return this.map.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private void handleChildClose() {
        if (null != this.child) {
            this.child = null;
        }
    }

    @Override
    public void close() {
        if (this.open) {
            if (null != this.parent) {
                this.parent.handleChildClose();
            }
            this.open = false;
        }
    }

    @Nonnull
    public Map<String, Object> toMap() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final Map<String, Object> toMap(@Nonnull DataDumpable dumpable) {
        try (MapDataDump dump = new MapDataDump();){
            dumpable.dumpData(dump);
        }
        return dump.toMap();
    }

    public static final <D extends DataDumpable> void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull D v1, @Nonnull D v2) {
        MapDataDump d1 = new MapDataDump();
        MapDataDump d2 = new MapDataDump();
        v1.dumpData(d1);
        v2.dumpData(d2);
        d1.diff(diffs, prefix, d2);
    }

    @Override
    public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull MapDataDump compareTo) {
        String key;
        LinkedHashMap<String, Object> v2 = new LinkedHashMap<String, Object>(compareTo.toMap());
        for (Map.Entry<String, Object> entry : this.toMap().entrySet()) {
            key = entry.getKey();
            Object v1Value = entry.getValue();
            Object v2Value = v2.remove(key);
            diffs.test(prefix, key, v1Value, v2Value);
        }
        for (Map.Entry<String, Object> entry : v2.entrySet()) {
            key = entry.getKey();
            Object v2Value = entry.getValue();
            diffs.test(prefix, key, null, v2Value);
        }
    }

    @Override
    public Level level() {
        return Level.FINE;
    }

    @Nonnull
    public SimpleDictionary appendTo(@Nonnull SimpleDictionary dictionary) {
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (null != entry.getValue()) {
                dictionary = dictionary.add(entry.getKey(), entry.getValue().toString());
                continue;
            }
            dictionary = dictionary.add(entry.getKey(), null);
        }
        return dictionary;
    }

    @Override
    public DataDump dump(String key, Collection<? extends DataDumpable> values) {
        if (values != null && !values.isEmpty()) {
            return this.dump(key, true, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDump dump(String key, boolean condition, Collection<? extends DataDumpable> values) {
        if (!condition || null == values) {
            return this;
        }
        try (MapDataDump child = this.child(key);){
            int idx = 0;
            for (DataDumpable dataDumpable : values) {
                child.dump(Integer.toString(++idx), dataDumpable);
            }
        }
        return this;
    }
}

