/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5.util;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonDataDump
implements Closeable,
DataDump {
    private static final String indentString = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final int indentWidth = 1;
    @Nonnull
    private final StringWriter stringWriter;
    @Nonnull
    private final PrintWriter out;
    @Nullable
    private final JsonDataDump parent;
    @Nonnegative
    private final int indentLevel;
    @Nullable
    private JsonDataDump child;
    private final String closingPrefix;
    private boolean open = true;
    private boolean first = true;
    private final boolean easyToRead;

    public JsonDataDump() {
        this(true);
    }

    public JsonDataDump(boolean easyToRead) {
        this.parent = null;
        this.indentLevel = 1;
        this.closingPrefix = "}";
        this.easyToRead = easyToRead;
        this.stringWriter = new StringWriter();
        this.out = new PrintWriter((Writer)this.stringWriter, true);
        this.out.print("{");
    }

    private JsonDataDump(@Nonnull JsonDataDump parent, @Nonnegative int indentLevel, String closingPrefix) {
        this.parent = parent;
        this.stringWriter = parent.stringWriter;
        this.out = parent.out;
        this.indentLevel = indentLevel;
        this.closingPrefix = closingPrefix;
        this.easyToRead = parent.easyToRead;
    }

    private final void assertOpen() {
        if (null != this.child) {
            throw new IllegalStateException("Cannot write to parent DataDump while child is open");
        }
        if (!this.open) {
            throw new IllegalStateException("Cannot write to closed DataDump");
        }
    }

    @Nonnull
    private static final String toString(@Nonnull String value) {
        return '\"' + value.replaceAll("\"", "\\\\\"") + '\"';
    }

    private final void println(@Nullable String key, String value) {
        this.assertOpen();
        if (this.easyToRead) {
            if (this.first) {
                this.out.println();
                this.first = false;
            } else {
                this.out.println(",");
            }
        } else if (this.first) {
            this.first = false;
        } else {
            this.out.print(",");
        }
        if (this.easyToRead) {
            int toWrite;
            for (int toIndent = this.indentLevel * 1; toIndent > 0; toIndent -= toWrite) {
                toWrite = Math.min(toIndent, indentString.length());
                this.out.print(indentString.substring(0, toWrite));
            }
        }
        if (null != key) {
            if (this.easyToRead) {
                this.out.print(JsonDataDump.toString(key) + ": " + value);
            } else {
                this.out.print(JsonDataDump.toString(key) + ":" + value);
            }
        } else {
            this.out.print(value);
        }
    }

    @Override
    @Nonnull
    public JsonDataDump child(@Nonnull Class<?> childLabel) {
        return this.child(childLabel.getSimpleName());
    }

    @Nonnull
    private JsonDataDump child(@Nullable String childLabel, String prefix, String suffix) {
        this.println(childLabel, prefix);
        this.child = new JsonDataDump(this, this.indentLevel + 1, suffix);
        return this.child;
    }

    @Override
    @Nonnull
    public JsonDataDump child(@Nullable String childLabel) {
        return this.child(childLabel, "{", "}");
    }

    @Override
    @Nonnull
    public final DataDump write(@Nonnull String key, @Nullable Object value) {
        return this.write(key, null != value, value);
    }

    @Override
    @Nonnull
    public final DataDump dump(@Nullable String key, @Nullable DataDumpable value) {
        return this.dump(key, null != value, value);
    }

    @Override
    @Nonnull
    public DataDump write(@Nonnull String key, boolean booleanValue) {
        this.println(key, Boolean.toString(booleanValue));
        return this;
    }

    @Override
    @Nonnull
    public DataDump write(@Nullable String key, boolean condition, @Nullable Object value) {
        if (condition) {
            if (null == value) {
                this.println(key, "null");
            } else if (value instanceof Boolean) {
                this.println(key, value.toString());
            } else if (value instanceof Number) {
                this.println(key, value.toString());
            } else {
                this.println(key, JsonDataDump.toString(value.toString()));
            }
        }
        return this;
    }

    @Override
    public DataDump write(@Nonnull String key, @Nullable Collection<?> values) {
        if (values != null && !values.isEmpty()) {
            return this.write(key, true, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDump write(@Nonnull String key, boolean condition, @Nullable Collection<?> values) {
        if (!condition || null == values) {
            return this;
        }
        try (JsonDataDump child = this.child(key, "[", "]");){
            for (Object v : values) {
                child.write(null, true, v);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public DataDump dump(@Nullable String key, boolean condition, @Nullable DataDumpable value) {
        if (condition) {
            try (JsonDataDump child = this.child(key);){
                if (null != value) {
                    value.dumpData(child);
                }
            }
        }
        return this;
    }

    public String toString() {
        return this.stringWriter.toString();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private void handleChildClose() {
        if (null != this.child) {
            this.child = null;
        }
    }

    @Override
    public void close() {
        if (this.open) {
            if (!this.first) {
                if (this.easyToRead) {
                    this.out.println();
                    if (null != this.closingPrefix) {
                        int toWrite;
                        for (int toIndent = (this.indentLevel - 1) * 1; toIndent > 0; toIndent -= toWrite) {
                            toWrite = Math.min(toIndent, indentString.length());
                            this.out.print(indentString.substring(0, toWrite));
                        }
                        this.out.print(this.closingPrefix);
                    }
                } else {
                    this.out.print(this.closingPrefix);
                }
            } else if (null != this.closingPrefix) {
                this.out.print(this.closingPrefix);
            }
            if (null == this.parent) {
                this.out.close();
            } else {
                this.parent.handleChildClose();
            }
            this.open = false;
        }
    }

    @Override
    public DataDump dump(@Nonnull String key, @Nullable Collection<? extends DataDumpable> values) {
        if (values != null && !values.isEmpty()) {
            return this.dump(key, true, values);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDump dump(@Nonnull String key, boolean condition, @Nullable Collection<? extends DataDumpable> values) {
        if (!condition || null == values) {
            return this;
        }
        try (JsonDataDump child = this.child(key, "[", "]");){
            for (DataDumpable dataDumpable : values) {
                child.dump(null, dataDumpable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final String toString(@Nonnull DataDumpable dumpable) {
        try (JsonDataDump dump = new JsonDataDump();){
            dumpable.dumpData(dump);
        }
        return dump.toString();
    }

    @Override
    public Level level() {
        return Level.INFO;
    }
}

