/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5.util;

import com.apple.jingle.g5.util.DataDiff;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.StringDataDump;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataDiffSet
implements DataDumpable,
Iterable<DataDiff> {
    private final LinkedList<DataDiff> diffs = new LinkedList();

    @Nonnull
    public DataDiffSet add(@Nonnull DataDiff diff) {
        this.diffs.add(diff);
        return this;
    }

    @Nonnull
    public DataDiffSet test(@Nullable String prefix, @Nonnull String key, @Nullable Object value1, @Nullable Object value2) {
        if (null != value1 && !value1.equals(value2) || null == value1 && null != value2) {
            return this.add(new DataDiff(null == prefix ? key : prefix + "." + key, value1, value2));
        }
        return this;
    }

    @Nonnull
    public <T extends DataDiffable<T>> DataDiffSet test(@Nonnull String prefix, @Nonnull String key, T value1, T value2) {
        if (value1 != value2) {
            if (value1 == null || value2 == null) {
                this.add(new DataDiff(null == prefix ? key : prefix + "." + key, value1, value2));
            } else {
                value1.diff(this, null == prefix ? key : prefix + "." + key, value2);
            }
        }
        return this;
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        for (DataDiff diff : this.diffs) {
            diff.dumpData(dump);
        }
    }

    @Override
    public Iterator<DataDiff> iterator() {
        return this.diffs.iterator();
    }

    public String toString() {
        return StringDataDump.toString(this);
    }
}

