/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5.util;

import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DataDiff
implements DataDumpable {
    @Nonnull
    private final ValidationLevel level;
    @Nonnull
    private final String key;
    @Nonnull
    private final SimpleDictionary properties;
    @Nonnull
    private final String defaultMessageTemplate;
    private final Object value1;
    private final Object value2;

    public DataDiff(@Nonnull String key, Object value1, Object value2) {
        this(ValidationLevel.ERROR, key, "Value \"${value1}\" does not match expected value of \"${value2}\".", value1, value2, MediaUtil.dictionary);
    }

    public DataDiff(@Nonnull ValidationLevel level, @Nonnull String key, @Nonnull String defaultMessageTemplate, Object value1, Object value2, @Nonnull SimpleDictionary properties) {
        this.level = level;
        this.key = key;
        this.defaultMessageTemplate = defaultMessageTemplate;
        this.value1 = value1;
        this.value2 = value2;
        this.properties = properties.readOnlyCopy();
    }

    @Nonnull
    public String getDefaultMessage() {
        try {
            int endNextToken;
            int startNextToken;
            StringBuilder sb = new StringBuilder();
            int cursor = 0;
            while ((startNextToken = this.defaultMessageTemplate.indexOf("${", cursor)) != -1 && (endNextToken = this.defaultMessageTemplate.indexOf(125, startNextToken + 2)) != -1) {
                if (startNextToken > cursor) {
                    sb.append(this.defaultMessageTemplate.substring(cursor, startNextToken));
                }
                cursor = endNextToken + 1;
                String key = this.defaultMessageTemplate.substring(startNextToken + 2, endNextToken);
                if (this.properties.containsKey(key)) {
                    String value = this.properties.get(key);
                    if (null == value) continue;
                    sb.append(value);
                    continue;
                }
                if ("value1".equals(key)) {
                    if (null != this.value1) {
                        sb.append(this.value1.toString());
                        continue;
                    }
                    sb.append("null");
                    continue;
                }
                if ("value2".equals(key)) {
                    if (null != this.value2) {
                        sb.append(this.value2.toString());
                        continue;
                    }
                    sb.append("null");
                    continue;
                }
                throw new IllegalStateException("Unexpected parameter: '" + key + "'");
            }
            if (cursor < this.defaultMessageTemplate.length()) {
                sb.append(this.defaultMessageTemplate.substring(cursor));
            }
            if (sb.indexOf("%") != -1) {
                return String.format(sb.toString(), this.properties.getValues().toArray());
            }
            return sb.toString();
        }
        catch (Exception e) {
            String alternateMessage = this.properties.get("message");
            if (null != alternateMessage) {
                return alternateMessage;
            }
            return this.key + this.properties;
        }
    }

    @Override
    public void dumpData(@Nonnull DataDump dump) {
        dump.write("DataDiff", this.toString());
    }

    public String toString() {
        return this.key + ": " + this.getDefaultMessage();
    }
}

