/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5;

import com.apple.jingle.foghorn.media.ComputeOutputGeometry;
import com.apple.jingle.foghorn.media.types.ColorSpace;
import com.apple.jingle.foghorn.media.types.TargetDevice;
import com.apple.jingle.g5.AudioGrade;
import com.apple.jingle.g5.EncoderVariant;
import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.ValueSet;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum VideoGrade implements MediaGrade
{
    iTunesSD(AudioGrade.Stereo128, TargetDevice.IPOD, ColorSpace.BT601, EncoderVariant.LC, 1500L, Constants.access$000()),
    AtvSD(AudioGrade.Stereo128, TargetDevice.APPLE_TV_SD, ColorSpace.BT709, EncoderVariant.ATV, 1500L, Constants.access$000()),
    Carob480p(AudioGrade.Stereo160, TargetDevice.APPLE_TV_SD, ColorSpace.BT709, EncoderVariant.Carob, 1800L, Constants.access$100()),
    AtvHD(AudioGrade.Stereo160, TargetDevice.APPLE_TV_HD, ColorSpace.BT709, EncoderVariant.ATV, 4000L, Constants.access$200()),
    HDMusicVideo(AudioGrade.Stereo256, TargetDevice.APPLE_TV_HD, ColorSpace.BT709, EncoderVariant.ATV, 4000L, Constants.access$200()),
    Carob720p(AudioGrade.Stereo160, TargetDevice.APPLE_TV_HD, ColorSpace.BT709, EncoderVariant.Carob, 4000L, Constants.access$200()),
    Chocolate(AudioGrade.Stereo160, TargetDevice.ABBY, ColorSpace.BT709, EncoderVariant.Chocolate, 5109L, Constants.access$200()),
    HFR720p(AudioGrade.Stereo160, TargetDevice.ABBY, ColorSpace.BT709, EncoderVariant.Chocolate, 5109L, Constants.access$200()),
    iTunesPlusSD(AudioGrade.Stereo256, Constants.access$100()),
    ProxyEncode(AudioGrade.Stereo64, null, EncoderVariant.HLS, 350L, 672L, 378L, Constants.access$100()),
    HLS05(360L, 544L, 306L, Constants.access$300()),
    HLS07(600L, 544L, 306L, Constants.access$300()),
    HLS10(772L, 544L, 306L, Constants.access$400()),
    HLS20(1072L, 640L, 360L, Constants.access$400()),
    HLS30(1672L, 736L, 414L, Constants.access$400()),
    HLS40(2240L, 864L, 486L, Constants.access$400()),
    HLS50(3340L, 1280L, 720L, Constants.access$400()),
    HLS60(4340L, 1280L, 720L, Constants.access$400()),
    HLS70(5816L, 1920L, 1080L, Constants.access$400()),
    HLS80(7616L, 1920L, 1080L, Constants.access$400()),
    HLS90(11616L, 1920L, 1080L, Constants.access$400()),
    HLS203(250L, 480L, 270L, Constants.access$500()),
    HLS205(350L, 544L, 306L, Constants.access$500()),
    HLS207(500L, 608L, 342L, Constants.access$500()),
    HLS210(750L, 672L, 378L, Constants.access$500()),
    HLS220(1100L, 768L, 432L, Constants.access$500()),
    HLS230(1500L, 864L, 486L, Constants.access$600()),
    HLS240(2100L, 1024L, 576L, Constants.access$500()),
    HLS250(2800L, 1280L, 720L, Constants.access$500()),
    HLS260(3800L, 1280L, 720L, Constants.access$500()),
    HLS265(3800L, 1920L, 1080L, Constants.access$600()),
    HLS270(5000L, 1920L, 1080L, Constants.access$600()),
    HLS280(6500L, 1920L, 1080L, Constants.access$600()),
    HLS290(9700L, 1920L, 1080L, Constants.access$600()),
    HLS305(350L, 480L, 270L, Constants.access$700()),
    HLS307(500L, 544L, 306L, Constants.access$700()),
    HLS310(750L, 608L, 342L, Constants.access$700()),
    HLS320(1100L, 672L, 378L, Constants.access$700()),
    HLS330(1500L, 732L, 432L, Constants.access$700()),
    HLS340(2100L, 864L, 486L, Constants.access$800()),
    HLS350(2800L, 1024L, 576L, Constants.access$700()),
    HLS360(3800L, 1024L, 576L, Constants.access$700()),
    HLS370(5000L, 1280L, 720L, Constants.access$700()),
    HLS380(6500L, 1280L, 720L, Constants.access$700()),
    HLS385(9700L, 1280L, 720L, Constants.access$900()),
    HLS390(9700L, 1920L, 1080L, Constants.access$1000()),
    HEVCHLS505(250L, 480L, 270L, Constants.access$1100()),
    HEVCHLS507(400L, 608L, 342L, Constants.access$1100()),
    HEVCHLS510(575L, 672L, 378L, Constants.access$1100()),
    HEVCHLS520(825L, 768L, 432L, Constants.access$1100()),
    HEVCHLS530(1100L, 864L, 486L, Constants.access$1200()),
    HEVCHLS540(1500L, 1024L, 576L, Constants.access$1100()),
    HEVCHLS550(2100L, 1280L, 720L, Constants.access$1100()),
    HEVCHLS560(2700L, 1280L, 720L, Constants.access$1100()),
    HEVCHLS563(2100L, 1920L, 1080L, Constants.access$1200()),
    HEVCHLS565(2700L, 1920L, 1080L, Constants.access$1200()),
    HEVCHLS570(3800L, 1920L, 1080L, Constants.access$1200()),
    HEVCHLS580(4800L, 1920L, 1080L, Constants.access$1200()),
    HEVCHLS585(6800L, 1920L, 1080L, Constants.access$1200()),
    HEVCHLS587(3800L, 2560L, 1440L, Constants.access$1100()),
    HEVCHLS589(4800L, 2560L, 1440L, Constants.access$1100()),
    HEVCHLS590(6800L, 2560L, 1440L, Constants.access$1100()),
    HEVCHLS591(9700L, 2560L, 1440L, Constants.access$1100()),
    HEVCHLS592(4800L, 3840L, 2160L, Constants.access$1200()),
    HEVCHLS593(6800L, 3840L, 2160L, Constants.access$1200()),
    HEVCHLS595(9700L, 3840L, 2160L, Constants.access$1200()),
    HEVCHLS597(14000L, 3840L, 2160L, Constants.access$1200()),
    HEVCHLS598(20000L, 3840L, 2160L, Constants.access$1200()),
    HEVCHLS605(300L, 480L, 270L, Constants.access$1300()),
    HEVCHLS607(480L, 608L, 342L, Constants.access$1300()),
    HEVCHLS610(690L, 672L, 378L, Constants.access$1300()),
    HEVCHLS620(1000L, 768L, 432L, Constants.access$1300()),
    HEVCHLS630(1300L, 864L, 486L, Constants.access$1400()),
    HEVCHLS640(1800L, 1024L, 576L, Constants.access$1300()),
    HEVCHLS650(2500L, 1280L, 720L, Constants.access$1300()),
    HEVCHLS660(3200L, 1280L, 720L, Constants.access$1300()),
    HEVCHLS663(2500L, 1920L, 1080L, Constants.access$1400()),
    HEVCHLS665(3200L, 1920L, 1080L, Constants.access$1400()),
    HEVCHLS670(4500L, 1920L, 1080L, Constants.access$1400()),
    HEVCHLS680(5800L, 1920L, 1080L, Constants.access$1400()),
    HEVCHLS685(8100L, 1920L, 1080L, Constants.access$1400()),
    HEVCHLS687(4500L, 2560L, 1440L, Constants.access$1300()),
    HEVCHLS689(5800L, 2560L, 1440L, Constants.access$1300()),
    HEVCHLS690(8100L, 2560L, 1440L, Constants.access$1300()),
    HEVCHLS691(11600L, 2560L, 1440L, Constants.access$1300()),
    HEVCHLS692(5800L, 3840L, 2160L, Constants.access$1400()),
    HEVCHLS693(8100L, 3840L, 2160L, Constants.access$1400()),
    HEVCHLS695(11600L, 3840L, 2160L, Constants.access$1400()),
    HEVCHLS697(16800L, 3840L, 2160L, Constants.access$1400()),
    HEVCHLS698(24000L, 3840L, 2160L, Constants.access$1400()),
    HDRHLS705(300L, 480L, 270L, Constants.access$1500()),
    HDRHLS707(480L, 608L, 342L, Constants.access$1500()),
    HDRHLS710(690L, 672L, 378L, Constants.access$1500()),
    HDRHLS720(1000L, 768L, 432L, Constants.access$1500()),
    HDRHLS730(1300L, 864L, 486L, Constants.access$1600()),
    HDRHLS740(1800L, 1024L, 576L, Constants.access$1500()),
    HDRHLS750(2500L, 1280L, 720L, Constants.access$1500()),
    HDRHLS760(3200L, 1280L, 720L, Constants.access$1500()),
    HDRHLS763(2500L, 1920L, 1080L, Constants.access$1600()),
    HDRHLS765(3200L, 1920L, 1080L, Constants.access$1600()),
    HDRHLS770(4500L, 1920L, 1080L, Constants.access$1600()),
    HDRHLS780(5800L, 1920L, 1080L, Constants.access$1600()),
    HDRHLS785(8100L, 1920L, 1080L, Constants.access$1600()),
    HDRHLS787(4500L, 2560L, 1440L, Constants.access$1500()),
    HDRHLS789(5800L, 2560L, 1440L, Constants.access$1500()),
    HDRHLS790(8100L, 2560L, 1440L, Constants.access$1500()),
    HDRHLS791(11600L, 2560L, 1440L, Constants.access$1500()),
    HDRHLS792(5800L, 3840L, 2160L, Constants.access$1600()),
    HDRHLS793(8100L, 3840L, 2160L, Constants.access$1600()),
    HDRHLS795(11600L, 3840L, 2160L, Constants.access$1600()),
    HDRHLS797(16800L, 3840L, 2160L, Constants.access$1600()),
    HDRHLS798(24000L, 3840L, 2160L, Constants.access$1600()),
    HDRHLS805(360L, 480L, 270L, Constants.access$1700()),
    HDRHLS807(580L, 608L, 342L, Constants.access$1700()),
    HDRHLS810(830L, 672L, 378L, Constants.access$1700()),
    HDRHLS820(1200L, 768L, 432L, Constants.access$1700()),
    HDRHLS830(1560L, 864L, 486L, Constants.access$1800()),
    HDRHLS840(2200L, 1024L, 576L, Constants.access$1700()),
    HDRHLS850(3000L, 1280L, 720L, Constants.access$1700()),
    HDRHLS860(3850L, 1280L, 720L, Constants.access$1700()),
    HDRHLS863(3000L, 1920L, 1080L, Constants.access$1800()),
    HDRHLS865(3850L, 1920L, 1080L, Constants.access$1800()),
    HDRHLS870(5400L, 1920L, 1080L, Constants.access$1800()),
    HDRHLS880(7000L, 1920L, 1080L, Constants.access$1800()),
    HDRHLS885(9700L, 1920L, 1080L, Constants.access$1800()),
    HDRHLS887(5400L, 2560L, 1440L, Constants.access$1700()),
    HDRHLS889(7000L, 2560L, 1440L, Constants.access$1700()),
    HDRHLS890(9700L, 2560L, 1440L, Constants.access$1700()),
    HDRHLS891(13900L, 2560L, 1440L, Constants.access$1700()),
    HDRHLS892(7000L, 3840L, 2160L, Constants.access$1800()),
    HDRHLS893(9700L, 3840L, 2160L, Constants.access$1800()),
    HDRHLS895(13900L, 3840L, 2160L, Constants.access$1800()),
    HDRHLS897(20000L, 3840L, 2160L, Constants.access$1800()),
    HDRHLS898(28800L, 3840L, 2160L, Constants.access$1800()),
    TESTHLS905(360L, 480L, 270L, Constants.access$1900()),
    TESTHLS907(690L, 608L, 342L, Constants.access$1900()),
    TESTHLS910(1300L, 672L, 378L, Constants.access$1900()),
    TESTHLS920(1800L, 768L, 432L, Constants.access$1900()),
    TESTHLS930(2500L, 864L, 486L, Constants.access$2000()),
    TESTHLS940(3200L, 1024L, 576L, Constants.access$1900()),
    TESTHLS950(3800L, 1280L, 720L, Constants.access$1900()),
    TESTHLS960(4500L, 1280L, 720L, Constants.access$1900()),
    TESTHLS963(5800L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS965(6800L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS970(8100L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS980(9700L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS985(11600L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS990(11600L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS991(13900L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS992(16800L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS993(20000L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS995(24000L, 1920L, 1080L, Constants.access$2000()),
    TESTHLS997(28800L, 1920L, 1080L, Constants.access$2000()),
    ANY(null, Constants.access$100());

    public final AudioGrade stereoGrade;
    public final ColorSpace transcodeColorSpace;
    public final EncoderVariant encoderVariant;
    public final ComputeOutputGeometry.Computer computer;
    public final long dataRate;
    @Nonnull
    private final EnumSet<GradeTag> gradeTags;
    @Nullable
    public final Long width;
    @Nullable
    public final Long height;
    @Nullable
    private transient IndexedMapKey<MediaGrade> indexKey;
    private static final int MEDIA_GRADE_TYPE_ID = 3;
    public static Predicate<VideoGrade> isVod;
    public static Predicate<VideoGrade> isSDVod;
    public static Predicate<VideoGrade> isHDVod;
    public static Predicate<VideoGrade> isAnyHls;
    public static Predicate<VideoGrade> isRegularVODVideo;
    public static Predicate<VideoGrade> isRegularHlsVideo;
    public static Predicate<VideoGrade> isTestHlsVideo;
    public static Predicate<VideoGrade> isHdrHlsVideo;
    public static Predicate<VideoGrade> isHdrHlsVideoExcluding30Fps;
    public static Predicate<VideoGrade> isHdr30FpsHlsVideo;
    public static Predicate<VideoGrade> isSdrHevcHlsVideoExcluding30Fps;
    public static Predicate<VideoGrade> isSdrHevcHlsVideo;
    public static Predicate<VideoGrade> isSdrHevc30FpsHlsVideo;
    public static Predicate<VideoGrade> isForCellular;
    public static Predicate<VideoGrade> isAverageBWBasedHls;
    public static Predicate<VideoGrade> isAverageBWBasedHlsExcludingTestHLS;
    public static Predicate<VideoGrade> isAverageBWBasedHFRHls;
    public static Predicate<VideoGrade> isAverageBWBasedInterlacedSourceHFRHls;
    public static Predicate<VideoGrade> isAverageBWBasedProgressiveSourceHFRHls;
    public static Predicate<VideoGrade> isPeakBWHLSVideo;
    public static Predicate<VideoGrade> isAverageBWHLSVideo;
    private static final long MAX_SD_HEIGHT = 720L;
    private static final long MAX_HD_HEIGHT = 1080L;
    private static final long MAX_4K_HEIGHT = 2160L;

    private VideoGrade(@Nullable AudioGrade stereoGrade, @Nullable TargetDevice targetDevice, ColorSpace transcodeColorSpace, @Nonnull EncoderVariant encoderVariant, long dataRate, EnumSet<GradeTag> grades) {
        this(stereoGrade, transcodeColorSpace, encoderVariant, ComputeOutputGeometry.VOD.createComputer(targetDevice), dataRate, null, null, grades);
    }

    private VideoGrade(long dataRate, @Nonnull long width, long height, EnumSet<GradeTag> grades) {
        this(null, null, EncoderVariant.HLS, ComputeOutputGeometry.HLS.createComputer(height, width), dataRate, width, height, grades);
    }

    private VideoGrade(AudioGrade stereoGrade, ColorSpace transcodeColorSpace, EncoderVariant encoderVariant, long dataRate, @Nonnull long width, long height, EnumSet<GradeTag> grades) {
        this(stereoGrade, transcodeColorSpace, encoderVariant, ComputeOutputGeometry.HLS.createComputer(height, width), dataRate, width, height, grades);
    }

    private VideoGrade(AudioGrade audioGrade, EnumSet<GradeTag> grades) {
        this(audioGrade, null, null, null, 0L, grades);
    }

    private VideoGrade(AudioGrade stereoGrade, ColorSpace transcodeColorSpace, EncoderVariant encoderVariant, @Nullable ComputeOutputGeometry.Computer computer, @Nullable long dataRate, @Nonnull Long width, Long height, EnumSet<GradeTag> gradeTags) {
        this.stereoGrade = stereoGrade;
        this.transcodeColorSpace = transcodeColorSpace;
        this.encoderVariant = encoderVariant;
        this.dataRate = dataRate;
        this.width = width;
        this.height = height;
        this.gradeTags = gradeTags;
        this.computer = computer;
    }

    @Override
    public IndexedMapKey<MediaGrade> indexKey() {
        if (this.indexKey == null) {
            this.indexKey = new IndexedMapKey<VideoGrade>(indexKeyType, this);
        }
        return this.indexKey;
    }

    @Override
    @Nonnull
    public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
        values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
    }

    public boolean isAnyHls() {
        return this.hasTag(GradeTag.anyHls);
    }

    public boolean isRegularHls() {
        return this.hasTag(GradeTag.regularHlsVideo);
    }

    public boolean isTestHls() {
        return this.hasTag(GradeTag.testHlsVideo);
    }

    public boolean isCellularHls() {
        return this.hasTag(GradeTag.cellularHlsVideo);
    }

    public boolean isHdrHls() {
        return this.hasTag(GradeTag.hdrHlsVideo);
    }

    public boolean isHdr30FpsHls() {
        return this.hasTag(GradeTag.hdrHlsVideo) && this.hasTag(GradeTag.thirtyFpsVideo);
    }

    public boolean isSdrHevcHls() {
        return this.hasTag(GradeTag.sdrHevcHLSVideo);
    }

    public boolean isSdrHevc30FpsHls() {
        return this.hasTag(GradeTag.sdrHevcHLSVideo) && this.hasTag(GradeTag.thirtyFpsVideo);
    }

    public boolean isAverageBWBasedHls() {
        return this.hasTag(GradeTag.averageBWBasedHLSVideo);
    }

    public boolean isAverageBWBasedHlsExcludingTestHLS() {
        return this.hasTag(GradeTag.averageBWBasedHLSVideo) && !this.hasTag(GradeTag.testHlsVideo);
    }

    public boolean isAverageBWBasedHFRHls() {
        return this.isAverageBWBasedInterlacedSourceHFRHls() || this.isAverageBWBasedProgressiveSourceHFRHls();
    }

    public boolean isAverageBWBasedInterlacedSourceHFRHls() {
        return this.hasTag(GradeTag.averageBWBasedInterlacedSourceHFRHLSVideo);
    }

    public boolean isAverageBWBasedProgressiveSourceHFRHls() {
        return this.hasTag(GradeTag.averageBWBasedProgressiveSourceHFRHLSVideo);
    }

    public boolean isVideoOnDemand() {
        return this.hasTag(GradeTag.videoOnDemand);
    }

    public boolean isHDVOD() {
        return this.hasTag(GradeTag.hdVideoOnDemand);
    }

    public boolean supportsHFR() {
        return !this.hasTag(GradeTag.doesNotSupportHFR);
    }

    public boolean isBounded() {
        return this.hasTag(GradeTag.boundedGrade);
    }

    public boolean hasTag(@Nullable GradeTag tag) {
        return this.gradeTags.contains((Object)tag);
    }

    @Override
    public boolean meetsCriteria(@Nonnull MediaFeature feature) {
        return feature.getMediaGrade() == this;
    }

    public static EnumSet<VideoGrade> regularVODVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isRegularVODVideo));
    }

    public static EnumSet<VideoGrade> regularHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isRegularHlsVideo));
    }

    public static EnumSet<VideoGrade> testHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isTestHlsVideo));
    }

    public static EnumSet<VideoGrade> averageBWBasedHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isAverageBWBasedHlsExcludingTestHLS));
    }

    public static EnumSet<VideoGrade> averageBWBasedHFRHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isAverageBWBasedHFRHls));
    }

    public static EnumSet<VideoGrade> averageBWBasedInterlacedSourceHFRHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isAverageBWBasedInterlacedSourceHFRHls));
    }

    public static EnumSet<VideoGrade> averageBWBasedProgressiveSourceHFRHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isAverageBWBasedProgressiveSourceHFRHls));
    }

    public static EnumSet<VideoGrade> hdrHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isHdrHlsVideoExcluding30Fps));
    }

    public static EnumSet<VideoGrade> hdr30FpsHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isHdr30FpsHlsVideo));
    }

    public static EnumSet<VideoGrade> sdrHevcHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isSdrHevcHlsVideoExcluding30Fps));
    }

    public static EnumSet<VideoGrade> sdrHevc30FpsHlsVideoGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isSdrHevc30FpsHlsVideo));
    }

    public static EnumSet<VideoGrade> sdVodGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isSDVod));
    }

    public static EnumSet<VideoGrade> hdVodGrades() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), isHDVod));
    }

    public static EnumSet<VideoGrade> hlsVideoGradesForNonCellular() {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), (Predicate)Predicates.and(isRegularHlsVideo, (Predicate)Predicates.not(isForCellular))));
    }

    public static EnumSet<VideoGrade> grades(@Nonnull Predicate<VideoGrade> predicate) {
        return EnumSet.copyOf(Collections2.filter(Arrays.asList(VideoGrade.values()), predicate));
    }

    @Nonnull
    public static VideoGrade videoGradeForName(@Nonnull String name) {
        return VideoGrade.valueOf(name);
    }

    @Override
    public int getMediaGradeTypeId() {
        return 3;
    }

    @Override
    public String getName() {
        return this.name();
    }

    public static VideoGrade gradeOf(String gradeName) {
        if (gradeName != null && !gradeName.isEmpty()) {
            try {
                return VideoGrade.valueOf(gradeName);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isSD(String gradeName) {
        VideoGrade videoGrade = VideoGrade.gradeOf(gradeName);
        return videoGrade != null && (videoGrade.isVideoOnDemand() && !videoGrade.isHDVOD() || videoGrade.height != null && videoGrade.height <= 720L);
    }

    public static boolean isHD(String gradeName) {
        VideoGrade videoGrade = VideoGrade.gradeOf(gradeName);
        return videoGrade != null && (videoGrade.isHDVOD() || videoGrade.height != null && videoGrade.height > 720L && videoGrade.height <= 1080L);
    }

    public static boolean is4K(String gradeName) {
        VideoGrade videoGrade = VideoGrade.gradeOf(gradeName);
        return videoGrade != null && videoGrade.height != null && videoGrade.height > 1080L && videoGrade.height <= 2160L;
    }

    public static boolean isHEVC(String gradeName) {
        VideoGrade videoGrade = VideoGrade.gradeOf(gradeName);
        return videoGrade != null && (videoGrade.isHdrHls() || videoGrade.isSdrHevcHls());
    }

    public static boolean isHDR(String gradeName) {
        VideoGrade videoGrade = VideoGrade.gradeOf(gradeName);
        return videoGrade != null && videoGrade.isHdrHls();
    }

    static {
        isVod = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isVideoOnDemand();
            }
        };
        isSDVod = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isVideoOnDemand() && !grade.isHDVOD();
            }
        };
        isHDVod = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isVideoOnDemand() && grade.isHDVOD();
            }
        };
        isAnyHls = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isAnyHls();
            }
        };
        isRegularVODVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isVideoOnDemand();
            }
        };
        isRegularHlsVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isRegularHls();
            }
        };
        isTestHlsVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isTestHls();
            }
        };
        isHdrHlsVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isHdrHls();
            }
        };
        isHdrHlsVideoExcluding30Fps = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isHdrHls() && !grade.isHdr30FpsHls();
            }
        };
        isHdr30FpsHlsVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isHdr30FpsHls();
            }
        };
        isSdrHevcHlsVideoExcluding30Fps = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isSdrHevcHls() && !grade.isSdrHevc30FpsHls();
            }
        };
        isSdrHevcHlsVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isSdrHevcHls();
            }
        };
        isSdrHevc30FpsHlsVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isSdrHevc30FpsHls();
            }
        };
        isForCellular = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isCellularHls();
            }
        };
        isAverageBWBasedHls = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isAverageBWBasedHls();
            }
        };
        isAverageBWBasedHlsExcludingTestHLS = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isAverageBWBasedHlsExcludingTestHLS();
            }
        };
        isAverageBWBasedHFRHls = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isAverageBWBasedHFRHls();
            }
        };
        isAverageBWBasedInterlacedSourceHFRHls = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isAverageBWBasedInterlacedSourceHFRHls();
            }
        };
        isAverageBWBasedProgressiveSourceHFRHls = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isAverageBWBasedProgressiveSourceHFRHls();
            }
        };
        isPeakBWHLSVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && grade.isRegularHls();
            }
        };
        isAverageBWHLSVideo = new Predicate<VideoGrade>(){

            public boolean apply(@Nullable VideoGrade grade) {
                return grade != null && (grade.isAverageBWBasedHls() || grade.isAverageBWBasedHFRHls());
            }
        };
    }

    private static enum GradeTag {
        regularHlsVideo,
        cellularHlsVideo,
        hdrHlsVideo,
        averageBWBasedHLSVideo,
        averageBWBasedHFRHLSVideo,
        averageBWBasedInterlacedSourceHFRHLSVideo,
        averageBWBasedProgressiveSourceHFRHLSVideo,
        sdrHevcHLSVideo,
        anyHls,
        videoOnDemand,
        hdVideoOnDemand,
        doesNotSupportHFR,
        testHlsVideo,
        thirtyFpsVideo,
        boundedGrade;

    }

    private static final class Constants {
        private static final EnumSet<GradeTag> VOD_TAGS = EnumSet.of(GradeTag.videoOnDemand);
        private static final EnumSet<GradeTag> HD_VOD_TAGS = EnumSet.of(GradeTag.videoOnDemand, GradeTag.hdVideoOnDemand);
        private static final EnumSet<GradeTag> VOD_GRADE_NOT_SUPPORTING_HFR_TAGS = EnumSet.of(GradeTag.videoOnDemand, GradeTag.doesNotSupportHFR);
        private static final EnumSet<GradeTag> REGULAR_HLS_TAGS = EnumSet.of(GradeTag.regularHlsVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> CELLULAR_HLS_TAGS = EnumSet.of(GradeTag.regularHlsVideo, GradeTag.cellularHlsVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> TEST_HLS_TAGS = EnumSet.of(GradeTag.testHlsVideo, GradeTag.averageBWBasedHLSVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> HDR_HLS_TAGS = EnumSet.of(GradeTag.hdrHlsVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> HDR_30FPS_HLS_TAGS = EnumSet.of(GradeTag.hdrHlsVideo, GradeTag.thirtyFpsVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> SDR_HEVC_HLS_TAGS = EnumSet.of(GradeTag.sdrHevcHLSVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> SDR_HEVC_30FPS_HLS_TAGS = EnumSet.of(GradeTag.sdrHevcHLSVideo, GradeTag.thirtyFpsVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> AVERAGE_BW_BASED_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedHLSVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> AVERAGE_BW_BASED_HFR_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedInterlacedSourceHFRHLSVideo, GradeTag.averageBWBasedProgressiveSourceHFRHLSVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> AVERAGE_BW_BASED_INTERLACED_SOURCE_HFR_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedInterlacedSourceHFRHLSVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> AVERAGE_BW_BASED_PROGRESSIVE_SOURCE_HFR_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedProgressiveSourceHFRHLSVideo, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_TEST_HLS_TAGS = EnumSet.of(GradeTag.testHlsVideo, GradeTag.averageBWBasedHLSVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_HDR_HLS_TAGS = EnumSet.of(GradeTag.hdrHlsVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_HDR_30FPS_HLS_TAGS = EnumSet.of(GradeTag.hdrHlsVideo, GradeTag.thirtyFpsVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_SDR_HEVC_HLS_TAGS = EnumSet.of(GradeTag.sdrHevcHLSVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_SDR_HEVC_30FPS_HLS_TAGS = EnumSet.of(GradeTag.sdrHevcHLSVideo, GradeTag.thirtyFpsVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_AVERAGE_BW_BASED_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedHLSVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_AVERAGE_BW_BASED_HFR_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedInterlacedSourceHFRHLSVideo, GradeTag.averageBWBasedProgressiveSourceHFRHLSVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_AVERAGE_BW_BASED_INTERLACED_SOURCE_HFR_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedInterlacedSourceHFRHLSVideo, GradeTag.boundedGrade, GradeTag.anyHls);
        private static final EnumSet<GradeTag> BB_AVERAGE_BW_BASED_PROGRESSIVE_SOURCE_HFR_HLS_TAGS = EnumSet.of(GradeTag.averageBWBasedProgressiveSourceHFRHLSVideo, GradeTag.boundedGrade, GradeTag.anyHls);

        private Constants() {
        }

        static /* synthetic */ EnumSet access$000() {
            return VOD_GRADE_NOT_SUPPORTING_HFR_TAGS;
        }

        static /* synthetic */ EnumSet access$100() {
            return VOD_TAGS;
        }

        static /* synthetic */ EnumSet access$200() {
            return HD_VOD_TAGS;
        }

        static /* synthetic */ EnumSet access$300() {
            return CELLULAR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$400() {
            return REGULAR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$500() {
            return AVERAGE_BW_BASED_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$600() {
            return BB_AVERAGE_BW_BASED_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$700() {
            return AVERAGE_BW_BASED_HFR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$800() {
            return BB_AVERAGE_BW_BASED_HFR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$900() {
            return AVERAGE_BW_BASED_PROGRESSIVE_SOURCE_HFR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1000() {
            return BB_AVERAGE_BW_BASED_INTERLACED_SOURCE_HFR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1100() {
            return SDR_HEVC_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1200() {
            return BB_SDR_HEVC_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1300() {
            return SDR_HEVC_30FPS_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1400() {
            return BB_SDR_HEVC_30FPS_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1500() {
            return HDR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1600() {
            return BB_HDR_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1700() {
            return HDR_30FPS_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1800() {
            return BB_HDR_30FPS_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$1900() {
            return TEST_HLS_TAGS;
        }

        static /* synthetic */ EnumSet access$2000() {
            return BB_TEST_HLS_TAGS;
        }
    }
}

