/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5;

import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.g5.MediaKind;
import com.apple.jingle.leghorn.media.MediaFeatureCriteria;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.feature.MediaFormat;
import com.apple.jingle.leghorn.media.feature.SourceAudioGrade;
import com.apple.jingle.leghorn.media.index.IndexedMapFilter;
import com.apple.jingle.leghorn.media.index.ValueSetFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public enum G5ContentAnalysisType {
    FirstLastFrameAnalysis(FeatureKind.FIRST_FRAME_ANALYSIS, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    CropAnalysis(FeatureKind.CROP_ANALYSIS, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    VideoQualityReport(FeatureKind.VIDEO_QUALITY_REPORT, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    InterleaveAnalysis(FeatureKind.INTERLEAVE_ANALYSIS, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    DupFrameAnalysis(FeatureKind.DUPFRAME_ANALYSIS, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    DetectUpscalingAnalysis(FeatureKind.DETECTUPSCALING_ANALYSIS, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    CompareVideoSourcesAnalysis(FeatureKind.COMPARE_VIDEO_SOURCES_ANALYSIS, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    AlignSceneCutsAnalysis(FeatureKind.ALIGNSCENECUTS_ANALYSIS, FeatureKind.VIDEO, null, new IndexedMapFilter[0]),
    AudioEnvelopeStereo(FeatureKind.AUDIO_ENVELOPE, FeatureKind.AUDIO, SourceAudioGrade.stereo, new IndexedMapFilter[0]),
    AudioEnvelopeSurround51(FeatureKind.AUDIO_ENVELOPE, FeatureKind.AUDIO, SourceAudioGrade.surround_5_1, new IndexedMapFilter[0]),
    AudioEnvelopeSurround71(FeatureKind.AUDIO_ENVELOPE, FeatureKind.AUDIO, SourceAudioGrade.surround_7_1, new IndexedMapFilter[0]),
    AudioLoudnessAnalysis(FeatureKind.LOUDNESS_ANALYSIS, FeatureKind.AUDIO, null, new IndexedMapFilter[0]),
    AudioSpatialComplexityAnalysis(FeatureKind.SPATIAL_COMPLEXITY_ANALYSIS, FeatureKind.AUDIO, null, new IndexedMapFilter[0]),
    DvsEnvelopeStereo(FeatureKind.DVS_ENVELOPE, FeatureKind.DVS, SourceAudioGrade.stereo, new IndexedMapFilter[0]),
    DvsEnvelopeSurround51(FeatureKind.DVS_ENVELOPE, FeatureKind.DVS, SourceAudioGrade.surround_5_1, new IndexedMapFilter[0]),
    DvsEnvelopeSurround71(FeatureKind.DVS_ENVELOPE, FeatureKind.DVS, SourceAudioGrade.surround_7_1, new IndexedMapFilter[0]),
    MonoAudioAnalysis(FeatureKind.MONOAUDIO_ANALYSIS, FeatureKind.AUDIO, SourceAudioGrade.stereo, new IndexedMapFilter[0]),
    ClipAudioAnalysis(FeatureKind.AUDIOCLIPPING_ANALYSIS, FeatureKind.AUDIO, SourceAudioGrade.stereo, new IndexedMapFilter[0]),
    FaceDetectionInImageAnalysis(FeatureKind.FACEDETECT_ANALYSIS, FeatureKind.PRODUCTION_STILL, null, new IndexedMapFilter[0]);

    private static final Map<Pair<FeatureKind, MediaGrade>, G5ContentAnalysisType> featureKindMap;
    @Nonnull
    private final FeatureKind featureKind;
    @Nullable
    private final MediaGrade mediaGrade;
    @Nonnull
    private final Collection<IndexedMapFilter<? super MediaFeature>> intermediateCriteria;
    @Nonnull
    private final FeatureKind sourceFeatureKind;
    @Nonnull
    private final Collection<IndexedMapFilter<? super MediaFeature>> sourceCriteria;
    public static final ValueSetFilter<MediaFeature> analysisFeatureCriteria;

    @SafeVarargs
    private G5ContentAnalysisType(@Nullable FeatureKind featureKind, @Nonnull FeatureKind sourceFeatureKind, MediaGrade mediaGrade, IndexedMapFilter<? super MediaFeature> ... sourceCriteria) {
        this.featureKind = featureKind;
        this.mediaGrade = mediaGrade;
        this.intermediateCriteria = Arrays.asList(new MediaFeatureCriteria.MediaNameCriteria(this.name()));
        this.sourceFeatureKind = sourceFeatureKind;
        this.sourceCriteria = Arrays.asList(sourceCriteria);
    }

    @Nonnull
    public FeatureKind getFeatureKind() {
        return this.featureKind;
    }

    @Nullable
    public MediaGrade mediaGrade() {
        return this.mediaGrade;
    }

    @Nonnull
    public Collection<IndexedMapFilter<? super MediaFeature>> getIntermediaCriteria() {
        return this.intermediateCriteria;
    }

    @Nonnull
    public FeatureKind getSourceFeatureKind() {
        return this.sourceFeatureKind;
    }

    @Nonnull
    public Collection<IndexedMapFilter<? super MediaFeature>> getSourceCriteria() {
        return this.sourceCriteria;
    }

    @Nonnull
    public static final G5ContentAnalysisType typeFor(@Nonnull FeatureKind featureKind, @Nullable MediaFormat mediaFormat) {
        G5ContentAnalysisType value = featureKindMap.get(Pair.of((Object)featureKind, (Object)mediaFormat));
        if (null != value) {
            return value;
        }
        throw new NoSuchElementException(G5ContentAnalysisType.class.getSimpleName() + "[" + featureKind.name() + "]");
    }

    @Nonnull
    public static final G5ContentAnalysisType typeForFilename(String filename) {
        if (filename.toLowerCase().endsWith("blackanalysis.json")) {
            return FirstLastFrameAnalysis;
        }
        if (filename.toLowerCase().endsWith("cropanalysis.json")) {
            return CropAnalysis;
        }
        if (filename.toLowerCase().endsWith("interleaveanalysis.json")) {
            return InterleaveAnalysis;
        }
        if (filename.toLowerCase().endsWith("loudness.xml") || filename.toLowerCase().endsWith("loudness.json")) {
            return AudioLoudnessAnalysis;
        }
        if (filename.toLowerCase().endsWith("spatialCplx.xml")) {
            return AudioSpatialComplexityAnalysis;
        }
        throw new NoSuchElementException("No suitable " + G5ContentAnalysisType.class.getSimpleName() + " found for " + filename);
    }

    static {
        featureKindMap = new HashMap<Pair<FeatureKind, MediaGrade>, G5ContentAnalysisType>();
        for (G5ContentAnalysisType type : G5ContentAnalysisType.values()) {
            featureKindMap.put((Pair<FeatureKind, MediaGrade>)Pair.of((Object)type.featureKind, (Object)type.mediaGrade), type);
            if (type.featureKind.getMediaKind() != MediaKind.AUDIO) continue;
            featureKindMap.put((Pair<FeatureKind, MediaGrade>)Pair.of((Object)FeatureKind.AUDIO, (Object)type.mediaGrade), type);
        }
        analysisFeatureCriteria = new ValueSetFilter<MediaFeature>(){

            @Override
            public boolean meetsCriteria(@Nonnull MediaFeature feature) {
                return featureKindMap.containsKey(feature.getFeatureKind());
            }
        };
    }
}

