/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5;

import com.apple.jingle.foghorn.media.types.AudioCodec;
import com.apple.jingle.g5.MediaGrade;
import com.apple.jingle.leghorn.media.feature.AudioFormat;
import com.apple.jingle.leghorn.media.feature.MediaAudioChannel;
import com.apple.jingle.leghorn.media.feature.MediaFeature;
import com.apple.jingle.leghorn.media.file.MediaSoundTrack;
import com.apple.jingle.leghorn.media.index.IndexedMap;
import com.apple.jingle.leghorn.media.index.IndexedMapKey;
import com.apple.jingle.leghorn.media.index.ValueSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum AudioGrade implements MediaGrade,
Serializable
{
    Stereo32w32(AudioCodec.HEAACv2, false, 32L, 32000L, 2, AudioFormat.stereo),
    Stereo32w441(AudioCodec.HEAACv2, false, 32L, 44100L, 2, AudioFormat.stereo),
    Stereo64(AudioCodec.AAC, false, 64L, 44100L, 2, AudioFormat.stereo),
    Stereo128(AudioCodec.AAC, false, 128L, 44100L, 2, AudioFormat.stereo),
    Stereo160(AudioCodec.AAC, false, 160L, 48000L, 2, AudioFormat.stereo),
    Stereo256(AudioCodec.AAC, false, 256L, 48000L, 2, AudioFormat.stereo),
    Surround192(AudioCodec.AC3, true, 192L, 48000L, 6, AudioFormat.surround_5_1),
    Surround384(AudioCodec.AC3, true, 384L, 48000L, 6, AudioFormat.surround_5_1),
    Surround640(AudioCodec.EC3, true, 640L, 48000L, 8, AudioFormat.surround_7_1),
    Surround51DDP(AudioCodec.EC3, true, 384L, 48000L, 6, AudioFormat.surround_5_1),
    Surround51DD(AudioCodec.AC3, true, 384L, 48000L, 6, AudioFormat.surround_5_1),
    Surround51DD71SRC(AudioCodec.AC3, true, 384L, 48000L, 8, AudioFormat.surround_7_1),
    Surround71DDP(AudioCodec.EC3, true, 640L, 48000L, 8, AudioFormat.surround_7_1),
    ATMOS(AudioCodec.EC3, true, 448L, 48000L, 8, AudioFormat.objectBased),
    ANY(AudioCodec.ANY, false, 0L, 0L, 0, AudioFormat.stereo);

    public final long dataRate;
    public final long sampleRate;
    public final boolean isSurround;
    public final AudioCodec codec;
    public final int channelCount;
    @Nonnull
    public final AudioFormat audioFormat;
    @Nullable
    private transient IndexedMapKey<MediaGrade> indexKey;
    private static final int MEDIA_GRADE_TYPE_ID = 2;
    public static final Comparator<AudioGrade> loudnessAnalysisGradeCompator;

    private AudioGrade(AudioCodec codec, boolean surround, long dataRate, @Nonnull long sampleRate, int channelCount, AudioFormat audioFormat) {
        this.codec = codec;
        this.isSurround = surround;
        this.dataRate = dataRate;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
        this.audioFormat = audioFormat;
    }

    @Override
    public IndexedMapKey<MediaGrade> indexKey() {
        if (this.indexKey == null) {
            this.indexKey = new IndexedMapKey<AudioGrade>(indexKeyType, this);
        }
        return this.indexKey;
    }

    @Override
    @Nonnull
    public void filter(@Nonnull IndexedMap<? extends Object> indexedMap, ValueSet<? extends Object> values) {
        values.retainAll(indexedMap.getValuesForKey(this.indexKey()));
    }

    @Override
    public boolean meetsCriteria(@Nonnull MediaFeature feature) {
        return feature.getMediaGrade() == this;
    }

    @Nonnull
    public static final AudioGrade gradeAudio(@Nonnull EnumMap<MediaAudioChannel, ? extends MediaSoundTrack> audioTracks, @Nonnull AudioGrade defaultGrade) {
        Set<MediaAudioChannel> audioChannels = audioTracks.keySet();
        long dataRate = -1L;
        long sampleRate = -1L;
        for (MediaSoundTrack mediaSoundTrack : audioTracks.values()) {
            BigDecimal trackDataRate;
            long trackSampleRate = mediaSoundTrack.getSampleRate().longValue();
            if (sampleRate == -1L || sampleRate < trackSampleRate) {
                sampleRate = trackSampleRate;
            }
            if ((trackDataRate = mediaSoundTrack.dataRateInBps().tryGet()) == null || dataRate != -1L && dataRate >= trackDataRate.longValue()) continue;
            dataRate = trackDataRate.longValue();
        }
        if (audioChannels.size() >= 6) {
            return Surround384;
        }
        if (audioChannels.size() == 2) {
            if ((double)dataRate >= 230400.0) {
                return Stereo256;
            }
            if ((double)dataRate >= 144000.0) {
                return Stereo160;
            }
            if ((double)dataRate >= 115200.0) {
                return Stereo128;
            }
            if ((double)dataRate >= 57600.0) {
                return Stereo64;
            }
            if ((double)dataRate >= 28800.0) {
                if (sampleRate >= 44100L) {
                    return Stereo32w441;
                }
                return Stereo32w32;
            }
        }
        return defaultGrade;
    }

    @Nullable
    public static final AudioGrade audioGradeForName(@Nonnull String name) {
        return AudioGrade.valueOf(name);
    }

    @Override
    public int getMediaGradeTypeId() {
        return 2;
    }

    @Override
    public String getName() {
        return this.name();
    }

    public static AudioGrade gradeOf(String gradeName) {
        if (gradeName != null && !gradeName.isEmpty()) {
            try {
                return AudioGrade.valueOf(gradeName);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isSurround51(String gradeName) {
        AudioGrade audioGrade = AudioGrade.gradeOf(gradeName);
        return audioGrade == Surround51DD71SRC || audioGrade.audioFormat == AudioFormat.surround_5_1;
    }

    static {
        loudnessAnalysisGradeCompator = new Comparator<AudioGrade>(){

            @Override
            public int compare(AudioGrade e1, AudioGrade e2) {
                int diff = e1.channelCount - e2.channelCount;
                if (diff == 0) {
                    diff = e1.ordinal() - e2.ordinal();
                }
                return diff;
            }
        };
    }
}

