/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.g5;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.types.DeinterlaceMode;
import com.apple.jingle.g5.AudioGrade;
import com.apple.jingle.g5.CombiningPreference;
import com.apple.jingle.g5.G5ContentAnalysisType;
import com.apple.jingle.g5.MediaAudioType;
import com.apple.jingle.g5.MediaKind;
import com.apple.jingle.g5.MediaSubKind;
import com.apple.jingle.g5.VTTVersion;
import com.apple.jingle.g5.VideoGrade;
import com.apple.jingle.leghorn.media.feature.FeatureKind;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AttributeReader {
    @Nonnull
    private final Map<String, String> attributes;

    public AttributeReader(Map<String, String> attributes) {
        this.attributes = attributes != null ? attributes : Maps.newHashMap();
    }

    public static AttributeReader create(Map<String, String> attributes) {
        return new AttributeReader(attributes);
    }

    public Map<String, String> toMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        this.addToMap(map);
        return map;
    }

    public void addToMap(@Nonnull Map<String, String> map) {
        map.putAll(this.attributes);
    }

    @Nullable
    public String getString(String key) {
        return this.attributes.get(key);
    }

    @Nullable
    public BigDecimal tryGetBigDecimal(String key) {
        String value = this.getString(key);
        if (null != value) {
            try {
                return new BigDecimal(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public Long tryGetLong(String key) {
        String value = this.getString(key);
        if (null != value) {
            try {
                return new Long(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private <T extends Enum<T>> T getEnumFromAttr(Class<T> enumType, String key) {
        T result;
        String attr = this.getString(key);
        if (attr != null) {
            try {
                result = Enum.valueOf(enumType, attr);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        } else {
            result = null;
        }
        return result;
    }

    public Integer originVfcsjPk() {
        String tmp = this.getString("apple.g5.origin.mz_video_file_component_set_join");
        if (null != tmp) {
            String[] ids = tmp.split(",");
            return ids.length > 0 ? Integer.valueOf(Integer.parseInt(ids[0])) : null;
        }
        return null;
    }

    @Nullable
    public String assetFlavor() {
        return this.getString("apple.asset_flavor");
    }

    @Nonnull
    public String assetFlavor(@Nonnull String defaultValue) {
        String value = this.assetFlavor();
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    @Nullable
    public Integer hlsSegmentLength() {
        String tmp = this.getString("apple.g5.intermediate.hls_segment_length");
        if (tmp != null) {
            return Integer.valueOf(tmp);
        }
        return null;
    }

    @Nullable
    public MediaKind mediaKind() {
        return this.getEnumFromAttr(MediaKind.class, "apple.g5.intermediate.media_kind");
    }

    @Nullable
    public FeatureKind featureKind() {
        return this.getEnumFromAttr(FeatureKind.class, "featurekind");
    }

    @Nullable
    public FeatureKind intermediateAnalysisfeatureKind() {
        return this.getEnumFromAttr(FeatureKind.class, "apple.g5.intermediate.analysis.featurekind");
    }

    @Nullable
    public G5ContentAnalysisType g5ContentAnalysisType() {
        return this.getEnumFromAttr(G5ContentAnalysisType.class, "apple.g5.origin.analisys");
    }

    @Nullable
    public Long cutImageMillis() {
        return this.tryGetLong("apple.g5.cutimage.millis");
    }

    @Nullable
    public Long cutPreviewStartMillis() {
        return this.tryGetLong("apple.g5.cutpreview.start.millis");
    }

    @Nullable
    public Long cutPreviewEndMillis() {
        return this.tryGetLong("apple.g5.cutpreview.end.millis");
    }

    @Nullable
    public MediaAudioType mediaAudioType() {
        return this.getEnumFromAttr(MediaAudioType.class, "apple.g5.intermediate.audio_demux_type");
    }

    public VideoGrade videoGrade() {
        return this.getEnumFromAttr(VideoGrade.class, "apple.g5.intermediate.video_grade");
    }

    public AudioGrade audioGrade() {
        return this.getEnumFromAttr(AudioGrade.class, "apple.g5.intermediate.audio_grade");
    }

    public CombiningPreference combiningPreference() {
        return this.getEnumFromAttr(CombiningPreference.class, "apple.g5.intermediate.subtitle.combining_preference");
    }

    public VTTVersion webVTTVersion() {
        return this.getEnumFromAttr(VTTVersion.class, "webvtt.version");
    }

    @Nullable
    public Integer targetWidth() {
        String tmp = this.getString("apple.g5.intermediate.subtitle.target.width");
        if (null != tmp) {
            return Integer.valueOf(tmp);
        }
        return null;
    }

    @Nullable
    public Integer targetHeight() {
        String tmp = this.getString("apple.g5.intermediate.subtitle.target.height");
        if (null != tmp) {
            return Integer.valueOf(tmp);
        }
        return null;
    }

    public MediaSubKind mediaSubKind() {
        return this.getEnumFromAttr(MediaSubKind.class, "apple.g5.intermediate.media_subkind");
    }

    public FrameGeometry.CropRectangle appliedCrop() {
        FrameGeometry.CropRectangle cropRectangle = null;
        String attr = this.getString("apple.g5.intermediate.applied_crop");
        if (attr != null) {
            cropRectangle = new FrameGeometry.CropRectangle(attr);
        }
        return cropRectangle;
    }

    public FrameGeometry.CropRectangle cropRectangle() {
        FrameGeometry.CropRectangle cropRectangle = null;
        String cropTop = this.getString("crop.top");
        String cropBottom = this.getString("crop.bottom");
        String cropLeft = this.getString("crop.left");
        String cropRight = this.getString("crop.right");
        if (cropTop != null || cropBottom != null || cropLeft != null || cropRight != null) {
            cropRectangle = new FrameGeometry.CropRectangle(Util.longForString(cropTop), Util.longForString(cropBottom), Util.longForString(cropLeft), Util.longForString(cropRight));
        }
        return cropRectangle;
    }

    public String displayAspectRatio() {
        return this.getString("image.display_aspect_ratio");
    }

    public DeinterlaceMode deinterlaceMode() {
        DeinterlaceMode deinterlaceMode = null;
        String dimStr = this.getString("video.deinterlace_mode");
        if (dimStr != null) {
            if ("ivt".equals(dimStr)) {
                deinterlaceMode = DeinterlaceMode.IVT;
            } else if ("deinterlace".equals(dimStr)) {
                deinterlaceMode = DeinterlaceMode.DEINTERLACE;
            }
        }
        return deinterlaceMode;
    }

    public String captionsOffset() {
        return this.getString("program.start.timecode");
    }

    public boolean force51Downmix() {
        return Boolean.parseBoolean(this.getString("audio.surround.force_5_1_downmix"));
    }

    public boolean isVoiceOver() {
        return Boolean.parseBoolean(this.getString("audio.voice_over"));
    }

    public boolean isAverageBWBasedHLS() {
        return Boolean.parseBoolean(this.getString("apple.g5.encoding.average.bw.based.hls"));
    }

    public boolean shouldBeFiltered() {
        return Boolean.parseBoolean(this.getString("apple.g5.intermediate.videograde.to.be.filtered"));
    }

    public static abstract class Util {
        public static Map<String, String> copyAndAdd(Map<String, String> attributes, String key, Object value) {
            HashMap copy = Maps.newHashMap();
            if (attributes != null) {
                copy.putAll(attributes);
            }
            if (key != null && value != null) {
                copy.put(key, String.valueOf(value));
            }
            return copy;
        }

        private static long longForString(String stringValue) {
            return stringValue != null ? Long.valueOf(stringValue) : 0L;
        }

        public static void setTargetWidthAndHeight(@Nullable Map<String, String> attributes, long width, long height) {
            if (attributes != null && width > 0L && height > 0L) {
                attributes.put("apple.g5.intermediate.subtitle.target.width", Long.toString(width));
                attributes.put("apple.g5.intermediate.subtitle.target.height", Long.toString(height));
            }
        }
    }
}

