/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.foghorn.media.types;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.FrameGeometryConformer;
import org.apache.log4j.Logger;

public enum TargetDevice {
    IPOD{

        @Override
        public FrameGeometryConformer.ConformerResult targetFrameGeometry(FrameGeometry inputFrameGeometry, double frameRate) {
            double DAR_4x3;
            double displayRatio = inputFrameGeometry.getDisplayAspectRatio();
            FrameGeometryConformer conformer = displayRatio > (DAR_4x3 = 1.3333333333333333) ? new FrameGeometryConformer.IPodAnamorphicConformer() : new FrameGeometryConformer.IPodSquareConformer();
            return conformer.conform(inputFrameGeometry);
        }
    }
    ,
    IPOD_SQUARE{

        @Override
        public FrameGeometryConformer.ConformerResult targetFrameGeometry(FrameGeometry inputFrameGeometry, double frameRate) {
            FrameGeometryConformer.IPodSquareConformer conformer = new FrameGeometryConformer.IPodSquareConformer();
            return conformer.conform(inputFrameGeometry);
        }
    }
    ,
    APPLE_TV_SD{

        @Override
        public FrameGeometryConformer.ConformerResult targetFrameGeometry(FrameGeometry inputFrameGeometry, double frameRate) {
            FrameGeometryConformer.ATVSDConformer conformer = new FrameGeometryConformer.ATVSDConformer();
            return conformer.conform(inputFrameGeometry);
        }
    }
    ,
    APPLE_TV_HD{

        @Override
        public FrameGeometryConformer.ConformerResult targetFrameGeometry(FrameGeometry inputFrameGeometry, double frameRate) {
            FrameGeometryConformer conformer = frameRate > 24.0 && inputFrameGeometry.getCleanDisplayDimensions().getWidth() > 960L ? new FrameGeometryConformer.ATVHDAnamorphicConfomer() : new FrameGeometryConformer.ATVHDConformer();
            return conformer.conform(inputFrameGeometry);
        }
    }
    ,
    ABBY{

        @Override
        public FrameGeometryConformer.ConformerResult targetFrameGeometry(FrameGeometry inputFrameGeometry, double frameRate) {
            FrameGeometry targetGeometry;
            FrameGeometry.Dimensions basicAbbyDimensions = new FrameGeometry.Dimensions(1920L, 1080L);
            if (frameRate > 25.0 && inputFrameGeometry.getDimensions().getWidth() > 1440L) {
                FrameGeometry.Dimensions abbyAnamorphicDimensions = new FrameGeometry.Dimensions(1440L, 1080L);
                targetGeometry = new FrameGeometry("Abby anamorphic (1440x1080, pasp 4-3)", abbyAnamorphicDimensions, new FrameGeometry.Pasp(4L, 3L), FrameGeometry.Clap.identity(abbyAnamorphicDimensions));
            } else if (!inputFrameGeometry.isSquarePixel() && !basicAbbyDimensions.fitsInto(inputFrameGeometry.getDimensions())) {
                FrameGeometry.Pasp sourcePasp = inputFrameGeometry.getPasp();
                long encodedWidth = Math.round((double)basicAbbyDimensions.getWidth() / sourcePasp.asDouble());
                FrameGeometry.Dimensions abbyAnamorphicDimensionsFromSource = new FrameGeometry.Dimensions(encodedWidth, 1080L);
                targetGeometry = new FrameGeometry("Abby anamorphic (generated from Source)", abbyAnamorphicDimensionsFromSource, sourcePasp, FrameGeometry.Clap.identity(abbyAnamorphicDimensionsFromSource));
            } else {
                targetGeometry = new FrameGeometry("Abby square (1920x1080 square)", basicAbbyDimensions, FrameGeometry.Pasp.identity(), FrameGeometry.Clap.identity(basicAbbyDimensions));
            }
            logger.debug((Object)("Abby conformer target: " + targetGeometry));
            FrameGeometryConformer conformer = new FrameGeometryConformer(targetGeometry);
            return conformer.conform(inputFrameGeometry);
        }
    };

    private static final Logger logger;

    public abstract FrameGeometryConformer.ConformerResult targetFrameGeometry(FrameGeometry var1, double var2);

    static {
        logger = Logger.getLogger(TargetDevice.class);
    }
}

