/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.foghorn.media.types;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.Colr;

public enum ColorSpace {
    BT601("601", "1"),
    BT709("709", "2"),
    PAL("PAL", "1"),
    BT2020_PQ("HDR", "-1"),
    BT2020_HLG("HDR", "-1"),
    P3D65_PQ("HDR", "-1");

    private final String toolParameter;
    private final String compressorColorSpec;

    private ColorSpace(String toolParameter, String compressorColorSpec) {
        this.toolParameter = toolParameter;
        this.compressorColorSpec = compressorColorSpec;
    }

    public String getToolParameter() {
        return this.toolParameter;
    }

    public String getCompressorColorSpec() {
        return this.compressorColorSpec;
    }

    @Nullable
    public static ColorSpace valueOf(@Nonnull Colr c) {
        if ("nclc".equalsIgnoreCase(c.getColorParameterType())) {
            return ColorSpace._colorSpaceForNCLCColr(c);
        }
        return null;
    }

    @Nonnull
    public static ColorSpace guess(int primaries, int matrix, int transfer) {
        ColorSpace result = ColorSpace.forIndicies(primaries, matrix, transfer);
        if (null != result) {
            return result;
        }
        if (primaries == 9) {
            return BT2020_PQ;
        }
        if (primaries == 12) {
            return P3D65_PQ;
        }
        if (transfer == 16) {
            return BT2020_PQ;
        }
        if (transfer == 18) {
            return BT2020_HLG;
        }
        if (1 == primaries) {
            return BT709;
        }
        if (6 == primaries) {
            return BT601;
        }
        if (matrix == 1) {
            return BT709;
        }
        return BT601;
    }

    @Nullable
    public static ColorSpace forIndicies(int primaries, int matrix, int transfer) {
        ColorSpace result = primaries == 6 && (transfer == 1 || transfer == 2) && matrix == 6 ? BT601 : (primaries == 1 && transfer == 1 && matrix == 1 ? BT709 : (primaries == 5 && (transfer == 1 || transfer == 2) && matrix == 6 ? PAL : (primaries == 9 && transfer == 16 && matrix == 9 ? BT2020_PQ : (primaries == 9 && transfer == 18 && matrix == 9 ? BT2020_HLG : (primaries == 12 && transfer == 16 && matrix == 1 ? P3D65_PQ : null)))));
        return result;
    }

    @Nullable
    public static ColorSpace _colorSpaceForNCLCColr(Colr c) {
        int primaries = c.getPrimariesIndex();
        int matrix = c.getMatrixIndex();
        int transfer = c.getTransferFunctionIndex();
        return ColorSpace.forIndicies(primaries, matrix, transfer);
    }

    public boolean isHDR() {
        return this.getToolParameter() != null && this.getToolParameter().equalsIgnoreCase("HDR");
    }
}

