/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.foghorn.media;

import com.apple.jingle.foghorn.media.FrameGeometry;
import org.apache.log4j.Logger;

public class FrameGeometryConformer {
    private static Logger logger = Logger.getLogger(FrameGeometryConformer.class);
    private final FrameGeometry _target;

    public FrameGeometry getTarget() {
        return this._target;
    }

    public FrameGeometryConformer(FrameGeometry target) {
        this._target = target;
    }

    public ConformerResult conform(FrameGeometry source) {
        return new ConformerResult(FrameGeometryConformer.nonOddAdjust(FrameGeometryConformer._conform(source, this._target)), source.getCropRectangle());
    }

    private static FrameGeometry nonOddAdjust(FrameGeometry preOddAdjust) {
        boolean oddHeight;
        FrameGeometry.Dimensions preOddAdjustDims = preOddAdjust.getDimensions();
        FrameGeometry.Dimensions postOddAdjustDims = new FrameGeometry.Dimensions(preOddAdjustDims);
        long preOddAdjustWidth = preOddAdjustDims.getWidth();
        long preOddAdjustHeight = preOddAdjustDims.getHeight();
        boolean oddWidth = preOddAdjustWidth % 2L == 1L;
        boolean bl = oddHeight = preOddAdjustHeight % 2L == 1L;
        if (oddWidth) {
            postOddAdjustDims.setWidth(Math.max(preOddAdjustWidth - 1L, 1L));
        }
        if (oddHeight) {
            postOddAdjustDims.setHeight(Math.max(preOddAdjustHeight - 1L, 1L));
        }
        FrameGeometry postOddAdjust = new FrameGeometry(postOddAdjustDims, preOddAdjust.getPasp());
        if (logger.isDebugEnabled() && !preOddAdjustDims.equals(postOddAdjustDims)) {
            logger.debug((Object)("4.  Odd dimension adjust PRE: " + preOddAdjustDims + ", POST: " + postOddAdjustDims));
            logger.debug((Object)("myNewGeometry.DAR " + postOddAdjust.getDisplayAspectRatio()));
        }
        return postOddAdjust;
    }

    private static FrameGeometry _conform(FrameGeometry source, FrameGeometry target) {
        FrameGeometry.Dimensions targetEncodedDims = target.getDimensions();
        FrameGeometry.Dimensions targetDisplayDims = target.getDisplayDimensions();
        FrameGeometry.Dimensions sourceEncodedDims = source.getClap().getCleanDimensions();
        FrameGeometry.Dimensions sourceDisplayDims = source.getCleanDisplayDimensions();
        FrameGeometry.Dimensions mySqueezedDims = sourceDisplayDims.squeezeInto(targetDisplayDims);
        FrameGeometry.Pasp targetPasp = target.getPasp();
        double encodedWidth = (double)mySqueezedDims.getWidth() / targetPasp.asDouble();
        FrameGeometry myNewGeometry = new FrameGeometry(new FrameGeometry.Dimensions(Math.round(encodedWidth), mySqueezedDims.getHeight()), targetPasp);
        myNewGeometry.setName(String.format(">%s< conformed into >%s<", source.getName(), target.getName()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"------------------------------------------");
            logger.debug((Object)("targetPasp " + targetPasp));
            logger.debug((Object)("targetEncodedDims " + targetEncodedDims));
            logger.debug((Object)("targetDisplayDims " + targetDisplayDims));
            logger.debug((Object)("sourcePasp " + source.getPasp()));
            logger.debug((Object)("sourceEncodedDims " + sourceEncodedDims));
            logger.debug((Object)("sourceDisplayDims " + sourceDisplayDims));
            logger.debug((Object)("sourceDAR " + source.getDisplayAspectRatio()));
            logger.debug((Object)"1.  Match Display Aspect Ratios");
            logger.debug((Object)("myNewGeometry.getPasp() " + myNewGeometry.getPasp()));
            logger.debug((Object)("myNewGeometry.getDimensions() " + myNewGeometry.getDimensions()));
            logger.debug((Object)("myNewGeometry.getCleanDisplayDimensions() " + myNewGeometry.getCleanDisplayDimensions()));
            logger.debug((Object)("myNewGeometry.DAR " + myNewGeometry.getDisplayAspectRatio()));
        }
        if (!myNewGeometry.getDimensions().fitsInto(sourceEncodedDims)) {
            myNewGeometry.setPasp(new FrameGeometry.Pasp(targetPasp));
            myNewGeometry.setDimensions(myNewGeometry.getDimensions().squeezeInto(sourceEncodedDims));
            myNewGeometry.setClap(FrameGeometry.Clap.identity(myNewGeometry.getDimensions()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"2.  No Upscaling");
                logger.debug((Object)("myNewGeometry.getPasp() " + myNewGeometry.getPasp()));
                logger.debug((Object)("myNewGeometry.getDimensions() " + myNewGeometry.getDimensions()));
                logger.debug((Object)("myNewGeometry.getCleanDisplayDimensions() " + myNewGeometry.getCleanDisplayDimensions()));
                logger.debug((Object)("myNewGeometry.DAR " + myNewGeometry.getDisplayAspectRatio()));
            }
        }
        if (myNewGeometry.getCleanDisplayDimensions().fitsInto(targetEncodedDims) && myNewGeometry.getCleanDisplayDimensions().fitsInto(sourceEncodedDims)) {
            myNewGeometry.setDimensions(myNewGeometry.getCleanDisplayDimensions());
            myNewGeometry.setPasp(FrameGeometry.Pasp.identity());
            myNewGeometry.setClap(FrameGeometry.Clap.identity(myNewGeometry.getDimensions()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"3.  Anamorphic necessary?");
                logger.debug((Object)("myNewGeometry.getPasp() " + myNewGeometry.getPasp()));
                logger.debug((Object)("myNewGeometry.getDimensions() " + myNewGeometry.getDimensions()));
                logger.debug((Object)("myNewGeometry.getCleanDisplayDimensions() " + myNewGeometry.getCleanDisplayDimensions()));
                logger.debug((Object)("myNewGeometry.DAR " + myNewGeometry.getDisplayAspectRatio()));
            }
        }
        return myNewGeometry;
    }

    public String toString() {
        return String.format("Conform to: '%s'", this._target);
    }

    public static class SquarePixelConformer
    extends FrameGeometryConformer {
        public SquarePixelConformer(FrameGeometry target) {
            super(new FrameGeometry(target.getDimensions(), FrameGeometry.Pasp.identity()));
        }
    }

    public static class ATVHDAnamorphicConfomer
    extends FrameGeometryConformer {
        public ATVHDAnamorphicConfomer() {
            super(FrameGeometry.atvHDAnamorphicFrameGeometry());
        }
    }

    public static class ATVHDConformer
    extends FrameGeometryConformer {
        public ATVHDConformer() {
            super(FrameGeometry.atvHDFrameGeometry());
        }
    }

    public static class ATVSDConformer
    extends FrameGeometryConformer {
        public ATVSDConformer() {
            super(FrameGeometry.atvSDFrameGeometry());
        }
    }

    public static class IPodAnamorphicConformer
    extends FrameGeometryConformer {
        public IPodAnamorphicConformer() {
            super(FrameGeometry.iPodAnamorphicFrameGeometry());
        }
    }

    public static class IPodSquareConformer
    extends SquarePixelConformer {
        public IPodSquareConformer() {
            super(FrameGeometry.iPodSquareFrameGeometry());
        }
    }

    public static class ConformerResult {
        private FrameGeometry outputFrameGeometry;
        private FrameGeometry.CropRectangle sourceCropRectangle;

        public ConformerResult(FrameGeometry outputFrameGeometry, FrameGeometry.CropRectangle sourceCropRectangle) {
            this.outputFrameGeometry = outputFrameGeometry;
            this.sourceCropRectangle = sourceCropRectangle;
        }

        public FrameGeometry getOutputFrameGeometry() {
            return this.outputFrameGeometry;
        }

        public FrameGeometry.CropRectangle getSourceCropRectangle() {
            return this.sourceCropRectangle;
        }

        public String toString() {
            return "ConformerResult{outputFrameGeometry=" + this.outputFrameGeometry + ", sourceCropRectangle=" + this.sourceCropRectangle + '}';
        }
    }
}

