/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.foghorn.media;

import com.apple.jingle.g5.util.DataDiffSet;
import com.apple.jingle.g5.util.DataDiffable;
import com.apple.jingle.g5.util.DataDump;
import com.apple.jingle.g5.util.DataDumpable;
import com.apple.jingle.g5.util.MapDataDump;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class FrameGeometry
implements Serializable {
    private static final long serialVersionUID = 8538487800489797654L;
    private String name;
    private Dimensions dimensions;
    private Pasp pasp;
    private Clap clap;
    private final Pattern parseFrameGeometryStringPattern = Pattern.compile("([0-9x]+) \\(pasp ([0-9-]+), crop rectangle ([0-9-]+)\\)");

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions d) {
        this.dimensions = d;
    }

    public Pasp getPasp() {
        return this.pasp;
    }

    public void setPasp(Pasp p) {
        this.pasp = new Pasp(p).reduce();
    }

    public Clap getClap() {
        return this.clap;
    }

    public void setClap(Clap c) {
        this.clap = c;
    }

    public FrameGeometry(String n, Dimensions d, Pasp p, Clap c) {
        this.setName(n);
        this.setDimensions(new Dimensions(d));
        this.setPasp(new Pasp(p));
        this.setClap(new Clap(c));
    }

    public FrameGeometry(Dimensions d, Pasp p, Clap c) {
        this(String.format("%s - %s - %s", d, p, c), d, p, c);
    }

    public FrameGeometry(Dimensions dimensions2, Pasp pasp, CropRectangle cropRectangle) {
        this(dimensions2, pasp, new Clap(dimensions2, cropRectangle));
    }

    public FrameGeometry(Dimensions d) {
        this(d, Pasp.identity(), Clap.identity(d));
    }

    public FrameGeometry(Dimensions d, Pasp p) {
        this(d, p, Clap.identity(d));
    }

    public FrameGeometry(FrameGeometry f) {
        this(f.getDimensions(), f.getPasp(), f.getClap());
    }

    public FrameGeometry(String frameGeometryString) {
        this(new Dimensions(0L, 0L));
        Matcher m = this.parseFrameGeometryStringPattern.matcher(frameGeometryString);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("Cannot parse string '%s' for a frame geometry: must match pattern '%s'", frameGeometryString, this.parseFrameGeometryStringPattern));
        }
        this.setDimensions(new Dimensions(m.group(1)));
        this.setPasp(new Pasp(m.group(2)));
        this.setClap(new Clap(this.getDimensions(), new CropRectangle(m.group(3))));
    }

    public FrameGeometry crop(long t, long b, long l, long r) {
        return this.crop(new CropRectangle(t, b, l, r));
    }

    public FrameGeometry crop(CropRectangle r) {
        return new FrameGeometry(this.getDimensions(), this.getPasp(), new Clap(this.getDimensions(), r));
    }

    @Nonnull
    public FrameGeometry cropWithoutClap(CropRectangle cropRectangle) {
        Dimensions dimensions2 = this.getDimensions();
        Dimensions croppedDimensions = new Dimensions(dimensions2.getWidth() - cropRectangle.getLeft() - cropRectangle.getRight(), dimensions2.getHeight() - cropRectangle.getTop() - cropRectangle.getBottom());
        return new FrameGeometry(croppedDimensions, this.getPasp());
    }

    public boolean isSquarePixel() {
        return this.getPasp().equals(Pasp.identity());
    }

    public Dimensions getDisplayDimensions() {
        double paspD = this.getPasp().reduce().asDouble();
        Dimensions encodedDimensions = this.getDimensions();
        return new Dimensions(Math.round((double)encodedDimensions.getWidth() * paspD), encodedDimensions.getHeight());
    }

    public Dimensions getCleanDisplayDimensions() {
        double paspD = this.getPasp().reduce().asDouble();
        Dimensions cleanDimensions = this.getClap().getCleanDimensions();
        return new Dimensions(Math.round((double)cleanDimensions.getWidth() * paspD), cleanDimensions.getHeight());
    }

    public double getEncodedAspectRatio() {
        return this.getDimensions().getAspectRatio();
    }

    public double getDisplayAspectRatio() {
        double paspD = this.getPasp().reduce().asDouble();
        Dimensions cleanDimensions = this.getClap().getCleanDimensions();
        return paspD * (double)cleanDimensions.getWidth() / (double)cleanDimensions.getHeight();
    }

    public CropRectangle getCropRectangle() {
        Dimensions theDimensions;
        Clap theClap = this.getClap();
        if (theClap.equals(Clap.identity(theDimensions = this.getDimensions()))) {
            return CropRectangle.identity();
        }
        long ew = theDimensions.getWidth();
        long eh = theDimensions.getHeight();
        Dimensions cleanDimensions = theClap.getCleanDimensions();
        long aw = cleanDimensions.getWidth();
        long ah = cleanDimensions.getHeight();
        Point clapOffset = theClap.getOffset();
        long ox = clapOffset.getX();
        long oy = clapOffset.getY();
        long l = (ew - aw) / 2L + ox;
        long t = (eh - ah) / 2L + oy;
        long r = ew - aw - l;
        long b = eh - ah - t;
        return new CropRectangle(t, b, l, r);
    }

    public static FrameGeometry iPodSquareFrameGeometry() {
        return new FrameGeometry("iPod square (640x480 square)", new Dimensions(640L, 480L), Pasp.identity(), Clap.identity(new Dimensions(640L, 480L)));
    }

    public static FrameGeometry iPodAnamorphicFrameGeometry() {
        return new FrameGeometry("iPod anamorphic (640x480, encoding 16:9)", new Dimensions(640L, 480L), new Pasp(4L, 3L), Clap.identity(new Dimensions(640L, 480L)));
    }

    public static FrameGeometry atvSDFrameGeometry() {
        return new FrameGeometry("SD anamorphic (720x480, encoding 16:9)", new Dimensions(720L, 480L), new Pasp(32L, 27L), Clap.identity(new Dimensions(720L, 480L)));
    }

    public static FrameGeometry atvHDFrameGeometry() {
        return new FrameGeometry("HD square (1280x720 square)", new Dimensions(1280L, 720L), Pasp.identity(), Clap.identity(new Dimensions(1280L, 720L)));
    }

    public static FrameGeometry atvHDAnamorphicFrameGeometry() {
        return new FrameGeometry("HD anamorphic (960x720, encoding 16:9)", new Dimensions(960L, 720L), new Pasp(4L, 3L), Clap.identity(new Dimensions(960L, 720L)));
    }

    public static Dimensions iFrameTrickPlayDimensions() {
        return new Dimensions(426L, 320L);
    }

    public String toString() {
        return String.format("%s (pasp %s, crop rectangle %s)", this.getDimensions(), this.getPasp(), this.getCropRectangle());
    }

    public String __toString() {
        return String.format("'%s' [encoded@%s display@%s : pasp=%s] (%.02f:1 display, %.02f:1 encoded)", this.getName(), this.getDimensions(), this.getCleanDisplayDimensions(), this.getPasp(), this.getDisplayAspectRatio(), this.getEncodedAspectRatio());
    }

    public boolean equals(Object o) {
        FrameGeometry f = (FrameGeometry)o;
        return this.getDimensions().equals(f.getDimensions()) && this.getPasp().equals(f.getPasp()) && this.getClap().equals(f.getClap());
    }

    public int hashCode() {
        return this.getDimensions().hashCode() + this.getPasp().hashCode() + this.getClap().hashCode();
    }

    public String howDoWeDiffer(FrameGeometry other) {
        if (other.equals(this)) {
            return "same";
        }
        StringBuilder sb = new StringBuilder();
        if (!this.getDimensions().equals(other.getDimensions())) {
            sb.append(String.format("dimension differs: '%s' != '%s'\n", this.getDimensions(), other.getDimensions()));
        }
        if (!this.getPasp().equals(other.getPasp())) {
            sb.append(String.format("     pasp differs: '%s' != '%s'\n", this.getPasp(), other.getPasp()));
        }
        if (!this.getClap().equals(other.getClap())) {
            sb.append(String.format("     clap differs: '%s' != '%s'", this.getClap(), other.getClap()));
        }
        return sb.toString();
    }

    public static class Pasp
    implements Comparable<Pasp>,
    Serializable {
        private static final long serialVersionUID = -6717713537485808190L;
        private final Pattern paspStringPattern = Pattern.compile("([0-9]+)-([0-9]+)");
        private long hSpacing;
        private long vSpacing;

        public long getHSpacing() {
            return this.hSpacing;
        }

        public void setHSpacing(long h) {
            this.hSpacing = h;
        }

        public long getVSpacing() {
            return this.vSpacing;
        }

        public void setVSpacing(long v) {
            this.vSpacing = v;
        }

        public Pasp(long h, long v) {
            this.setHSpacing(h);
            this.setVSpacing(v);
        }

        public Pasp(String paspString) {
            Matcher m = this.paspStringPattern.matcher(paspString);
            if (!m.matches()) {
                throw new FrameGeometryException(String.format("Can't parse the string '%s' as a 'Pasp' : must be in form <h>-<v>", paspString));
            }
            long h = Long.parseLong(m.group(1));
            long v = Long.parseLong(m.group(2));
            this.setHSpacing(h);
            this.setVSpacing(v);
        }

        public Pasp(Pasp p) {
            this.setHSpacing(p.getHSpacing());
            this.setVSpacing(p.getVSpacing());
        }

        public Pasp(Dimensions encoded, Dimensions display) {
            this(display.getWidth(), encoded.getWidth());
        }

        public static Pasp identity() {
            return new Pasp(1L, 1L);
        }

        public Pasp reduce() {
            long a = this.getHSpacing();
            long b = this.getVSpacing();
            while (b != 0L) {
                long tmp = b;
                b = a % b;
                a = tmp;
            }
            return new Pasp(this.getHSpacing() / a, this.getVSpacing() / a);
        }

        public double asDouble() {
            return (double)this.getHSpacing() / (double)this.getVSpacing();
        }

        public boolean equals(Object o) {
            Pasp p = (Pasp)o;
            Pasp a = this.reduce();
            Pasp b = p.reduce();
            return a.getHSpacing() == b.getHSpacing() && a.getVSpacing() == b.getVSpacing();
        }

        public int hashCode() {
            return (int)(this.getHSpacing() * this.getVSpacing() % Integer.MAX_VALUE);
        }

        @Override
        public int compareTo(Pasp p) {
            if (this.equals(p)) {
                return 0;
            }
            Pasp newMe = new Pasp(this).reduce();
            Pasp newP = new Pasp(p).reduce();
            return newMe.asDouble() > newP.asDouble() ? 1 : -1;
        }

        public String toString() {
            return String.format("%d-%d", this.getHSpacing(), this.getVSpacing());
        }
    }

    public static class Clap
    implements Serializable {
        private static final long serialVersionUID = -44708594921621534L;
        private Pattern clapPattern = Pattern.compile("([^ ]+) \\(offset ([^\\)]+)\\)");
        private Dimensions cleanDimensions;
        private Point offset;

        public Dimensions getCleanDimensions() {
            return this.cleanDimensions;
        }

        public void setCleanDimensions(Dimensions cleanDimensions) {
            this.cleanDimensions = cleanDimensions;
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point offset) {
            this.offset = offset;
        }

        public Clap(Dimensions cleanDimensions, Point offset) {
            this.setCleanDimensions(new Dimensions(cleanDimensions));
            this.setOffset(new Point(offset));
        }

        public Clap(String clapString) {
            this(new Dimensions(0L, 0L), Point.identity());
            Matcher m = this.clapPattern.matcher(clapString);
            if (!m.matches()) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid Clap", clapString));
            }
            this.setCleanDimensions(new Dimensions(m.group(1)));
            this.setOffset(new Point(m.group(2)));
        }

        public Clap(Clap clap) {
            this.setCleanDimensions(new Dimensions(clap.getCleanDimensions()));
            this.setOffset(new Point(clap.getOffset()));
        }

        public Clap(Dimensions uncroppedDimensions, CropRectangle rectangle2) {
            Dimensions cleanDims = new Dimensions(uncroppedDimensions.getWidth() - rectangle2.getLeft() - rectangle2.getRight(), uncroppedDimensions.getHeight() - rectangle2.getTop() - rectangle2.getBottom());
            Point o = new Point(rectangle2.getLeft() - (long)Math.round((uncroppedDimensions.getWidth() - cleanDims.getWidth()) / 2L), rectangle2.getTop() - (long)Math.round((uncroppedDimensions.getHeight() - cleanDims.getHeight()) / 2L));
            this.setCleanDimensions(cleanDims);
            this.setOffset(o);
        }

        public boolean equals(Object o) {
            Clap c = (Clap)o;
            return c.getCleanDimensions().equals(this.getCleanDimensions()) && c.getOffset().equals(this.getOffset());
        }

        public int hashCode() {
            return this.getCleanDimensions().hashCode() * this.getOffset().hashCode() % Integer.MAX_VALUE;
        }

        public static Clap identity(Dimensions d) {
            return new Clap(d, new Point(0L, 0L));
        }

        public String toString() {
            return String.format("%s (offset %s)", this.getCleanDimensions(), this.getOffset());
        }
    }

    public static class CropRectangle
    implements Serializable,
    DataDumpable,
    DataDiffable<CropRectangle> {
        private static final long serialVersionUID = 1634754024265501138L;
        private Pattern cropRectanglePattern = Pattern.compile("([0-9]+)-([0-9]+)-([0-9]+)-([0-9]+)");
        private long top;
        private long bottom;
        private long left;
        private long right;

        public long getTop() {
            return this.top;
        }

        public long getBottom() {
            return this.bottom;
        }

        public long getLeft() {
            return this.left;
        }

        public long getRight() {
            return this.right;
        }

        public void setTop(long t) {
            this.top = t;
        }

        public void setBottom(long b) {
            this.bottom = b;
        }

        public void setLeft(long l) {
            this.left = l;
        }

        public void setRight(long r) {
            this.right = r;
        }

        public CropRectangle(long t, long b, long l, long r) {
            this.setTop(t);
            this.setBottom(b);
            this.setLeft(l);
            this.setRight(r);
        }

        public CropRectangle(String cropRectangleStr) {
            this(0L, 0L, 0L, 0L);
            Matcher m = this.cropRectanglePattern.matcher(cropRectangleStr);
            if (!m.matches()) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid crop rectangle", cropRectangleStr));
            }
            this.setTop(Long.parseLong(m.group(1)));
            this.setBottom(Long.parseLong(m.group(2)));
            this.setLeft(Long.parseLong(m.group(3)));
            this.setRight(Long.parseLong(m.group(4)));
        }

        public CropRectangle(CropRectangle r) {
            this(r.getTop(), r.getBottom(), r.getLeft(), r.getRight());
        }

        public static CropRectangle identity() {
            return new CropRectangle(0L, 0L, 0L, 0L);
        }

        public boolean isIdentity() {
            return this.getTop() == 0L && this.getBottom() == 0L && this.getLeft() == 0L && this.getRight() == 0L;
        }

        public boolean equals(Object o) {
            CropRectangle r = (CropRectangle)o;
            return r.getTop() == this.getTop() && r.getBottom() == this.getBottom() && r.getLeft() == this.getLeft() && r.getRight() == this.getRight();
        }

        public int hashCode() {
            return (int)(this.getTop() * this.getBottom() * this.getLeft() * this.getRight() % Integer.MAX_VALUE);
        }

        public String toString() {
            return this.asString();
        }

        public String asString() {
            return String.format("%d-%d-%d-%d", this.getTop(), this.getBottom(), this.getLeft(), this.getRight());
        }

        public static CropRectangle maximum(CropRectangle x, CropRectangle y) {
            long t = Math.max(x.getTop(), y.getTop());
            long b = Math.max(x.getBottom(), y.getBottom());
            long l = Math.max(x.getLeft(), y.getLeft());
            long r = Math.max(x.getRight(), y.getRight());
            return new CropRectangle(t, b, l, r);
        }

        @Override
        public void diff(@Nonnull DataDiffSet diffs, @Nonnull String prefix, @Nonnull CropRectangle compareTo) {
            MapDataDump.diff(diffs, prefix, this, compareTo);
        }

        @Override
        public void dumpData(@Nonnull DataDump dump) {
            dump.write("left", this.getLeft()).write("right", this.getRight()).write("top", this.getTop()).write("bottom", this.getBottom());
        }
    }

    public static class Point
    implements Serializable {
        private static final long serialVersionUID = 4924324914944870280L;
        private static final Pattern pointPattern = Pattern.compile("([0-9]+), ([0-9]+)");
        private long x;
        private long y;

        public long getX() {
            return this.x;
        }

        public long getY() {
            return this.y;
        }

        public void setX(long x) {
            this.x = x;
        }

        public void setY(long y) {
            this.y = y;
        }

        public Point(String pointStr) {
            this(0L, 0L);
            Matcher m = pointPattern.matcher(pointStr);
            if (!m.matches()) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid Point", pointStr));
            }
            this.setX(Long.valueOf(m.group(1)));
            this.setY(Long.valueOf(m.group(2)));
        }

        public Point(long x, long y) {
            this.setX(x);
            this.setY(y);
        }

        public Point(Point p) {
            this.setX(p.getX());
            this.setY(p.getY());
        }

        public static Point identity() {
            return new Point(0L, 0L);
        }

        public double distanceFrom(Point p) {
            return Math.sqrt(Math.pow(this.getX() - p.getX(), 2.0) + Math.pow(this.getY() - p.getY(), 2.0));
        }

        public boolean equals(Object o) {
            Point p = (Point)o;
            return this.getX() == p.getX() && this.getY() == p.getY();
        }

        public int hashCode() {
            return (int)((this.getX() + this.getY()) % Integer.MAX_VALUE);
        }

        public String toString() {
            return String.format("%d, %d", this.getX(), this.getY());
        }
    }

    public static class Dimensions
    implements Comparable<Dimensions>,
    Serializable {
        private static final long serialVersionUID = -8448280860621523701L;
        private long width;
        private long height;
        private Pattern dimensionStringPattern = Pattern.compile("([0-9]+)x([0-9]+)");

        public long getWidth() {
            return this.width;
        }

        public long getHeight() {
            return this.height;
        }

        public void setWidth(long w) {
            if (w < 0L) {
                throw new FrameGeometryException(String.format("width must be positive (%d is illegal)", w));
            }
            this.width = w;
        }

        public void setHeight(long h) {
            if (h < 0L) {
                throw new FrameGeometryException(String.format("height must be positive (%d is illegal)", h));
            }
            this.height = h;
        }

        public Dimensions(String dimsString) {
            this(0L, 0L);
            Matcher m = this.dimensionStringPattern.matcher(dimsString);
            if (!m.matches()) {
                throw new IllegalArgumentException(String.format("Cannot create a Dimensions object from string '%s'", dimsString));
            }
            this.setWidth(Long.parseLong(m.group(1)));
            this.setHeight(Long.parseLong(m.group(2)));
        }

        public Dimensions(long w, long h) {
            this.setWidth(w);
            this.setHeight(h);
        }

        public Dimensions(Dimensions d) {
            this(d.getWidth(), d.getHeight());
        }

        public double getAspectRatio() {
            return 1.0 * (double)this.getWidth() / (double)this.getHeight();
        }

        public boolean equals(Object o) {
            Dimensions d = (Dimensions)o;
            return this.getWidth() == d.getWidth() && this.getHeight() == d.getHeight();
        }

        public int hashCode() {
            return (int)(this.getWidth() * this.getHeight() % Integer.MAX_VALUE);
        }

        public boolean fitsInto(Dimensions d) {
            return this.getWidth() <= d.getWidth() && this.getHeight() <= d.getHeight();
        }

        @Override
        public int compareTo(Dimensions d) {
            if (this.equals(d)) {
                return 0;
            }
            return this.fitsInto(d) ? 1 : -1;
        }

        public Dimensions squeezeInto(Dimensions target) {
            double thatAspectRatio;
            if (this.fitsInto(target)) {
                return new Dimensions(this);
            }
            double thisAspectRatio = this.getAspectRatio();
            if (thisAspectRatio > (thatAspectRatio = target.getAspectRatio())) {
                return new Dimensions(target.getWidth(), Math.round((double)target.getWidth() / thisAspectRatio));
            }
            return new Dimensions(Math.round((double)target.getHeight() * thisAspectRatio), target.getHeight());
        }

        public String toString() {
            return String.format("%dx%d", this.getWidth(), this.getHeight());
        }
    }

    public static class FrameGeometryException
    extends RuntimeException {
        private static final long serialVersionUID = -4263594216196220049L;

        public FrameGeometryException(String s) {
            super(s);
        }

        public FrameGeometryException(Throwable e) {
            super(e);
        }

        public FrameGeometryException(String s, Throwable e) {
            super(s, e);
        }
    }
}

