/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.foghorn.media;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.FrameGeometryConformer;
import com.apple.jingle.foghorn.media.types.TargetDevice;
import com.apple.jingle.g5.VideoGrade;
import com.google.common.base.Function;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ComputeOutputGeometry {
    public static Function<VideoGrade, FrameGeometry> frameGeometryForVideoGradeFunction(final FrameGeometry sourceGeometry, final double sourceFrameRate, final FrameGeometry.Pasp outputPasp, final String providerDisplayAspectRatio, final FrameGeometry.Dimensions boundingBox) {
        return new Function<VideoGrade, FrameGeometry>(){

            public FrameGeometry apply(VideoGrade videoGrade) {
                return videoGrade.computer.computeOutputFrameGeometry(sourceGeometry, sourceFrameRate, FrameGeometry.CropRectangle.identity(), outputPasp, providerDisplayAspectRatio, boundingBox).getOutputFrameGeometry();
            }
        };
    }

    public static abstract class IFrameTrickPlay {
        private static final FrameGeometry.Dimensions iFrameTrickPlayDimensions = FrameGeometry.iFrameTrickPlayDimensions();
        private static final long maxArea = iFrameTrickPlayDimensions.getHeight() * iFrameTrickPlayDimensions.getWidth();

        public static FrameGeometry computeTrickPlayFrameGeometry(FrameGeometry.Pasp outputPasp, FrameGeometry.Dimensions sourceDimensions, FrameGeometry.Dimensions boundingBox) {
            return HLS.computeHLSFrameGeometry(IFrameTrickPlay.maxArea, outputPasp, sourceDimensions, boundingBox);
        }
    }

    public static abstract class HLS {
        private static Pair<Long, Long> nonOddScale(long height, long width, long maxArea, FrameGeometry.Dimensions boundingBox) {
            if (height <= width) {
                return HLS._nonOddScaleShortestFirst(height, width, maxArea, boundingBox);
            }
            Pair<Long, Long> scaled = HLS._nonOddScaleShortestFirst(width, height, maxArea, boundingBox);
            return Pair.of((Object)scaled.getRight(), (Object)scaled.getLeft());
        }

        private static Pair<Long, Long> _nonOddScaleShortestFirst(long shorter, long longer, long maxArea, FrameGeometry.Dimensions boundingBox) {
            double aspectRatio = 1.0 * (double)longer / (double)shorter;
            long scaledShorter = Math.round(Math.sqrt((double)maxArea / aspectRatio));
            long finalShorter = scaledShorter % 2L != 0L ? scaledShorter - 1L : scaledShorter;
            long scaledLonger = Math.round((double)finalShorter * aspectRatio);
            if (scaledLonger * finalShorter > maxArea) {
                scaledShorter = Math.round(Math.floor(Math.sqrt((double)maxArea / aspectRatio)));
                finalShorter = scaledShorter % 2L != 0L ? scaledShorter - 1L : scaledShorter;
                scaledLonger = Math.round((double)finalShorter * aspectRatio);
                if (scaledLonger * finalShorter > maxArea && (scaledLonger = Math.round(Math.floor((double)finalShorter * aspectRatio))) * finalShorter > maxArea) {
                    throw new IllegalStateException("ScaledLongerAndFinalShorterGreaterThanMaxArea");
                }
            }
            long maxBoundingBoxDim = Math.max(boundingBox.getHeight(), boundingBox.getWidth());
            long minBoundingBoxDim = Math.min(boundingBox.getHeight(), boundingBox.getWidth());
            if (scaledLonger > maxBoundingBoxDim || scaledShorter > minBoundingBoxDim) {
                scaledLonger = maxBoundingBoxDim;
                scaledShorter = Math.round((double)scaledLonger / aspectRatio);
                if (scaledShorter > minBoundingBoxDim) {
                    scaledShorter = finalShorter = minBoundingBoxDim;
                    scaledLonger = Math.round((double)finalShorter * aspectRatio);
                    if (scaledLonger > maxBoundingBoxDim) {
                        throw new IllegalStateException("ScaledShorterAndLongerAreOutsideBoundingBox");
                    }
                }
                double scaledAspectRatio = 1.0 * (double)scaledLonger / (double)scaledShorter;
                double diffScaled = Math.abs(aspectRatio - scaledAspectRatio);
                if (scaledShorter % 2L == 0L) {
                    double altScaledAspectRatio1 = 1.0 * (double)(scaledLonger - 2L) / (double)(scaledShorter - 2L);
                    double diff1 = Math.abs(aspectRatio - altScaledAspectRatio1);
                    if (diff1 < diffScaled) {
                        scaledLonger -= 2L;
                        scaledShorter -= 2L;
                    }
                } else {
                    double diff3;
                    double altScaledAspectRatio1 = 1.0 * (double)scaledLonger / (double)(scaledShorter - 1L);
                    double diff1 = Math.abs(aspectRatio - altScaledAspectRatio1);
                    double altScaledAspectRatio2 = 1.0 * (double)(scaledLonger - 2L) / (double)(scaledShorter - 1L);
                    double diff2 = Math.abs(aspectRatio - altScaledAspectRatio2);
                    double altScaledAspectRatio3 = 1.0 * (double)scaledLonger / (double)(scaledShorter + 1L);
                    double d = diff3 = scaledLonger * (scaledShorter + 1L) > maxArea ? Double.MAX_VALUE : Math.abs(aspectRatio - altScaledAspectRatio3);
                    if (diff1 < diff2 && diff1 < diff3) {
                        --scaledShorter;
                    } else if (diff2 < diff3) {
                        scaledLonger -= 2L;
                        --scaledShorter;
                    } else if (scaledLonger * (scaledShorter + 1L) <= maxArea) {
                        ++scaledShorter;
                    } else {
                        throw new IllegalStateException("ScaledLongerAndShorterNotAdjustedWithinGradeArea");
                    }
                }
                finalShorter = scaledShorter;
            }
            long finalLonger = scaledLonger % 2L == 0L ? scaledLonger : (finalShorter == scaledShorter ? scaledLonger - 1L : scaledLonger + 1L);
            return Pair.of((Object)finalShorter, (Object)finalLonger);
        }

        private static FrameGeometry computeHLSFrameGeometry(long gradeMaxArea, FrameGeometry.Pasp outputPasp, FrameGeometry.Dimensions sourceDimensions, FrameGeometry.Dimensions boundingBox) {
            long outputWidth;
            long outputHeight;
            long sourceHeight = sourceDimensions.getHeight();
            long sourceWidth = sourceDimensions.getWidth();
            long sourceArea = sourceHeight * sourceWidth;
            long maxSourceDim = Math.max(sourceHeight, sourceWidth);
            long minSourceDim = Math.min(sourceHeight, sourceWidth);
            long maxBoundingBoxDim = Math.max(boundingBox.getHeight(), boundingBox.getWidth());
            long minBoundingBoxDim = Math.min(boundingBox.getHeight(), boundingBox.getWidth());
            if (sourceArea > gradeMaxArea || sourceHeight % 2L != 0L || sourceWidth % 2L != 0L || maxSourceDim > maxBoundingBoxDim || minSourceDim > minBoundingBoxDim) {
                Pair<Long, Long> scaled = HLS.nonOddScale(sourceHeight, sourceWidth, Math.min(gradeMaxArea, sourceArea), boundingBox);
                outputHeight = (Long)scaled.getLeft();
                outputWidth = (Long)scaled.getRight();
            } else {
                outputHeight = sourceHeight;
                outputWidth = sourceWidth;
            }
            return new FrameGeometry(new FrameGeometry.Dimensions(outputWidth, outputHeight), outputPasp);
        }

        public static Computer createComputer(long height, long width) {
            final long gradeMaxArea = height * width;
            return new Computer(){

                @Override
                public FrameGeometryConformer.ConformerResult computeOutputFrameGeometry(FrameGeometry sourceGeometry, double sourceFrameRate, FrameGeometry.CropRectangle cropRectangle, FrameGeometry.Pasp outputPasp, String providerDisplayAspectRatio, FrameGeometry.Dimensions boundingBox) {
                    FrameGeometry.CropRectangle conformedCropRectangle = sourceGeometry.getCropRectangle();
                    return new FrameGeometryConformer.ConformerResult(HLS.computeHLSFrameGeometry(gradeMaxArea, outputPasp, sourceGeometry.getDimensions(), boundingBox), conformedCropRectangle);
                }
            };
        }
    }

    public static abstract class VOD {
        private static final FrameGeometry.Dimensions NTSC_DIMENSIONS = new FrameGeometry.Dimensions(720L, 480L);
        private static final FrameGeometry.Dimensions REAL_NTSC_DIMENSIONS = new FrameGeometry.Dimensions(720L, 486L);

        private static FrameGeometryConformer.ConformerResult computeOutputFrameGeometry(TargetDevice targetDevice, FrameGeometry.Pasp outputPasp, FrameGeometry.CropRectangle cropRectangle, String providerDisplayAspectRatio, FrameGeometry sourceGeometry, double sourceFrameRate) {
            FrameGeometry.Pasp pasp = VOD.getOutputPasp(sourceGeometry, providerDisplayAspectRatio, outputPasp);
            FrameGeometry correctedInputFrameGeometry = new FrameGeometry(sourceGeometry.getDimensions(), pasp).crop(cropRectangle);
            return targetDevice.targetFrameGeometry(correctedInputFrameGeometry, sourceFrameRate);
        }

        private static FrameGeometry.Pasp getOutputPasp(FrameGeometry sourceGeometry, String providerDisplayAspectRatio, FrameGeometry.Pasp outputPasp) {
            FrameGeometry.Pasp providerPasp = VOD.getProviderOverriddenPasp(providerDisplayAspectRatio, sourceGeometry);
            FrameGeometry.Pasp pasp = providerPasp != null ? providerPasp : (outputPasp != null ? outputPasp : sourceGeometry.getPasp());
            return pasp;
        }

        public static FrameGeometry.Pasp getProviderOverriddenPasp(String displayAspectRatio, FrameGeometry inputFrameGeometry) {
            if (displayAspectRatio == null) {
                return null;
            }
            FrameGeometry.Dimensions inputFrameGeometryDimensions = inputFrameGeometry.getDimensions();
            if (!inputFrameGeometryDimensions.equals(NTSC_DIMENSIONS) && !inputFrameGeometryDimensions.equals(REAL_NTSC_DIMENSIONS)) {
                throw new RuntimeException(String.format("Setting the image.display_aspect_ratio tag on a video that is not 720x480 or 720x486 is not allowed! (DAR: %s, input frame size: %s)", displayAspectRatio, inputFrameGeometry));
            }
            switch (displayAspectRatio) {
                case "16:9": {
                    return new FrameGeometry.Pasp(32L, 27L);
                }
                case "4:3": {
                    return new FrameGeometry.Pasp(8L, 9L);
                }
                case "1:1": {
                    return FrameGeometry.Pasp.identity();
                }
            }
            throw new RuntimeException("Invalid image.display_aspect_ratio tag: " + displayAspectRatio);
        }

        public static Computer createComputer(final TargetDevice targetDevice) {
            return new Computer(){

                @Override
                public FrameGeometryConformer.ConformerResult computeOutputFrameGeometry(FrameGeometry sourceGeometry, double sourceFrameRate, FrameGeometry.CropRectangle cropRectangle, FrameGeometry.Pasp outputPasp, String providerDisplayAspectRatio, FrameGeometry.Dimensions boundingBox) {
                    return VOD.computeOutputFrameGeometry(targetDevice, outputPasp, cropRectangle, providerDisplayAspectRatio, sourceGeometry, sourceFrameRate);
                }
            };
        }
    }

    public static interface Computer {
        public FrameGeometryConformer.ConformerResult computeOutputFrameGeometry(FrameGeometry var1, double var2, FrameGeometry.CropRectangle var4, FrameGeometry.Pasp var5, String var6, FrameGeometry.Dimensions var7);
    }
}

