/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.asperasupport;

import com.apple.transporter.asperasupport.AsperaSupportException;
import com.apple.transporter.transport.service.AsperaSupportService;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.ProcUtil;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class AsperaSupportServiceImpl
implements AsperaSupportService,
ServiceFactory {
    private static boolean disableRefresh = false;
    public static String version;
    private boolean hasSetup = false;
    private Properties props;

    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        return new AsperaSupportServiceImpl();
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object o) {
    }

    private synchronized void setup() {
        block7: {
            if (!this.hasSetup) {
                this.hasSetup = true;
                try {
                    String[] binFiles;
                    InputStream propsStream = this.getClass().getClassLoader().getResourceAsStream("asperasupport.properties");
                    this.props = new Properties();
                    this.props.load(propsStream);
                    propsStream.close();
                    String binDirPath = this.getBinPath();
                    File binDir = new File(binDirPath);
                    binDir.mkdirs();
                    if (!binDir.exists()) {
                        throw new AsperaSupportException("Could not create path for Aspera binaries: " + binDirPath);
                    }
                    for (String binFileName : binFiles = this.props.getProperty("bin." + this.getArchitecturePathElement() + ".files").split(",")) {
                        String binFileResourcePath = this.props.getProperty("bin.prefix") + "/" + this.getArchitecturePathElement() + "/" + binFileName;
                        File binFile = new File(binDirPath + File.separator + binFileName);
                        this.validateFileOnFileSystem(binFileResourcePath, binFile);
                    }
                    String etcDirPath = this.getEtcPath();
                    File etcDir = new File(etcDirPath);
                    etcDir.mkdirs();
                    if (etcDir.exists()) {
                        String[] etcFiles;
                        for (String etcFileName : etcFiles = this.props.getProperty("etc.files").split(",")) {
                            String etcFileResourcePath = this.props.getProperty("etc.prefix") + "/" + etcFileName;
                            File etcFile = new File(etcDirPath + File.separator + etcFileName);
                            this.validateFileOnFileSystem(etcFileResourcePath, etcFile);
                        }
                        break block7;
                    }
                    throw new AsperaSupportException("Could not create path for Aspera configuration: " + binDirPath);
                }
                catch (IOException e) {
                    throw new AsperaSupportException("Could not configure Aspera transport.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFileOnFileSystem(String sourceFileResourcePath, File destinationFile) throws IOException {
        block10: {
            if (disableRefresh) {
                return;
            }
            String md5ResourcePath = sourceFileResourcePath + ".md5";
            InputStream expectedMD5Stream = this.getClass().getClassLoader().getResourceAsStream(md5ResourcePath);
            String expectedMD5 = StreamUtil.streamToString((InputStream)expectedMD5Stream).trim();
            expectedMD5Stream.close();
            try {
                String actualMD5;
                if (destinationFile.exists() && !expectedMD5.equalsIgnoreCase(actualMD5 = FileUtil.md5Hex((File)destinationFile))) {
                    destinationFile.delete();
                }
                if (destinationFile.exists()) break block10;
                try (FileOutputStream destFileStream = null;){
                    destFileStream = new FileOutputStream(destinationFile);
                    StreamUtil.copyStream((OutputStream)destFileStream, (InputStream)this.getClass().getClassLoader().getResourceAsStream(sourceFileResourcePath));
                    destFileStream.flush();
                }
                String actualMD52 = FileUtil.md5Hex((File)destinationFile);
                if (!expectedMD5.equalsIgnoreCase(actualMD52)) {
                    throw new AsperaSupportException("Could not successfully extract binary to path: " + destinationFile.getPath());
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new AsperaSupportException("MD5 is not available", e);
            }
        }
        if (destinationFile.getName().toLowerCase().indexOf("ascp") != -1 && !TransportUtil.isOSWindows()) {
            ProcUtil.executeProcess((String[])new String[]{"/bin/chmod", "a+x", destinationFile.getPath()});
        }
    }

    private String getArchitecturePathElement() {
        if (TransportUtil.isOSLinux()) {
            return "linux-32";
        }
        if (TransportUtil.isOSMac()) {
            return "mac-universal";
        }
        if (TransportUtil.isOSWindows()) {
            return "windows-32";
        }
        throw new IllegalStateException("Aspera transporter cannot be used on unsupported operating system and/or hardware.");
    }

    private String getPathPrefix() {
        File override = FileUtil.localConfigHomeOverride();
        File overrideAspera = new File(override, "aspera");
        if (overrideAspera.exists()) {
            disableRefresh = true;
            return overrideAspera.getAbsolutePath() + File.separator;
        }
        return FileUtil.localConfigHome() + File.separator + "aspera" + File.separator;
    }

    public String getBinPath() {
        this.setup();
        return this.getPathPrefix() + this.props.getProperty("bin.prefix") + File.separator + this.getArchitecturePathElement();
    }

    public String getAscpPath() {
        this.setup();
        return this.getBinPath() + File.separator + "ascp" + (TransportUtil.isOSWindows() ? ".exe" : "");
    }

    public String getEtcPath() {
        this.setup();
        return this.getPathPrefix() + this.props.getProperty("etc.prefix");
    }

    public String getConfPath() {
        this.setup();
        return this.getEtcPath() + File.separator + "aspera.conf";
    }

    static {
        String p = System.getProperty("com.apple.transporter.asperasupport.disableRefresh");
        disableRefresh = Boolean.parseBoolean(p);
    }
}

