/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.SysLogLine;
import com.lbuilder.idriver.services.SysLogListener;
import com.sun.jna.Pointer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class SyslogMessageListeners
implements IdriverLibrary.syslog_relay_receive_cb_t {
    private static final Logger logger = Logger.getLogger(SyslogMessageListeners.class.getName());
    private final List<SysLogListener> all = new CopyOnWriteArrayList<SysLogListener>();
    private StringBuffer buff = new StringBuffer();

    @Override
    public void apply(byte b, Pointer user_data) {
        char c = (char)b;
        if (c == '\n') {
            String line = this.buff.toString();
            this.buff = new StringBuffer();
            for (SysLogListener h : this.all) {
                SysLogLine log = null;
                try {
                    log = new SysLogLine(line);
                    h.onLog(log);
                }
                catch (SysLogLine.LogParsingException e) {
                    logger.fine(e.getMessage());
                }
            }
        } else {
            this.buff.append(c);
        }
    }

    public void add(SysLogListener listener) {
        this.all.add(listener);
    }

    public void remove(SysLogListener listener) {
        this.all.remove(listener);
    }

    public int size() {
        return this.all.size();
    }
}

