/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.lbuilder.idriver.exceptions.IDriverErrorCode;
import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.IOSDevice;
import com.lbuilder.idriver.services.IService;
import com.lbuilder.idriver.services.SysLogLine;
import com.lbuilder.idriver.services.SysLogListener;
import com.lbuilder.idriver.services.SyslogMessageListeners;
import com.sun.jna.ptr.PointerByReference;

public class SysLogService
extends IService {
    private IdriverLibrary.syslog_relay_client_t service;
    private SyslogMessageListeners handlers = new SyslogMessageListeners();
    private boolean started = false;

    public SysLogService(IOSDevice iosDevice) throws IDriverException {
        super(iosDevice);
    }

    private void start() throws IDriverException {
        if (!this.started) {
            IDriverErrorCode.throwIfNeeded(this.library.syslog_relay_start_capture(this.service, (IdriverLibrary.syslog_relay_receive_cb_t)this.handlers, null));
        }
        this.started = true;
    }

    public void addListener(SysLogListener listener) throws IDriverException {
        if (!this.started) {
            this.start();
        }
        if (listener == null && this.handlers.size() == 0) {
            listener = new SysLogListener(){

                @Override
                public void onLog(SysLogLine line) {
                    System.out.println(line.toString());
                }
            };
        }
        this.handlers.add(listener);
    }

    public void remove(SysLogListener listener) {
        this.handlers.remove(listener);
    }

    public void stop() throws IDriverException {
        IDriverErrorCode.throwIfNeeded(this.library.syslog_relay_stop_capture(this.service));
        this.started = false;
    }

    @Override
    public void initService() throws IDriverException {
        PointerByReference ptr = new PointerByReference();
        this.library.syslog_relay_client_start_service(this.device.getSDKHandle(), ptr, null);
        this.service = new IdriverLibrary.syslog_relay_client_t(ptr.getValue());
    }

    @Override
    public void free() throws IDriverException {
        if (this.started) {
            this.stop();
        }
        this.library.syslog_relay_client_free(this.service);
    }
}

