/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SysLogLine {
    private Date date;
    private String process;
    private int pid;
    private String level;
    private String message;
    private String original;

    SysLogLine(String line) throws LogParsingException {
        this.original = line;
        try {
            String d = String.valueOf(Calendar.getInstance().get(1)) + " " + line.substring(0, 15);
            SimpleDateFormat parser = new SimpleDateFormat("yyyy MMM d HH:mm:ss");
            this.date = parser.parse(d);
            String rest = line.substring(15);
            int openingBracketPid = rest.indexOf("[");
            int closingBracketPid = rest.indexOf("]");
            this.process = rest.substring(2, openingBracketPid);
            this.pid = Integer.parseInt(rest.substring(openingBracketPid + 1, closingBracketPid));
            rest = rest.substring(closingBracketPid + 2);
            int index = rest.indexOf(62);
            this.level = rest.substring(1, index);
            rest = rest.substring(index + 2);
            this.message = rest.trim();
        }
        catch (Exception e) {
            throw new LogParsingException("Cannot parse line (is it a full line ?)" + this.original);
        }
    }

    public String toString() {
        return this.original;
    }

    public Date getDate() {
        return this.date;
    }

    public String getProcess() {
        return this.process;
    }

    public int getPid() {
        return this.pid;
    }

    public String getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    static class LogParsingException
    extends Exception {
        public LogParsingException(String message) {
            super(message);
        }
    }
}

