/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.dd.plist.NSDictionary;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import com.lbuilder.idriver.exceptions.IDriverErrorCode;
import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.model.ApplicationInfo;
import com.lbuilder.idriver.model.IpaInfo;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.IFileService;
import com.lbuilder.idriver.services.IOSDevice;
import com.lbuilder.idriver.services.IService;
import com.lbuilder.idriver.services.InstallCallback;
import com.lbuilder.idriver.services.UploadingCallBack;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.text.ParseException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class InstallerService
extends IService {
    private static final Object lock = new Object();
    private IdriverLibrary.instproxy_client_t service;

    public InstallerService(IOSDevice device) throws IDriverException {
        super(device);
    }

    public List<ApplicationInfo> listApplications(ApplicationType type) throws IDriverException {
        PointerByReference ptr = new PointerByReference();
        this.library.instproxy_browse(this.service, null, ptr);
        PointerByReference stringPointerByReference = new PointerByReference();
        IntBuffer intBuffer = IntBuffer.allocate(1);
        this.library.plist_to_xml(ptr.getValue(), stringPointerByReference, intBuffer);
        return ApplicationInfo.extractApplications(stringPointerByReference.getValue().getString(0L));
    }

    public ApplicationInfo getApplication(String bundleId) throws IDriverException {
        PointerByReference ptr = new PointerByReference();
        String[] appIDLIST = new String[]{bundleId};
        this.library.instproxy_lookup(this.service, appIDLIST, null, ptr);
        PointerByReference stringPointerByReference = new PointerByReference();
        IntBuffer intBuffer = IntBuffer.allocate(1);
        this.library.plist_to_xml(ptr.getValue(), stringPointerByReference, intBuffer);
        try {
            String appinfo = stringPointerByReference.getValue().getString(0L);
            NSDictionary dictionary = (NSDictionary)XMLPropertyListParser.parse(appinfo.getBytes());
            String[] keysStrings = dictionary.allKeys();
            if (keysStrings.length > 0) {
                return new ApplicationInfo(dictionary.get(keysStrings[0]));
            }
        }
        catch (PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void install(File zipFile, InstallCallback cb, UploadingCallBack uploadingCallBack, boolean update) throws IDriverException, IOException {
        IpaInfo ipaInfo = new IpaInfo(zipFile);
        Pointer plist = this.library.instproxy_client_options_new();
        this.library.instproxy_client_options_add(plist, "CFBundleIdentifier", ipaInfo.getAppID());
        if (ipaInfo.getSinfoPlist() != null) {
            this.library.instproxy_client_options_add(plist, "ApplicationSINF", this.library.plist_new_data(ipaInfo.getSinfoPlist(), (long)ipaInfo.getSinfoPlist().length()));
        }
        if (ipaInfo.getMetaPlist() != null) {
            this.library.instproxy_client_options_add(plist, "iTunesMetadata", this.library.plist_new_data(ipaInfo.getMetaPlist(), (long)ipaInfo.getMetaPlist().length()));
        }
        IFileService afcService = new IFileService(this.device);
        String destFilePath = afcService.uploadFile(zipFile, "/PublicStaging", ipaInfo.getAppID(), uploadingCallBack);
        afcService.free();
        if (update) {
            this.library.instproxy_upgrade(this.service, destFilePath, plist, (IdriverLibrary.instproxy_status_cb_t)cb, null);
        } else {
            this.library.instproxy_install(this.service, destFilePath, plist, (IdriverLibrary.instproxy_status_cb_t)cb, null);
        }
    }

    public void launch(String appid) {
    }

    public void uninstall(String bundleId, InstallCallback cb) throws IDriverException {
        this.library.instproxy_uninstall(this.service, bundleId, null, (IdriverLibrary.instproxy_status_cb_t)cb, null);
    }

    @Override
    public void free() throws IDriverException {
        IDriverErrorCode.throwIfNeeded(this.library.instproxy_client_free(this.service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initService() throws IDriverException {
        Object object = lock;
        synchronized (object) {
            PointerByReference ptr = new PointerByReference();
            this.library.instproxy_client_start_service(this.device.getSDKHandle(), ptr, "label");
            this.service = new IdriverLibrary.instproxy_client_t(ptr.getValue());
        }
    }

    public static enum ApplicationType {
        SYSTEM(2),
        USER(1),
        ALL(0);

        private final int code;

        private ApplicationType(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

