/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.Util;
import com.sun.jna.Pointer;

public abstract class InstallCallback
implements IdriverLibrary.instproxy_status_cb_t {
    protected boolean isComplete;

    @Override
    public void apply(Pointer command, Pointer status, Pointer user_data) {
        try {
            NSDictionary commanDictionary = (NSDictionary)PropertyListParser.parse(Util.toXMLString(command).getBytes());
            NSDictionary statusDictionary = (NSDictionary)PropertyListParser.parse(Util.toXMLString(status).getBytes());
            String operation = commanDictionary.get("Command").toString();
            if (statusDictionary.containsKey("Error")) {
                int errrorcode = statusDictionary.containsKey("ErrorDetail") ? Integer.valueOf(statusDictionary.get("ErrorDetail").toString()) : -1;
                this.isComplete = true;
                String desString = statusDictionary.containsKey("ErrorDescription") ? statusDictionary.get("ErrorDescription").toString() : statusDictionary.toString();
                this.onError(statusDictionary.get("Error").toString(), errrorcode, desString);
            } else if (statusDictionary.containsKey("Status") && statusDictionary.get("Status").toString().equals("Complete")) {
                this.isComplete = true;
                this.onComplete(operation, statusDictionary.get("Status").toString());
            } else if (statusDictionary.containsKey("Status") && statusDictionary.containsKey("PercentComplete")) {
                NSObject percent = statusDictionary.get("PercentComplete");
                this.onUpdate(operation, Integer.valueOf(percent.toString()), statusDictionary.get("Status").toString());
            } else {
                this.onUpdate(operation, -1, statusDictionary.toXMLPropertyList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    protected abstract void onComplete(String var1, String var2);

    protected abstract void onUpdate(String var1, int var2, String var3);

    protected abstract void onError(String var1, int var2, String var3);
}

