/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.lbuilder.idriver.exceptions.IDriverErrorCode;
import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.IOSDevice;
import com.lbuilder.idriver.services.IService;
import com.sun.jna.ptr.PointerByReference;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.Date;

public class InformationService
extends IService {
    private IdriverLibrary.lockdownd_client_t service;

    public InformationService(IOSDevice device) throws IDriverException {
        super(device);
    }

    public Object getValueFor(String key, String domain) throws IDriverException {
        PointerByReference plistPointerByReference = new PointerByReference();
        this.library.lockdownd_get_value(this.service, domain, key, plistPointerByReference);
        PointerByReference stringPointerByReference = new PointerByReference();
        if (plistPointerByReference.getValue() != null) {
            int nodeType = this.library.plist_get_node_type(plistPointerByReference.getValue());
            IntBuffer intBuffer = IntBuffer.allocate(1);
            if (nodeType == 3) {
                this.library.plist_get_string_val(plistPointerByReference.getValue(), stringPointerByReference);
            }
            if (nodeType == 2) {
                DoubleBuffer doubleBuffer = DoubleBuffer.allocate(1);
                this.library.plist_get_real_val(plistPointerByReference.getValue(), doubleBuffer);
                return new Double(doubleBuffer.get());
            }
            this.library.plist_to_xml(plistPointerByReference.getValue(), stringPointerByReference, intBuffer);
            if (stringPointerByReference.getValue() == null) {
                throw new IDriverException("Didn't get a value back. Something wrong in info_service");
            }
            return stringPointerByReference.getValue().getString(0L);
        }
        return null;
    }

    public boolean isDevModeEnabled() throws IDriverException {
        return true;
    }

    public String getDeviceName() throws IDriverException {
        return (String)this.getValueFor("DeviceName", null);
    }

    public String getDeviceType() throws IDriverException {
        return (String)this.getValueFor("DeviceClass", null);
    }

    public String getBuildVersion() throws IDriverException {
        return (String)this.getValueFor("BuildVersion", null);
    }

    public String getProductVersion() throws IDriverException {
        return (String)this.getValueFor("ProductVersion", null);
    }

    public Date getDate() throws IDriverException {
        Double date = (Double)this.getValueFor("TimeIntervalSince1970", null);
        return new Date(date.longValue() * 1000L);
    }

    public String getDeviceDetail() throws IDriverException {
        return (String)this.getValueFor(null, null);
    }

    @Override
    public void free() throws IDriverException {
        IDriverErrorCode.throwIfNeeded(this.library.lockdownd_client_free(this.service));
    }

    @Override
    public void initService() throws IDriverException {
        PointerByReference ptr = new PointerByReference();
        this.library.lockdownd_client_new_with_handshake(this.device.getSDKHandle(), ptr, "ideviceinfo");
        this.service = new IdriverLibrary.lockdownd_client_t(ptr.getValue());
    }
}

