/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.IOSDevice;
import com.lbuilder.idriver.services.IService;
import com.lbuilder.idriver.services.InformationService;
import com.lbuilder.idriver.services.Util;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class ImageMountingService
extends IService {
    public static final String IMAGE_DEVELOPER = "Developer";
    public static final String MOUNT_STATUS_SUCCESS = "Complete";
    protected static final String MOUNT_IMAGE_PATH = "/private/var/mobile/Media/PublicStaging/staging.dimage";
    protected String developerDiskImageDir;
    protected String imageType = "Developer";
    private IdriverLibrary.mobile_image_mounter_client_t service;

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType == null ? IMAGE_DEVELOPER : imageType;
    }

    public String getDeveloperDiskImageDir() {
        return this.developerDiskImageDir;
    }

    public void setDeveloperDiskImageDir(String developerDiskImageDir) {
        this.developerDiskImageDir = developerDiskImageDir;
    }

    public ImageMountingService(IOSDevice device) throws IDriverException {
        super(device);
    }

    @Override
    protected void initService() throws IDriverException {
        PointerByReference ptr = new PointerByReference();
        this.library.mobile_image_mounter_start_service(this.device.getSDKHandle(), ptr, "label");
        this.service = new IdriverLibrary.mobile_image_mounter_client_t(ptr.getValue());
    }

    @Override
    public void free() throws IDriverException {
        this.library.mobile_image_mounter_hangup(this.service);
        this.library.mobile_image_mounter_free(this.service);
    }

    public boolean isImageMount() {
        return this.mountStatus() != null;
    }

    public NSArray mountStatus() {
        PointerByReference ptr = new PointerByReference();
        this.library.mobile_image_mounter_lookup_image(this.service, this.imageType, ptr);
        String xml = Util.toXMLString(ptr.getValue());
        try {
            NSArray images;
            NSDictionary dictionary = (NSDictionary)XMLPropertyListParser.parse(xml.getBytes());
            if (dictionary.containsKey("ImageSignature") && (images = (NSArray)dictionary.get("ImageSignature")) != null && images.count() > 0) {
                return images;
            }
        }
        catch (PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String mountImage() throws IOException, IDriverException {
        InformationService informationService = new InformationService(this.device);
        String productVersion = informationService.getProductVersion();
        String buildVersion = informationService.getBuildVersion();
        informationService.free();
        File imageFile = ImageMountingService.findDeveloperImage(new File(this.developerDiskImageDir), productVersion, buildVersion);
        return this.mountImage(imageFile);
    }

    public String mountImage(File imageFile) throws IOException, IDriverException {
        if (this.isImageMount()) {
            return MOUNT_STATUS_SUCCESS;
        }
        File sigFile = new File(imageFile.getCanonicalFile() + ".signature");
        if (!imageFile.exists() || !sigFile.exists()) {
            throw new IDriverException("image file or signature file not found" + imageFile.getCanonicalPath());
        }
        String statusString = "Fail";
        byte[] signature = FileUtils.readFileToByteArray(sigFile);
        final FileInputStream fileInputStream = new FileInputStream(imageFile);
        IdriverLibrary.mobile_image_mounter_upload_cb_t upload_cb = new IdriverLibrary.mobile_image_mounter_upload_cb_t(){
            byte[] readBuffer = new byte[65536];

            @Override
            public int apply(Pointer buffer, int length, Pointer user_data) {
                int readed = 0;
                try {
                    readed = fileInputStream.read(this.readBuffer, 0, length);
                    buffer.write(0L, this.readBuffer, 0, readed);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return readed;
            }
        };
        this.library.mobile_image_mounter_upload_image(this.service, this.imageType, FileUtils.sizeOf(imageFile), signature, (short)signature.length, upload_cb, null);
        fileInputStream.close();
        PointerByReference result = new PointerByReference();
        this.library.mobile_image_mounter_mount_image(this.service, MOUNT_IMAGE_PATH, signature, (short)signature.length, this.imageType, result);
        try {
            String xmlString = Util.toXMLString(result.getValue());
            this.log(xmlString);
            if (xmlString != null) {
                NSDictionary dictionary = (NSDictionary)XMLPropertyListParser.parse(xmlString.getBytes());
                if (dictionary.containsKey("Status")) {
                    return dictionary.get("Status").toString();
                }
                if (dictionary.containsKey("Error")) {
                    return dictionary.get("Error").toString();
                }
                return xmlString;
            }
        }
        catch (PropertyListFormatException | ParseException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            statusString = e.getMessage();
        }
        return statusString;
    }

    static File findDeveloperImage(File dsDir, String productVersion, String buildVersion) throws FileNotFoundException {
        String[] versionParts = Arrays.copyOf(productVersion.split("\\."), 3);
        int i = 0;
        while (i < versionParts.length) {
            if (versionParts[i] == null) {
                versionParts[i] = "0";
            }
            ++i;
        }
        String[] patterns = new String[]{String.format("%s\\.%s\\.%s \\(%s\\)", versionParts[0], versionParts[1], versionParts[2], buildVersion), String.format("%s\\.%s\\.%s \\(.*\\)", versionParts[0], versionParts[1], versionParts[2], buildVersion), String.format("%s\\.%s\\.%s", versionParts[0], versionParts[1], versionParts[2]), String.format("%s\\.%s \\(%s\\)", versionParts[0], versionParts[1], buildVersion), String.format("%s\\.%s \\(.*\\)", versionParts[0], versionParts[1], buildVersion), String.format("%s\\.%s", versionParts[0], versionParts[1])};
        File[] dirs = dsDir.listFiles();
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            File[] fileArray = dirs;
            int n3 = dirs.length;
            int n4 = 0;
            while (n4 < n3) {
                File dir = fileArray[n4];
                if (dir.isDirectory() && dir.getName().matches(pattern)) {
                    File dmg = new File(dir, "DeveloperDiskImage.dmg");
                    File sig = new File(dir, String.valueOf(dmg.getName()) + ".signature");
                    if (dmg.isFile() && sig.isFile()) {
                        return dmg;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        throw new FileNotFoundException("No DeveloperDiskImage.dmg found in " + dsDir.getAbsolutePath() + " for iOS version " + productVersion + " (" + buildVersion + ")");
    }
}

