/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.lbuilder.idriver.exceptions.IDriverErrorCode;
import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.DeviceService;
import com.lbuilder.idriver.services.SysLogService;
import com.sun.jna.ptr.PointerByReference;
import java.util.logging.Logger;

public class IOSDevice {
    private static final Logger log = Logger.getLogger(IOSDevice.class.getName());
    private final String uuid;
    private final IdriverLibrary.idevice_t sdk_handle;
    private SysLogService sysLogService;
    private String deviceName;

    public String getDeviceName() {
        return this.deviceName;
    }

    IOSDevice(String uuid) throws IDriverException {
        if (uuid == null) {
            throw new IllegalArgumentException("uuid cannot be null");
        }
        this.uuid = uuid;
        PointerByReference ptr = new PointerByReference();
        IDriverErrorCode.throwIfNeeded(IdriverLibrary.INSTANCE.idevice_new(ptr, uuid));
        this.sdk_handle = new IdriverLibrary.idevice_t(ptr.getValue());
        PointerByReference client = new PointerByReference();
        IdriverLibrary.INSTANCE.lockdownd_client_new(this.sdk_handle, client, "lbuilder");
        PointerByReference namePoint = new PointerByReference();
        IdriverLibrary.INSTANCE.lockdownd_get_device_name(new IdriverLibrary.lockdownd_client_t(client.getValue()), namePoint);
        this.deviceName = namePoint.getValue().getString(0L);
    }

    IdriverLibrary.idevice_t getSDKHandle() {
        return this.sdk_handle;
    }

    public void free() {
        DeviceService.remove(this.uuid);
        IdriverLibrary.INSTANCE.idevice_free(this.sdk_handle);
    }

    public String getUUID() {
        return this.uuid;
    }

    public SysLogService getSysLogService() throws IDriverException {
        if (this.sysLogService == null) {
            this.sysLogService = new SysLogService(this);
        }
        return this.sysLogService;
    }
}

