/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.IOSDevice;
import com.lbuilder.idriver.services.IService;
import com.lbuilder.idriver.services.UploadingCallBack;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.apache.commons.io.FileUtils;

public class IFileService
extends IService {
    public static final String PKG_PATH = "/PublicStaging";
    IdriverLibrary.afc_client_t service;

    public IFileService(IOSDevice device) throws IDriverException {
        super(device);
    }

    @Override
    public void initService() throws IDriverException {
        PointerByReference ptr = new PointerByReference();
        this.library.afc_client_start_service(this.device.getSDKHandle(), ptr, "label");
        this.service = new IdriverLibrary.afc_client_t(ptr.getValue());
    }

    @Override
    public void free() throws IDriverException {
        this.library.afc_client_free(this.service);
    }

    public String getFileInfo(String fileName) {
        PointerByReference ptr = new PointerByReference();
        this.library.afc_get_file_info(this.service, fileName, ptr);
        if (ptr.getValue() != null) {
            return ptr.getValue().getString(0L);
        }
        return null;
    }

    public void makeDirectory(String path) {
        this.library.afc_make_directory(this.service, path);
    }

    public long openFile(String path, int file_mode) {
        LongBuffer longBuffer = LongBuffer.allocate(1);
        this.library.afc_file_open(this.service, path, file_mode, longBuffer);
        return longBuffer.get();
    }

    public int writeFile(long fileHandler, byte[] data, int dataSize) {
        IntBuffer bytes_written = IntBuffer.allocate(1);
        this.library.afc_file_write(this.service, fileHandler, data, dataSize, bytes_written);
        return bytes_written.get();
    }

    public void closeFile(long fileHandler) {
        this.library.afc_file_close(this.service, fileHandler);
    }

    public String uploadFile(File file, String dstPath, String dstName, UploadingCallBack cb) throws IOException {
        if (!file.exists()) {
            throw new IOException(String.valueOf(file.getCanonicalPath()) + "not exit");
        }
        if (this.getFileInfo(dstPath) == null) {
            this.makeDirectory(dstName);
        }
        String fullPath = String.valueOf(dstPath) + "/" + dstName;
        long fileHandler = this.openFile(fullPath, 3);
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[65536];
        long totalSize = FileUtils.sizeOf(file);
        int readedSize = 0;
        long totalWrite = 0L;
        int lastPercent = 0;
        while ((readedSize = ((InputStream)inputStream).read(buffer)) > 0) {
            int newPercent;
            this.writeFile(fileHandler, buffer, readedSize);
            if (cb == null || (newPercent = (int)((totalWrite += (long)readedSize) * 100L / totalSize)) - lastPercent < 5) continue;
            lastPercent = newPercent;
            if (cb == null) continue;
            cb.onUploading(lastPercent);
        }
        if (cb != null && lastPercent != 100) {
            cb.onUploading(100);
        }
        this.closeFile(fileHandler);
        ((InputStream)inputStream).close();
        return fullPath;
    }
}

