/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.lbuilder.idriver.exceptions.IDriverErrorCode;
import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.services.DeviceCallBack;
import com.lbuilder.idriver.services.IOSDevice;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DeviceService {
    public static final DeviceService INSTANCE = new DeviceService();
    private final Map<String, IOSDevice> devices = new HashMap<String, IOSDevice>();

    public Map<String, IOSDevice> listDevices() {
        return this.devices;
    }

    public static synchronized IOSDevice get(String uuid) throws IDriverException {
        if (uuid == null) {
            throw new IllegalArgumentException("device id cannot be null.");
        }
        IOSDevice res = DeviceService.INSTANCE.devices.get(uuid);
        if (res == null) {
            res = new IOSDevice(uuid);
            DeviceService.INSTANCE.devices.put(uuid, res);
        }
        return res;
    }

    public static void free() throws IDriverException {
        for (String uuid : DeviceService.INSTANCE.devices.keySet()) {
            IOSDevice device = DeviceService.get(uuid);
            device.free();
        }
        DeviceService.INSTANCE.devices.clear();
    }

    public static void remove(String uuid) {
        DeviceService.INSTANCE.devices.remove(uuid);
    }

    public void startDetection(DeviceCallBack cb) throws IDriverException {
        if (cb == null) {
            cb = new DeviceCallBack(){

                @Override
                protected void onDeviceAdded(String uuid) {
                    try {
                        DeviceService.this.devices.put(uuid, new IOSDevice(uuid));
                    }
                    catch (IDriverException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                protected void onDeviceRemoved(String uuid) {
                    if (DeviceService.this.devices.containsKey(uuid)) {
                        DeviceService.this.devices.remove(uuid);
                    }
                }
            };
        }
        IDriverErrorCode.throwIfNeeded(IdriverLibrary.INSTANCE.idevice_event_subscribe(cb, null));
    }

    public void stopDetection() throws IDriverException {
        IDriverErrorCode.throwIfNeeded(IdriverLibrary.INSTANCE.idevice_event_unsubscribe());
    }

    public Map<String, String> getIOSDevices() {
        Iterator<String> iterable = this.devices.keySet().iterator();
        HashMap<String, String> resultHashMap = new HashMap<String, String>();
        while (iterable.hasNext()) {
            String uuidString = iterable.next();
            String name = this.devices.get(uuidString).getDeviceName();
            resultHashMap.put(uuidString, name);
        }
        return resultHashMap;
    }

    public String[] listDevicesUDID() throws IDriverException {
        PointerByReference deviceByReference = new PointerByReference();
        IntByReference msgByReference = new IntByReference();
        IDriverErrorCode.throwIfNeeded(IdriverLibrary.INSTANCE.idevice_get_device_list(deviceByReference, msgByReference));
        String[] uuidList = deviceByReference.getValue().getStringArray(0L);
        return uuidList;
    }
}

