/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.services;

import com.lbuilder.idriver.raw.IdriverLibrary;
import com.lbuilder.idriver.raw.idevice_event_t;
import com.lbuilder.idriver.services.DeviceService;
import com.sun.jna.Pointer;

public abstract class DeviceCallBack
implements IdriverLibrary.idevice_event_cb_t {
    private final String ADDED = "add";
    private final String REMOVED = "remove";

    @Override
    public void apply(idevice_event_t event, Pointer user_data) {
        String name = event.event == 1 ? "add" : "remove";
        String uuid = event.udid.getString(0L);
        switch (name) {
            case "add": {
                this.onDeviceAdded(uuid);
                break;
            }
            case "remove": {
                this.onDeviceRemoved(uuid);
                DeviceService.remove(uuid);
                break;
            }
            default: {
                throw new RuntimeException("event type " + name + "not recognized.");
            }
        }
    }

    protected abstract void onDeviceAdded(String var1);

    protected abstract void onDeviceRemoved(String var1);
}

