/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.raw;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DLLLoader {
    public DLLLoader() {
        String[] dllList = new String[]{"Idriver", "getopt", "libeay32", "libiconv", "ssleay32", "zlib"};
        if (Platform.isMac()) {
            dllList = new String[]{"libIdriver.dylib", "libcrypto.1.0.0.dylib", "libiconv.2.dylib", "liblzma.5.dylib", "libplist.2.dylib", "libssl.1.0.0.dylib", "libusbmuxd.2.dylib", "libxml2.2.dylib", "libz.1.dylib"};
        } else if (Platform.isLinux()) {
            dllList = new String[]{"Idriver", "libplist.so.3", "libusbmuxd.so.4", "crypto", "ssl", "z"};
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        String error = "";
        boolean success = false;
        int i = 0;
        while (i < 10 && !success) {
            block13: {
                try {
                    int n;
                    int n2;
                    Object[] objectArray;
                    File tmpDir = new File(tmp, "tmp" + i + "com.lbuilder.driver".hashCode());
                    if (tmpDir.exists()) {
                        try {
                            objectArray = tmpDir.listFiles();
                            n2 = objectArray.length;
                            n = 0;
                            while (n < n2) {
                                Object file = objectArray[n];
                                ((File)file).delete();
                                ++n;
                            }
                            tmpDir.delete();
                        }
                        catch (Exception e) {
                            System.out.println("delete temp fail " + e.getMessage());
                            break block13;
                        }
                    }
                    tmpDir.mkdirs();
                    objectArray = dllList;
                    n2 = dllList.length;
                    n = 0;
                    while (n < n2) {
                        Object string = objectArray[n];
                        this.extractLib((String)string, tmpDir);
                        ++n;
                    }
                    NativeLibrary.addSearchPath("Idriver", tmpDir.getAbsolutePath());
                    tmpDir.deleteOnExit();
                    success = true;
                    if (Platform.isLinux()) {
                        NativeLibrary JNA_NATIVE_LIB3 = NativeLibrary.getInstance("libplist.so.3");
                        NativeLibrary nativeLibrary = NativeLibrary.getInstance("libusbmuxd.so.4");
                    }
                    return;
                }
                catch (Exception e) {
                    if (e instanceof NullPointerException) {
                        e.printStackTrace();
                    }
                    error = e.getMessage();
                }
            }
            ++i;
        }
        System.out.println("init ios driver fail," + error);
    }

    private File extractLib(String name, File destDir) throws IOException {
        String libname = name.startsWith("/") ? name : this.mapSharedLibraryName(name);
        String resourcePath = String.valueOf(Platform.RESOURCE_PREFIX) + "/" + libname;
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        InputStream is = DLLLoader.class.getClassLoader().getResourceAsStream(resourcePath);
        File target = new File(destDir, libname);
        if (target.exists()) {
            target.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target);
            this.copy(is, out);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        return target;
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
    }

    private boolean isVersionedName(String name) {
        int so;
        if (name.startsWith("lib") && (so = name.lastIndexOf(".so.")) != -1 && so + 4 < name.length()) {
            int i = so + 4;
            while (i < name.length()) {
                char ch = name.charAt(i);
                if (!Character.isDigit(ch) && ch != '.') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private String mapSharedLibraryName(String libName) {
        if (Platform.isMac()) {
            if (libName.startsWith("lib") && (libName.endsWith(".dylib") || libName.endsWith(".jnilib"))) {
                return libName;
            }
            String name = System.mapLibraryName(libName);
            if (name.endsWith(".jnilib")) {
                return String.valueOf(name.substring(0, name.lastIndexOf(".jnilib"))) + ".dylib";
            }
            return name;
        }
        if (Platform.isLinux() || Platform.isFreeBSD() ? this.isVersionedName(libName) || libName.endsWith(".so") : (Platform.isAIX() ? libName.startsWith("lib") : Platform.isWindows() && (libName.endsWith(".drv") || libName.endsWith(".dll")))) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }
}

