/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.model;

import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import com.lbuilder.idriver.exceptions.IDriverException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.xml.sax.SAXException;

public class IpaInfo {
    String appID;
    String ipaPath;
    String infoPlist;
    String metaPlist;
    String sinfoPlist;
    private File file;

    public File getFile() {
        return this.file;
    }

    public String getAppID() {
        return this.appID;
    }

    public String getIpaPath() {
        return this.ipaPath;
    }

    public String getInfoPlist() {
        return this.infoPlist;
    }

    public String getMetaPlist() {
        return this.metaPlist;
    }

    public String getSinfoPlist() {
        return this.sinfoPlist;
    }

    public IpaInfo(File zipFile) throws IDriverException, IOException {
        if (!zipFile.exists()) {
            throw new IDriverException("the ipa file " + zipFile + " doesn't exist.");
        }
        NSDictionary infoPlist = null;
        ZipFile zip = new ZipFile(zipFile);
        String infoPlistPath = null;
        for (ZipArchiveEntry entry : Collections.list(zip.getEntries())) {
            if (!entry.getName().matches("Payload/[^/]+\\.app/Info\\.plist")) continue;
            infoPlistPath = entry.getName();
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                InputStream is = zip.getInputStream(entry);
                try {
                    try {
                        infoPlist = (NSDictionary)PropertyListParser.parse(is);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (is == null) break;
                    is.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        zip.close();
        if (infoPlist == null) {
            throw new IDriverException("parse ipa file Info.plist fail,not Info.plist found in " + zipFile.getAbsolutePath());
        }
        NSObject executeFile = infoPlist.get("CFBundleExecutable");
        NSObject bundleID = infoPlist.get("CFBundleIdentifier");
        this.appID = bundleID.toString();
        this.infoPlist = infoPlist.toXMLPropertyList();
        byte[] metaPlistBytes = this.getZipFileContent(zip, "iTunesMetadata.plist");
        try {
            this.metaPlist = metaPlistBytes == null ? null : PropertyListParser.parse(metaPlistBytes).toXMLPropertyList();
        }
        catch (PropertyListFormatException | ParseException | ParserConfigurationException | SAXException e) {
            throw new IDriverException("parse ipa file fail,iTunesMetadata.plist format error, " + e.getMessage());
        }
        byte[] sinfoBytes = this.getZipFileContent(zip, String.valueOf(infoPlistPath.replace("Info.plist", "")) + "SC_Info/" + executeFile + ".sinf");
        this.sinfoPlist = sinfoBytes == null ? null : new NSData(sinfoBytes).toXMLPropertyList();
        zip.close();
        this.file = zipFile;
    }

    private byte[] getZipFileContent(ZipFile zip, String fileName) throws IOException {
        Enumeration<ZipArchiveEntry> entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().equals(fileName)) continue;
            zip.getInputStream(zipEntry);
            InputStream inputStream = zip.getInputStream(zipEntry);
            byte[] buffer = new byte[inputStream.available()];
            inputStream.read(buffer);
            inputStream.close();
            return buffer;
        }
        return null;
    }
}

