/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.model;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.lbuilder.idriver.exceptions.IDriverException;
import com.lbuilder.idriver.services.DeviceService;
import com.lbuilder.idriver.services.IOSDevice;
import com.lbuilder.idriver.services.InformationService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DeviceInfo {
    private final String raw;
    private final boolean devMode;
    private final IOSDevice device;
    private String buildVersion;
    private String bluetoothAddress;
    private String boardId;
    private String cpuArchitecture;
    private String chipID;
    private String deviceClass;
    private String deviceColor;
    private String productType;
    private String productVersion;
    private String uniqueDeviceID;
    private String wifiAddress;
    private String deviceName;
    private String firmwareVersion;
    private String hardwareModel;
    private String modelNumber;

    public DeviceInfo(String uuid) throws IDriverException {
        String res;
        this.device = DeviceService.get(uuid);
        InformationService service = new InformationService(this.device);
        this.raw = res = service.getDeviceDetail();
        try {
            this.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot parse the device info xml " + e.getMessage(), e);
        }
        this.devMode = service.isDevModeEnabled();
    }

    public IOSDevice getDevice() {
        return this.device;
    }

    public String getBluetoothAddress() {
        return this.bluetoothAddress;
    }

    public String getBoardId() {
        return this.boardId;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public String getChipID() {
        return this.chipID;
    }

    public String getDeviceClass() {
        return this.deviceClass;
    }

    public String getDeviceColor() {
        return this.deviceColor;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public String getHardwareModel() {
        return this.hardwareModel;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getUniqueDeviceID() {
        return this.uniqueDeviceID;
    }

    public String getWifiAddress() {
        return this.wifiAddress;
    }

    private void parse() throws Exception {
        byte[] xml = this.raw.getBytes("UTF-8");
        NSDictionary rootDict = (NSDictionary)MyParser.parse(xml);
        this.buildVersion = rootDict.objectForKey("BuildVersion").toString();
        this.bluetoothAddress = this.get(rootDict, "BluetoothAddress");
        this.boardId = this.get(rootDict, "BoardId");
        this.cpuArchitecture = this.get(rootDict, "CPUArchitecture");
        this.chipID = this.get(rootDict, "ChipID");
        this.deviceClass = this.get(rootDict, "DeviceClass");
        this.deviceColor = this.get(rootDict, "DeviceColor");
        this.deviceName = this.get(rootDict, "DeviceName");
        this.firmwareVersion = this.get(rootDict, "FirmwareVersion");
        this.hardwareModel = this.get(rootDict, "HardwareModel");
        this.modelNumber = this.get(rootDict, "ModelNumber");
        this.productType = this.get(rootDict, "ProductType");
        this.productVersion = this.get(rootDict, "ProductVersion");
        this.uniqueDeviceID = this.get(rootDict, "UniqueDeviceID");
        this.wifiAddress = this.get(rootDict, "WiFiAddress");
    }

    private String get(NSDictionary rootDict, String key) {
        if (rootDict.objectForKey(key) != null) {
            return rootDict.objectForKey(key).toString();
        }
        System.out.println("key " + key + " is null.");
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DeviceInfo");
        sb.append("{buildVersion='").append(this.buildVersion).append('\'');
        sb.append(", cpuArchitecture='").append(this.cpuArchitecture).append('\'');
        sb.append(", deviceClass='").append(this.deviceClass).append('\'');
        sb.append(", deviceName='").append(this.deviceName).append('\'');
        sb.append(", productType='").append(this.productType).append('\'');
        sb.append(", productVersion='").append(this.productVersion).append('\'');
        sb.append(", uniqueDeviceID='").append(this.uniqueDeviceID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public static class MyParser {
        private static DocumentBuilderFactory docBuilderFactory = null;

        private static synchronized void initDocBuilderFactory() throws ParserConfigurationException {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setCoalescing(true);
        }

        private static synchronized DocumentBuilder getDocBuilder() throws ParserConfigurationException {
            if (docBuilderFactory == null) {
                MyParser.initDocBuilderFactory();
            }
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if ("-//Apple Computer//DTD PLIST 1.0//EN".equals(publicId) || "-//Apple//DTD PLIST 1.0//EN".equals(publicId)) {
                        return new InputSource(new ByteArrayInputStream(new byte[0]));
                    }
                    return null;
                }
            });
            return docBuilder;
        }

        public static NSObject parse(File f) throws Exception {
            DocumentBuilder docBuilder = MyParser.getDocBuilder();
            Document doc = docBuilder.parse(f);
            return MyParser.parseDocument(doc);
        }

        public static NSObject parse(byte[] bytes) throws Exception {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            return MyParser.parse(bis);
        }

        public static NSObject parse(InputStream is) throws Exception {
            DocumentBuilder docBuilder = MyParser.getDocBuilder();
            Document doc = docBuilder.parse(is);
            return MyParser.parseDocument(doc);
        }

        private static NSObject parseDocument(Document doc) throws Exception {
            DocumentType docType = doc.getDoctype();
            if (docType == null ? !doc.getDocumentElement().getNodeName().equals("plist") : !docType.getName().equals("plist")) {
                throw new UnsupportedOperationException("The given XML document is not a property list.");
            }
            List<Node> rootNodes = MyParser.filterElementNodes(doc.getDocumentElement().getChildNodes());
            if (rootNodes.size() > 0) {
                return MyParser.parseObject(rootNodes.get(0));
            }
            throw new Exception("No root node found!");
        }

        private static NSObject parseObject(Node n) throws Exception {
            String type = n.getNodeName();
            if (type.equals("dict")) {
                NSDictionary dict = new NSDictionary();
                List<Node> children = MyParser.filterElementNodes(n.getChildNodes());
                int i = 0;
                while (i < children.size()) {
                    Node key = children.get(i);
                    Node val = children.get(i + 1);
                    String keyString = key.getChildNodes().item(0).getNodeValue();
                    int j = 1;
                    while (j < key.getChildNodes().getLength()) {
                        keyString = String.valueOf(keyString) + key.getChildNodes().item(j).getNodeValue();
                        ++j;
                    }
                    dict.put(keyString, MyParser.parseObject(val));
                    i += 2;
                }
                return dict;
            }
            if (type.equals("array")) {
                List<Node> children = MyParser.filterElementNodes(n.getChildNodes());
                NSArray array = new NSArray(children.size());
                int i = 0;
                while (i < children.size()) {
                    array.setValue(i, MyParser.parseObject(children.get(i)));
                    ++i;
                }
                return array;
            }
            if (type.equals("true")) {
                return new NSNumber(true);
            }
            if (type.equals("false")) {
                return new NSNumber(false);
            }
            if (type.equals("integer")) {
                return new NSNumber(n.getChildNodes().item(0).getNodeValue());
            }
            if (type.equals("real")) {
                return new NSNumber(n.getChildNodes().item(0).getNodeValue());
            }
            if (type.equals("string")) {
                NodeList children = n.getChildNodes();
                if (children.getLength() == 0) {
                    return new NSString("");
                }
                String string = children.item(0).getNodeValue();
                int i = 1;
                while (i < children.getLength()) {
                    string = String.valueOf(string) + children.item(i).getNodeValue();
                    ++i;
                }
                return new NSString(string);
            }
            if (type.equals("data")) {
                if (n.getChildNodes().getLength() > 0) {
                    return new NSData(n.getChildNodes().item(0).getNodeValue());
                }
                return new NSData(null);
            }
            if (type.equals("date")) {
                return new NSDate(n.getChildNodes().item(0).getNodeValue());
            }
            return null;
        }

        private static List<Node> filterElementNodes(NodeList list) {
            ArrayList<Node> result = new ArrayList<Node>(list.getLength());
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    result.add(list.item(i));
                }
                ++i;
            }
            return result;
        }
    }
}

