/*
 * Decompiled with CFR 0.152.
 */
package com.lbuilder.idriver.model;

import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.XMLPropertyListParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ApplicationInfo {
    private static final Logger log = Logger.getLogger(ApplicationInfo.class.getName());
    private final NSDictionary properties;

    public static List<ApplicationInfo> extractApplications(String rawXML) {
        ArrayList<ApplicationInfo> infos = new ArrayList<ApplicationInfo>();
        NSArray apps = null;
        try {
            apps = (NSArray)XMLPropertyListParser.parse(rawXML.getBytes("UTF-8"));
        }
        catch (Exception e) {
            log.warning("Error parsing the xml returned : " + e.getMessage() + " , xml=\n" + rawXML);
            return infos;
        }
        int i = 0;
        while (i < apps.count()) {
            NSDictionary app = (NSDictionary)apps.objectAtIndex(i);
            ApplicationInfo info = new ApplicationInfo(app);
            infos.add(info);
            ++i;
        }
        return infos;
    }

    public ApplicationInfo(NSObject app) {
        this.properties = (NSDictionary)app;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Set<String> keySet() {
        return this.properties.keySet();
    }

    public NSDictionary getProperties() {
        return this.properties;
    }

    public String getApplicationId() {
        return this.properties.get("CFBundleIdentifier").toString();
    }

    public String getPath() {
        return this.properties.get("Path").toString();
    }

    public boolean canDebug() {
        NSDictionary entitlements = (NSDictionary)this.properties.objectForKey("Entitlements");
        return entitlements != null && entitlements.objectForKey("get-task-allow") != null && entitlements.objectForKey("get-task-allow").equals(new NSNumber(true));
    }

    public String toString() {
        return this.properties.toString();
    }
}

