/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.util;

import com.google.common.base.Throwables;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.store.XobjHelper;
import org.apache.xmlbeans.impl.values.TypeStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static String nodeToString(Node node) throws TransformerException {
        return XMLUtil.nodeToString(node, 2);
    }

    public static String nodeToString(Node node, int indent) throws TransformerException {
        StringWriter writer = new StringWriter();
        XMLUtil.serializeNode(node, indent, writer);
        return writer.toString();
    }

    public static void serializeNode(Node node, int indent, Writer writer) throws TransformerException {
        XMLUtil.serializeNode(node, indent, writer, false);
    }

    public static void serializeNode(Node node, int indent, Writer writer, boolean forceFragmentOutput) throws TransformerException {
        if (node instanceof Document && node instanceof TypeStore) {
            XMLUtil.serializeXmlObject(XobjHelper.getObject((TypeStore)node), indent, writer, forceFragmentOutput);
        } else {
            Transformer transformer = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), null).newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("method", "xml");
            if (indent > 0) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            }
            if (forceFragmentOutput || !(node instanceof Document)) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
    }

    public static void serializeXmlObject(XmlObject xmlObject, int indent, Writer writer) {
        XMLUtil.serializeXmlObject(xmlObject, indent, writer, false);
    }

    public static void serializeXmlObject(XmlObject xmlObject, int indent, Writer writer, boolean forceFragmentOutput) {
        XmlOptions options = new XmlOptions();
        options.setSaveInner();
        options.setSaveAggressiveNamespaces();
        options.setUseDefaultNamespace();
        options.setCharacterEncoding("UTF-8");
        if (indent > 0) {
            options.setSavePrettyPrint();
            options.setSavePrettyPrintIndent(indent);
        }
        if (forceFragmentOutput) {
            options.setSaveNoXmlDecl();
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xmlObject.save((OutputStream)byteArrayOutputStream, options);
            writer.append(byteArrayOutputStream.toString("UTF-8"));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Document parseXML(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = XMLUtil.getDocumentBuilderDisabledXXE();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(new InputSource(reader));
    }

    public static Document parseXML(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        return XMLUtil.parseXML(new StringReader(xmlString));
    }

    public static List<XmlObject> xmlObjectsAtXPath(Node document, String XPath) throws XmlException {
        return Arrays.asList(XmlObject.Factory.parse((Node)document).selectPath(XPath));
    }

    public static String textValueAtXPath(Node document, String XPath) throws XmlException {
        return XMLUtil.textValueAtXPath(XmlObject.Factory.parse((Node)document), XPath);
    }

    public static String textValueAtXPath(XmlObject xmlObject, String XPath) {
        XmlObject[] values = xmlObject.selectPath(XPath);
        if (values.length > 0) {
            return values[0].newCursor().getTextValue();
        }
        return null;
    }

    public static XmlObject[] getObjectsAtXPath(Node document, String XPath) throws XmlException {
        return XMLUtil.getObjectsAtXPath(XmlObject.Factory.parse((Node)document), XPath);
    }

    public static XmlObject[] getObjectsAtXPath(XmlObject xmlObject, String XPath) {
        return xmlObject.selectPath(XPath);
    }

    public static DocumentBuilderFactory getDocumentBuilderDisabledXXE() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XMLUtil.disableDocTypeXXE(dbf);
        return dbf;
    }

    public static void disableDocTypeXXE(DocumentBuilderFactory dbf) throws ParserConfigurationException {
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
    }
}

