/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.util;

import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;

public class MediaReader {
    public static long readNumber(BitReader bitReader, int numberOfBits, boolean signed) {
        return bitReader.readUBits(numberOfBits);
    }

    public static long readNumber(ByteSequence bs, int numberOfBits, boolean signed) throws IOException {
        if (numberOfBits % 8 != 0 || numberOfBits > 64) {
            throw new IllegalArgumentException("The number of bits specified: " + numberOfBits + " should be divisible by 8 and no more than 64.");
        }
        if (numberOfBits == 64) {
            // empty if block
        }
        byte[] buffer = new byte[numberOfBits / 8];
        bs.readFully(buffer);
        return MediaReader.byteArrayToLong(buffer);
    }

    public static long readU8(ByteSequence bs) throws IOException {
        return MediaReader.readNumber(bs, 8, false);
    }

    public static long readU16(ByteSequence bs) throws IOException {
        return MediaReader.readNumber(bs, 16, false);
    }

    public static long readU32(ByteSequence bs) throws IOException {
        return MediaReader.readNumber(bs, 32, false);
    }

    public static long readU64(ByteSequence bs) throws IOException {
        return MediaReader.readNumber(bs, 64, false);
    }

    public static long byteArrayToLong(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (data.length > 8) {
            throw new IllegalArgumentException("Cannot read a byte array that is longer than 8 bytes.");
        }
        long output = 0L;
        int dataElement = 0;
        for (int i = data.length - 1; i >= 0; --i) {
            output += (long)(0xFF & data[dataElement]) << i * 8;
            ++dataElement;
        }
        return output;
    }
}

