/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.util;

import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import com.apple.jingle.media.foundation.util.MediaReader;
import java.io.IOException;
import java.util.Arrays;

public class MPEG2MediaReader
extends MediaReader {
    public static byte[] readFourByteCode(ByteSequence bs) throws IOException {
        byte[] buffer = new byte[4];
        bs.readFully(buffer);
        return buffer;
    }

    public static byte[] readThreeByteCodePrefix(ByteSequence bs) throws IOException {
        byte[] buffer = new byte[3];
        bs.readFully(buffer);
        return buffer;
    }

    public static void readMarker(BitReader bitReader) {
        if (bitReader.readBit() != 1) {
            // empty if block
        }
    }

    public static void skipToNextStartCode(SeekableDataInput sdi) throws IOException {
        if (sdi.length() - sdi.getFilePointer() < 3L) {
            sdi.seek(sdi.length());
            return;
        }
        byte[] code = MPEG2MediaReader.readThreeByteCodePrefix(sdi);
        while (!Arrays.equals(code, new byte[]{0, 0, 1})) {
            if (code[1] == 0 && code[2] == 0) {
                sdi.seek(sdi.getFilePointer() - 2L);
            } else if (code[2] == 0) {
                sdi.seek(sdi.getFilePointer() - 1L);
            }
            if (sdi.length() - sdi.getFilePointer() < 3L) {
                sdi.seek(sdi.length());
                return;
            }
            code = MPEG2MediaReader.readThreeByteCodePrefix(sdi);
        }
        sdi.seek(sdi.getFilePointer() - 3L);
    }

    public static boolean matchesFourByteCode(SeekableDataInput sdi, byte[] fourByteCode) throws IOException {
        return Arrays.equals(MPEG2MediaReader.readFourByteCode(sdi), fourByteCode);
    }
}

