/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class CharacterStatistics {
    private boolean shouldUseControlCharacterWhiteList = true;
    private static final List<Integer> controlCharacterWhiteList = new ArrayList<Integer>();
    Map<Character.UnicodeBlock, CodePointBag> allBlockStatistics = new TreeMap<Character.UnicodeBlock, CodePointBag>(new Comparator<Character.UnicodeBlock>(){

        @Override
        public int compare(Character.UnicodeBlock o1, Character.UnicodeBlock o2) {
            return o1.toString().compareTo(o2.toString());
        }
    });
    Map<Directionality, CodePointBag> allDirectionalityStatistics = new TreeMap<Directionality, CodePointBag>();
    CodePointBag controlStatistics = new CodePointBag();
    CodePointBag unrecognizedBlocks = new CodePointBag();

    public void setShouldUseControlCharacterWhiteList(boolean shouldUse) {
        this.shouldUseControlCharacterWhiteList = shouldUse;
    }

    private CharacterStatistics() {
    }

    public static CharacterStatistics generateStatistics(CharSequence characters) {
        CharacterStatistics statistics = new CharacterStatistics();
        statistics.addCharacters(characters);
        return statistics;
    }

    public void addCharacters(CharSequence characters) {
        int character = 0;
        for (int position = 0; position < characters.length(); position += Character.charCount(character)) {
            character = Character.codePointAt(characters, position);
            Character.UnicodeBlock characterBlock = Character.UnicodeBlock.of(character);
            if (characterBlock == null) {
                this.unrecognizedBlocks.addCharacter(character);
            } else {
                CodePointBag blockCodePointBag = this.allBlockStatistics.get(characterBlock);
                if (blockCodePointBag == null) {
                    blockCodePointBag = new CodePointBag();
                    this.allBlockStatistics.put(characterBlock, blockCodePointBag);
                }
                blockCodePointBag.addCharacter(character);
            }
            byte characterDirectionalityByte = Character.getDirectionality(character);
            Directionality characterDirectionality = Directionality.fromByte(characterDirectionalityByte);
            CodePointBag directionalityCodePointBag = this.allDirectionalityStatistics.get((Object)characterDirectionality);
            if (directionalityCodePointBag == null) {
                directionalityCodePointBag = new CodePointBag();
                this.allDirectionalityStatistics.put(characterDirectionality, directionalityCodePointBag);
            }
            directionalityCodePointBag.addCharacter(character);
            if (!Character.isISOControl(character) || this.isCharInControlCharacterWhitelist(character)) continue;
            this.controlStatistics.addCharacter(character);
        }
    }

    private boolean isCharInControlCharacterWhitelist(int character) {
        return controlCharacterWhiteList.contains(character) && this.shouldUseControlCharacterWhiteList;
    }

    public Map<Character.UnicodeBlock, CodePointBag> getBlockStatistics() {
        return this.allBlockStatistics;
    }

    public Map<Directionality, CodePointBag> getDirectionalityStatistics() {
        return this.allDirectionalityStatistics;
    }

    public CodePointBag getControlStatistics() {
        return this.controlStatistics;
    }

    public CodePointBag getUnrecognizedBlockStatistics() {
        return this.unrecognizedBlocks;
    }

    public static void main(String[] arg) {
        char[] supplementary = Character.toChars(1);
        CharacterStatistics stats = CharacterStatistics.generateStatistics("\u00a1\u00a0\u00a9\u00f0\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645\u05e5\u0e0c\u13df\u2421");
        System.out.println(stats);
        stats.addCharacters(new String(supplementary));
        System.out.println(stats);
    }

    public String toString() {
        return "blockStatistics=\n" + this.getBlockStatistics() + "; \n\ndirectionalityStatistics=\n" + this.getDirectionalityStatistics() + "; \ncontrolStatistics=\n" + this.getControlStatistics() + "\n\nunrecognizedBlocks=\n" + this.getUnrecognizedBlockStatistics();
    }

    static {
        controlCharacterWhiteList.add(9);
        controlCharacterWhiteList.add(10);
    }

    public class CodePointBag {
        SortedSet<Integer> seenCharacters = new TreeSet<Integer>();
        long count;

        private CodePointBag() {
        }

        public long getCount() {
            return this.count;
        }

        public long getUnique() {
            return this.seenCharacters.size();
        }

        public Set<Integer> getCharacterSet() {
            return this.seenCharacters;
        }

        public String getCharacters() {
            StringBuffer result = new StringBuffer(this.seenCharacters.size());
            for (Integer codePoint : this.seenCharacters) {
                result.append(Character.toChars(codePoint));
            }
            return result.toString();
        }

        public String getNonControlCharacters() {
            StringBuffer result = new StringBuffer(this.seenCharacters.size());
            for (Integer codePoint : this.seenCharacters) {
                if (this.isControlCharacter(codePoint)) continue;
                result.append(Character.toChars(codePoint));
            }
            return result.toString();
        }

        public boolean isControlCharacter(int codePoint) {
            if (CharacterStatistics.this.shouldUseControlCharacterWhiteList) {
                return Character.isISOControl(codePoint) && !controlCharacterWhiteList.contains(codePoint);
            }
            return Character.isISOControl(codePoint);
        }

        void addCharacter(int c) {
            ++this.count;
            this.seenCharacters.add(c);
        }

        public String toString() {
            return "count=" + this.getCount() + "; unique=" + this.getUnique() + "; characters=" + this.getCharacters() + "\n";
        }
    }

    public static enum Directionality {
        UNDEFINED(-1),
        LEFT_TO_RIGHT(0),
        RIGHT_TO_LEFT(1),
        RIGHT_TO_LEFT_ARABIC(2),
        EUROPEAN_NUMBER(3),
        EUROPEAN_NUMBER_SEPARATOR(4),
        EUROPEAN_NUMBER_TERMINATOR(5),
        ARABIC_NUMBER(6),
        COMMON_NUMBER_SEPARATOR(7),
        NONSPACING_MARK(8),
        BOUNDARY_NEUTRAL(9),
        PARAGRAPH_SEPARATOR(10),
        SEGMENT_SEPARATOR(11),
        WHITESPACE(12),
        OTHER_NEUTRALS(13),
        LEFT_TO_RIGHT_EMBEDDING(14),
        LEFT_TO_RIGHT_OVERRIDE(15),
        RIGHT_TO_LEFT_EMBEDDING(16),
        RIGHT_TO_LEFT_OVERRIDE(17),
        POP_DIRECTIONAL_FORMAT(18);

        protected byte constant;

        private Directionality(byte constant) {
            this.constant = constant;
        }

        public static Directionality fromByte(byte directionalityByte) {
            for (Directionality directionality : Directionality.values()) {
                if (directionality.constant != directionalityByte) continue;
                return directionality;
            }
            throw new IllegalArgumentException("Unknown Directionality " + directionalityByte);
        }
    }
}

