/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.util;

import java.math.BigInteger;

public class BitReader {
    protected BigInteger bitHolder;
    protected byte[] bytes;
    protected byte currentByte;
    protected int currentByteOffset;
    protected int currentByteBitOffset;
    protected int currentBitOffset = 0;

    public BitReader(byte[] bytes) {
        this.bytes = bytes;
        this.currentByte = bytes[0];
        this.currentByteOffset = 0;
        this.currentByteBitOffset = 7;
    }

    public int readBit() {
        if (this.currentBitOffset > this.bytes.length * 8 - 1) {
            return -1;
        }
        if (this.currentByteBitOffset == -1) {
            this.currentByte = this.bytes[++this.currentByteOffset];
            this.currentByteBitOffset = 7;
        }
        ++this.currentBitOffset;
        return (this.currentByte & 1 << this.currentByteBitOffset--) != 0 ? 1 : 0;
    }

    public long readUBits(int bits) {
        if (bits > Long.bitCount(Long.MAX_VALUE)) {
            throw new IllegalArgumentException(bits + "  is too many bits for an Integer");
        }
        long value = 0L;
        while (bits > 0) {
            value <<= 1;
            value |= (long)this.readBit();
            --bits;
        }
        return value;
    }

    public long offset(int bit) {
        if (bit != 0 && bit != 1) {
            throw new IllegalArgumentException("A bit must be 0 or 1");
        }
        long offset = 0L;
        while (this.readBit() != bit) {
            ++offset;
        }
        return offset;
    }

    public long currentBitOffset() {
        return this.currentBitOffset;
    }
}

