/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum UniformTypeIdentifier {
    PUBLIC_DATA("public.data", null, Collections.emptyList(), Collections.emptyList(), "binary/octet-stream", null),
    COM_APPLE_QUICKTIME_MOVIE("com.apple.quicktime-movie", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".mov", ".qt"), "video/quicktime", "MooV"),
    PUBLIC_AC3_AUDIO("public.ac3-audio", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".ac3"), "audio/ac3", null),
    COM_SONIC_SCENARIST_SCC("com.sonic.scenarist.scc", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".scc"), "binary/octet-stream", null),
    COM_APPLE_QUICKTIME_TX3G("com.apple.quicktime-tx3g", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".texml"), "application/x-quicktime-tx3g", null),
    COM_APPLE_QUICKTIME_WVTT("com.apple.itunes.quicktime-wvtt", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".vtt"), "application/x-quicktime-wvtt", null),
    PUBLIC_JPEG("public.jpeg", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".jpg", ".jpeg"), "image/jpeg", "JPEG"),
    PUBLIC_PNG("public.png", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".png"), "image/png", null),
    PUBLIC_MPEG_4_VIDEO("public.mpeg-4-video", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".mp4", ".m4v"), "video/m4v", null),
    PUBLIC_MPEG_4_AUDIO("public.mpeg-4-audio", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".m4a", ".m4p"), "audio/m4a", null),
    PUBLIC_MP3_AUDIO("public.mp3", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".mp3", ".mp2", ".mp1"), "audio/mpeg", null),
    COM_MICROSOFT_WAVEFORM_AUDIO("com.microsoft.waveform-audio", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".wav"), "audio/wav", null),
    COM_APPLE_ITUNES_TIMED_TEXT("com.apple.itunes.timed-text", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".itt"), "application/x-ttaf1-dfxp", null),
    COM_APPLE_ITUNES_CHAPTERS("com.apple.itunes.chapters", null, Arrays.asList(PUBLIC_DATA), Arrays.asList("chapters.xml"), "application/x-itunes-chapters", null),
    PUBLIC_MPEG_2_VIDEO("public.mpeg-2p", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".mpg", ".mpeg", ".m2p"), "video/mp2p", null),
    COM_APPLE_COREAUDIO_FORMAT("com.apple.coreaudio-format", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".caf"), "audio/x-caf", "caff"),
    COM_APPLE_AIFF_AUDIO_FORMAT("com.apple.aiff-format", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".aiff", ".aif"), "audio/x-aiff", null),
    COM_APPLE_PKG("com.apple.pkg", null, Arrays.asList(new UniformTypeIdentifier[0]), Arrays.asList(".pkg"), "application/macAppPackage", null),
    COM_APPLE_IPA("com.apple.ipa", null, Arrays.asList(new UniformTypeIdentifier[0]), Arrays.asList(".ipa", ".zip"), "application/iosAppArchive", null),
    COM_APPLE_ICNS("com.apple.icns", null, Arrays.asList(new UniformTypeIdentifier[0]), Arrays.asList(".icns"), "image/icns", null),
    PUBLIC_JSON("public.json", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".json"), "application/json", null),
    PUBLIC_XML("public.xml", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".xml"), "text/xml", null),
    COM_DOLBY_CONTENTMAPPING("com.dolby.contentmapping", null, Arrays.asList(PUBLIC_XML), Arrays.asList(".hdr.xml"), "application/x-dolby-contentmapping", null),
    PUBLIC_CSV("public.csv", null, Arrays.asList(PUBLIC_DATA), Arrays.asList(".csv"), "text/csv", null),
    COM_APPLE_PROPERTY_LIST("com.apple.property-list", null, Arrays.asList(PUBLIC_XML), Arrays.asList(".plist"), "application/xml", null);

    public static final UniformTypeIdentifier kUTTypeQuickTimeMovie;
    private static final Map<String, UniformTypeIdentifier> identifierMap;
    private static final Map<String, UniformTypeIdentifier> fileExtensionMap;
    protected String identifier;
    protected String referenceURL;
    protected List<UniformTypeIdentifier> conformsToSet;
    protected List<String> extensionTagsList;
    protected String mimeTypeTag;
    protected String OSTypeTag;

    private UniformTypeIdentifier(@Nonnull String identifier, @Nonnull String referenceURL, @Nonnull List<UniformTypeIdentifier> conformsTo, @Nullable List<String> extensionTags, String mimeTypeTag, String OSTypeTag) {
        this.identifier = identifier;
        this.referenceURL = referenceURL;
        this.conformsToSet = conformsTo;
        this.extensionTagsList = extensionTags;
        this.mimeTypeTag = mimeTypeTag;
        this.OSTypeTag = OSTypeTag;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMimeTypeTag() {
        return this.mimeTypeTag;
    }

    public String getOSTypeTag() {
        return this.OSTypeTag;
    }

    public List<String> getExtensionTagsList() {
        return this.extensionTagsList;
    }

    public EnumSet<UniformTypeIdentifier> getConformsToSet() {
        return EnumSet.copyOf(this.conformsToSet);
    }

    @Nullable
    public static String getFileExtension(@Nullable String fileName) {
        int sep;
        if (null != fileName && (sep = fileName.lastIndexOf(46)) >= 0) {
            return fileName.substring(sep);
        }
        return null;
    }

    @Nullable
    public static UniformTypeIdentifier byFileName(@Nullable String fileName) {
        String ext = UniformTypeIdentifier.getFileExtension(fileName);
        if (null != ext) {
            return fileExtensionMap.get(ext);
        }
        return null;
    }

    @Nonnull
    public static UniformTypeIdentifier byFileName(@Nullable String fileName, @Nonnull UniformTypeIdentifier defaultValue) {
        UniformTypeIdentifier uti = UniformTypeIdentifier.byFileName(fileName);
        if (null != uti) {
            return uti;
        }
        return defaultValue;
    }

    @Nullable
    public static UniformTypeIdentifier findByIdentifier(String idStr) {
        return identifierMap.get(idStr);
    }

    static {
        kUTTypeQuickTimeMovie = COM_APPLE_QUICKTIME_MOVIE;
        identifierMap = new HashMap<String, UniformTypeIdentifier>();
        fileExtensionMap = new TreeMap<String, UniformTypeIdentifier>(String.CASE_INSENSITIVE_ORDER);
        for (UniformTypeIdentifier uti : UniformTypeIdentifier.values()) {
            identifierMap.put(uti.getIdentifier(), uti);
            for (String ext : uti.extensionTagsList) {
                fileExtensionMap.put(ext, uti);
            }
        }
    }
}

