/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io.multisource;

import com.apple.jingle.media.foundation.io.multisource.FileSource;
import com.apple.jingle.media.foundation.io.multisource.HttpClientSource;
import com.apple.jingle.media.foundation.io.multisource.SeekableSourceDataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;

public interface Source {
    public void prepare() throws IOException;

    public boolean isAvailable(long var1, long var3) throws IOException;

    public long getLength();

    public InputStream getInputStreamWithRange(long var1, long var3) throws IOException;

    public void release() throws IOException;

    public boolean allowPartial();

    public void setAllowPartial(boolean var1);

    @Nonnull
    public SeekableSourceDataInput openSeekableSourceDataInput() throws IOException;

    public static class Factory {
        public static Source sourceForURL(URL url) {
            return Factory.sourceForURL(url, null);
        }

        public static Source sourceForURL(URL url, String name) {
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                return new FileSource(new File(url.getFile()), name);
            }
            if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
                return new HttpClientSource(url, name);
            }
            throw new IllegalArgumentException("Protocol " + protocol + " not supported");
        }
    }
}

