/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io.multisource;

import com.apple.jingle.media.foundation.io.multisource.Source;
import com.apple.jingle.media.foundation.types.UniformTypeIdentifier;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.log4j.Logger;

@NotThreadSafe
public class SeekableSourceInputStream
extends InputStream {
    public static final String BUFFER_STRATGEY_PROPERTY_PREFIX = "com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream.";
    public static final String BUFFER_SIZE_PROPERTY = "com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream.bufferSize";
    public static final String HEAD_READ_COUNT_PROPERTY = "com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream.headBufferStatsToRecord";
    public static final String TAIL_READ_COUNT_PROPERTY = "com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream.tailBufferStatsToRecord";
    @Nonnegative
    public static final int maxHeadBufferReadsToRecord = SeekableSourceInputStream.readProperty("com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream.headBufferStatsToRecord", 32);
    @Nonnegative
    public static final int maxTailBufferReadsToRecord = SeekableSourceInputStream.readProperty("com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream.tailBufferStatsToRecord", 32);
    private static final Logger log = Logger.getLogger(SeekableSourceInputStream.class);
    @Nonnull
    private final Source source;
    @Nonnegative
    private final long fileSize;
    @Nonnull
    private final String fileName;
    @Nonnull
    private final BufferStrategy bufferStrategy;
    @Nonnull
    private byte[] buffer;
    @Nonnegative
    private int bufferOffset;
    @Nonnegative
    private int bufferLen;
    @Nonnegative
    private long fileOffset;
    @Nonnegative
    private long totalBytesConsumed = 0L;
    @Nonnegative
    private long totalSeekCount = 0L;
    @Nonnegative
    private long totalBufferReadBytes = 0L;
    @Nonnegative
    private int totalBufferReadCounts = 0;
    @Nonnegative
    private long totalBufferReadMillis = 0L;
    private final LinkedList<BufferFill> headBufferReads = new LinkedList();
    private final LinkedList<BufferFill> tailBufferReads = new LinkedList();
    private BufferFill currentBufferRead;
    private Mode mode = Mode.scan;

    public SeekableSourceInputStream(@Nonnull String fileName, @Nonnull Source source) throws IOException {
        this(fileName, source, CommonBufferStrategy.chooseBufferStrategy(fileName));
    }

    public SeekableSourceInputStream(@Nonnull String fileName, @Nonnull Source source, @Nonnull BufferStrategy bufferStrategy) throws IOException {
        this.fileName = fileName;
        source.prepare();
        this.bufferStrategy = bufferStrategy;
        this.source = source;
        this.fileSize = source.getLength();
        this.buffer = new byte[(int)Math.min((long)bufferStrategy.getDefaultBufferLength(this.mode), this.fileSize)];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SeekableSourceInputStream[").append("fileName=").append(this.fileName).append(",fileOffset=").append(this.getFilePointer()).append(",remaining=").append(this.remaining()).append(",available=").append(this.remainingBufferSize()).append(",strategy=").append(this.bufferStrategy).append("]");
        return sb.toString();
    }

    public String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("MZMediaFoundation.SeekableSource.BufferPerformance[").append("fileName=").append(this.fileName).append(",fileSize=").append(this.fileSize).append(",consumedBytes=").append(this.totalBytesConsumed).append(",seekCalls=").append(this.totalSeekCount).append(",readBytes=").append(this.totalBufferReadBytes).append(",readCount=").append(this.totalBufferReadCounts).append(",readMillis=").append(this.totalBufferReadMillis).append("]");
        for (BufferFill read : this.headBufferReads) {
            sb.append(' ').append(read);
        }
        Iterator tailReads = this.tailBufferReads.iterator();
        if (this.tailBufferReads.size() > maxTailBufferReadsToRecord) {
            sb.append(" ...");
            tailReads.next();
        }
        while (tailReads.hasNext()) {
            sb.append(' ').append(tailReads.next());
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        log.info((Object)this.getStats());
        this.source.release();
    }

    @Nonnegative
    public long getFilePointer() {
        return this.fileOffset + (long)this.bufferOffset;
    }

    @Nonnull
    public String getFileName() {
        return this.fileName;
    }

    @Nonnegative
    public long length() {
        return this.fileSize;
    }

    public void seek(@Nonnegative long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek position must be a non-negative value");
        }
        if (pos > this.fileSize) {
            throw new EOFException("Cannot seek beyond the end of the source");
        }
        if (pos >= this.fileOffset && pos <= this.fileOffset + (long)this.bufferLen) {
            this.bufferOffset = (int)(pos - this.fileOffset);
        } else {
            this.bufferOffset = 0;
            this.bufferLen = 0;
            this.fileOffset = pos;
        }
        ++this.totalSeekCount;
    }

    @Nonnegative
    protected final int remainingBufferSize() {
        return this.bufferLen - this.bufferOffset;
    }

    @Override
    @Nonnegative
    public int available() {
        return this.remainingBufferSize();
    }

    @Nonnegative
    public final long remaining() {
        return this.length() - this.getFilePointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchBuffer() throws IOException {
        if (this.remainingBufferSize() < 1 && this.remaining() > 0L) {
            long startTime = System.currentTimeMillis();
            try {
                int desiredBufferLen;
                this.fileOffset += (long)this.bufferOffset;
                this.bufferOffset = 0;
                this.bufferLen = 0;
                if (this.currentBufferRead != null) {
                    this.mode = this.mode.selectMode(this.currentBufferRead.efficiency());
                }
                if (this.buffer.length < (desiredBufferLen = (int)Math.min((long)this.bufferStrategy.getDefaultBufferLength(this.mode), this.fileSize))) {
                    this.buffer = new byte[desiredBufferLen];
                }
                int toRead = (int)Math.min((long)this.buffer.length, this.remaining());
                log.info((Object)(this + ": Filling buffer with " + toRead));
                try (InputStream in = this.source.getInputStreamWithRange(this.fileOffset, this.fileOffset + (long)toRead - 1L);){
                    int read;
                    while (toRead - this.bufferLen > 0 && (read = in.read(this.buffer, this.bufferLen, toRead - this.bufferLen)) >= 0) {
                        this.bufferLen += read;
                    }
                }
                if (this.remainingBufferSize() < 1) {
                    throw new IOException("Unable to fetch desired bytes");
                }
            }
            finally {
                long endTime = System.currentTimeMillis();
                long transferDuration = endTime - startTime;
                this.totalBufferReadMillis += transferDuration;
                this.totalBufferReadBytes += (long)this.bufferLen;
                ++this.totalBufferReadCounts;
                this.currentBufferRead = new BufferFill(this.totalBufferReadCounts, this.bufferLen, transferDuration);
                if (this.headBufferReads.size() < maxHeadBufferReadsToRecord) {
                    this.headBufferReads.add(this.currentBufferRead);
                } else {
                    this.tailBufferReads.add(this.currentBufferRead);
                    while (this.tailBufferReads.size() > maxTailBufferReadsToRecord + 1) {
                        this.tailBufferReads.removeFirst();
                    }
                }
            }
        }
    }

    private static final int readProperty(@Nonnull String propertyKey, int defaultValue) {
        try {
            String value = System.getProperty(propertyKey);
            if (null != value) {
                return Integer.parseInt(value);
            }
        }
        catch (Exception ignored) {
            log.info((Object)("Encountered exception while trying to read property '" + propertyKey + "'"), (Throwable)ignored);
        }
        return defaultValue;
    }

    @Override
    public int read(byte[] data, int offset, int len) throws IOException {
        if (this.remaining() < 1L) {
            return -1;
        }
        this.fetchBuffer();
        int canRead = Math.min(this.remainingBufferSize(), len);
        System.arraycopy(this.buffer, this.bufferOffset, data, offset, canRead);
        this.bufferOffset += canRead;
        this.totalBytesConsumed += (long)canRead;
        this.currentBufferRead.incBytesConsumed(canRead);
        return canRead;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining() < 1L) {
            return -1;
        }
        this.fetchBuffer();
        ++this.totalBytesConsumed;
        this.currentBufferRead.incBytesConsumed(1);
        return this.buffer[this.bufferOffset++] & 0xFF;
    }

    static /* synthetic */ int access$100(String x0, int x1) {
        return SeekableSourceInputStream.readProperty(x0, x1);
    }

    public static class BufferFill {
        private final long readBytes;
        private final long readMillis;
        private final int readNo;
        private long consumeBytes;

        public BufferFill(int readNo, long readBytes, long readMillis) {
            this.readNo = readNo;
            this.readBytes = readBytes;
            this.readMillis = readMillis;
        }

        public void incBytesConsumed(int bytesConsumed) {
            this.consumeBytes += (long)bytesConsumed;
        }

        public float efficiency() {
            if (this.readBytes > 0L) {
                return (float)this.consumeBytes / (float)this.readBytes;
            }
            return 1.0f;
        }

        public String toString() {
            return "Fill[readNo=" + this.readNo + ",bytes=" + this.readBytes + ",millis=" + this.readMillis + ",consumed=" + this.consumeBytes + "]";
        }
    }

    public static enum CommonBufferStrategy implements BufferStrategy
    {
        smallScans(SeekableSourceInputStream.access$100("com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream..smallScans.bufferSize", 65536)),
        mediumScans(SeekableSourceInputStream.access$100("com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream..mediumScans.bufferSize", 262144)),
        readEntireFile(SeekableSourceInputStream.access$100("com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream..bufferSize", 0x100000));

        private final Map<Mode, Integer> bufferLengthByMode = new EnumMap<Mode, Integer>(Mode.class);

        private CommonBufferStrategy(int defaultBufferLength) {
            this.bufferLengthByMode.put(Mode.scan, defaultBufferLength);
            if (defaultBufferLength < 0x100000) {
                this.bufferLengthByMode.put(Mode.read, 4 * defaultBufferLength);
            } else {
                this.bufferLengthByMode.put(Mode.read, defaultBufferLength);
            }
        }

        @Override
        @Nonnegative
        public int getDefaultBufferLength(Mode mode) {
            return this.bufferLengthByMode.get((Object)mode);
        }

        @Nonnull
        public static BufferStrategy chooseBufferStrategy(@Nullable String fileName) {
            if (null != fileName) {
                UniformTypeIdentifier uti = UniformTypeIdentifier.byFileName(fileName, UniformTypeIdentifier.PUBLIC_DATA);
                switch (uti) {
                    case PUBLIC_AC3_AUDIO: 
                    case COM_SONIC_SCENARIST_SCC: 
                    case COM_APPLE_ITUNES_TIMED_TEXT: 
                    case COM_APPLE_QUICKTIME_TX3G: 
                    case COM_APPLE_QUICKTIME_WVTT: 
                    case PUBLIC_MPEG_4_VIDEO: {
                        return readEntireFile;
                    }
                    case PUBLIC_MPEG_2_VIDEO: {
                        return mediumScans;
                    }
                    case PUBLIC_MPEG_4_AUDIO: 
                    case COM_APPLE_QUICKTIME_MOVIE: 
                    case PUBLIC_JPEG: {
                        return smallScans;
                    }
                }
            }
            return readEntireFile;
        }
    }

    public static enum Mode {
        scan{

            @Override
            public Mode selectMode(float bufferEfficiency) {
                if ((double)bufferEfficiency >= 0.9) {
                    return read;
                }
                return scan;
            }
        }
        ,
        read{

            @Override
            public Mode selectMode(float bufferEfficiency) {
                if ((double)bufferEfficiency < 0.9) {
                    return scan;
                }
                return read;
            }
        };


        public abstract Mode selectMode(float var1);
    }

    @Immutable
    public static interface BufferStrategy {
        @Nonnegative
        public int getDefaultBufferLength(Mode var1);
    }
}

