/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io.multisource;

import com.apple.jingle.media.foundation.io.HttpClientUtils;
import com.apple.jingle.media.foundation.io.multisource.SeekableSourceDataInput;
import com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream;
import com.apple.jingle.media.foundation.io.multisource.Source;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.log4j.Logger;

public class HttpClientSource
implements Source {
    protected static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("bytes ([\\d]*)-([\\d]*)/([\\d]*|\\*)");
    private static final int CONTENT_RANGE_PATTERN_START_MATCH_GROUP = 1;
    private static final int CONTENT_RANGE_PATTERN_END_MATCH_GROUP = 2;
    private static final String ACCEPT_RANGES_HEADER = "Accept-Ranges";
    public static final String X_APPLE_JINGLE_REQUESTING_INSTANCE = "X-Apple-Jingle-Requesting-Instance";
    public static final String X_APPLE_JINGLE_DATA_CENTER = "X-Apple-Jingle-Data-Center";
    protected static final Logger LOG = Logger.getLogger(HttpClientSource.class);
    protected URL sourceURL;
    protected HttpClient httpClient;
    protected HttpClientParams httpClientParams;
    protected Properties requestHeaders;
    protected GetMethod getMethod;
    protected HeadMethod headMethod;
    private boolean isAvailable = false;
    private boolean isPrepared = false;
    protected long length = 0L;
    @Nonnegative
    protected int lastHttpStatusCode;
    private String name = "unnamed";
    protected List<Header> headHeaders;
    protected boolean allowPartial = false;

    public HttpClientSource(URL sourceURL) {
        this.sourceURL = sourceURL;
        this.requestHeaders = new Properties();
    }

    public HttpClientSource(URL sourceURL, String name) {
        this(sourceURL);
        this.name = name;
    }

    public void setHttpClientParams(HttpClientParams httpClientParams) {
        this.httpClientParams = httpClientParams;
    }

    public void setHttpClientHeaders(Properties headers) {
        this.requestHeaders = headers;
    }

    @Override
    public void prepare() throws IOException {
        String dataCenterName;
        if (this.isPrepared) {
            return;
        }
        this.isAvailable = false;
        this.length = 0L;
        this.getMethod = null;
        this.headMethod = null;
        this.httpClient = new HttpClient();
        if (this.httpClientParams != null) {
            this.httpClient.setParams(this.httpClientParams);
        } else {
            HttpClientUtils.setDefaultTimeoutParameters(this.httpClient);
        }
        this.headMethod = new HeadMethod(this.sourceURL.toString());
        if (System.getProperty("com.apple.jingle.applicationSignature") != null && !this.requestHeaders.containsKey(X_APPLE_JINGLE_REQUESTING_INSTANCE)) {
            this.requestHeaders.setProperty(X_APPLE_JINGLE_REQUESTING_INSTANCE, System.getProperty("com.apple.jingle.applicationSignature"));
        }
        if (null != (dataCenterName = System.getProperty("com.apple.itunes.asset.repository.core.config.AssetRepositoryConfig.dataCenter")) && !this.requestHeaders.contains(X_APPLE_JINGLE_DATA_CENTER)) {
            this.requestHeaders.setProperty(X_APPLE_JINGLE_DATA_CENTER, dataCenterName);
        }
        this.attachHeaders((HttpMethod)this.headMethod);
        this.lastHttpStatusCode = HttpClientUtils._executeMethod(this.httpClient, (HttpMethod)this.headMethod);
        List<Header> headResponseHeaders = HttpClientSource.getHeaders((HttpMethod)this.headMethod);
        LOG.info((Object)(this + " HEAD " + this.headMethod.getStatusCode() + ": " + headResponseHeaders));
        if (this.lastHttpStatusCode == 200) {
            this.isAvailable = true;
            this.length = this.headMethod.getResponseContentLength();
            this.headHeaders = headResponseHeaders;
        }
        if (this.headMethod != null) {
            this.headMethod.releaseConnection();
        }
        this.isPrepared = true;
    }

    protected void attachHeaders(HttpMethod method) {
        if (null != this.requestHeaders) {
            Enumeration<?> names = this.requestHeaders.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                method.addRequestHeader(name, this.requestHeaders.getProperty(name));
            }
        }
    }

    public List<Header> headers() {
        if (!this.isPrepared) {
            throw new IllegalStateException();
        }
        return this.headHeaders;
    }

    public HeadMethod getHeadMethod() {
        return this.headMethod;
    }

    @Override
    public boolean isAvailable(long start, long end) throws IOException {
        return this.isAvailable && end < this.length;
    }

    @Override
    public long getLength() {
        if (!this.isPrepared) {
            throw new IllegalStateException();
        }
        return this.length;
    }

    @Override
    public InputStream getInputStreamWithRange(long start, long end) throws IOException {
        if (!this.isPrepared) {
            throw new IllegalStateException();
        }
        if (start > 0L || end < this.length - 1L) {
            LOG.debug((Object)(this + " range read: " + start + "-" + end));
            Header acceptRangesHeader = this.headMethod.getResponseHeader(ACCEPT_RANGES_HEADER);
            if (acceptRangesHeader == null || !"none".equals(acceptRangesHeader.getValue())) {
                this.getMethod = new GetMethod(this.sourceURL.toString());
                this.attachHeaders((HttpMethod)this.getMethod);
                this.getMethod.setRequestHeader("Range", "bytes=" + start + "-" + end);
                HttpClientUtils._executeMethod(this.httpClient, (HttpMethod)this.getMethod);
                this.lastHttpStatusCode = this.getMethod.getStatusCode();
                LOG.debug((Object)(this + " GET " + this.lastHttpStatusCode + ": " + HttpClientSource.getHeaders((HttpMethod)this.getMethod)));
                if (this.lastHttpStatusCode == 206 && this.verifyRange(this.getMethod, start, end)) {
                    LOG.debug((Object)(this + " 206: range verified"));
                    return this.getMethod.getResponseBodyAsStream();
                }
                try {
                    this.getMethod.releaseConnection();
                    this.getMethod.abort();
                }
                catch (Exception e) {
                    LOG.info((Object)"Failed to abort Range GET", (Throwable)e);
                }
            }
            LOG.info((Object)(this + " falling back to regular GET"));
            this.getMethod = new GetMethod(this.sourceURL.toString());
            this.attachHeaders((HttpMethod)this.getMethod);
            HttpClientUtils._executeMethod(this.httpClient, (HttpMethod)this.getMethod);
            this.lastHttpStatusCode = this.getMethod.getStatusCode();
            if (this.lastHttpStatusCode == 200) {
                LOG.info((Object)(this + " GET not ranged, skipping " + start + " bytes: " + HttpClientSource.getHeaders((HttpMethod)this.getMethod)));
                InputStream is = this.getMethod.getResponseBodyAsStream();
                while (start > 0L) {
                    start -= is.skip(start);
                }
                this.lastHttpStatusCode = this.getMethod.getStatusCode();
                return is;
            }
            throw new IOException("Unable to retrieve via " + this.getMethod + "; " + String.format("Got HTTP Status [%d] for [%s]", this.lastHttpStatusCode, this.sourceURL));
        }
        this.getMethod = new GetMethod(this.sourceURL.toString());
        this.attachHeaders((HttpMethod)this.getMethod);
        HttpClientUtils._executeMethod(this.httpClient, (HttpMethod)this.getMethod);
        this.lastHttpStatusCode = this.getMethod.getStatusCode();
        LOG.info((Object)(this + " " + this.lastHttpStatusCode + " regular GET: " + HttpClientSource.getHeaders((HttpMethod)this.getMethod)));
        if (this.lastHttpStatusCode == 200) {
            return this.getMethod.getResponseBodyAsStream();
        }
        throw new IOException("Unable to retrieve via " + this.getMethod + "; " + String.format("Got HTTP Status [%d] for [%s]", this.lastHttpStatusCode, this.sourceURL));
    }

    private static List<Header> getHeaders(HttpMethod method) {
        return Arrays.asList(method.getResponseHeaders());
    }

    private boolean verifyRange(GetMethod getMethod, long start, long end) throws IOException {
        if (getMethod.getResponseHeader("Content-Range") == null) {
            return false;
        }
        Matcher matcher = CONTENT_RANGE_PATTERN.matcher(getMethod.getResponseHeader("Content-Range").getValue());
        if (matcher.matches()) {
            long streamStart = Long.parseLong(matcher.group(1));
            long streamEnd = Long.parseLong(matcher.group(2));
            if (streamStart != start || streamEnd != end) {
                LOG.warn((Object)("Server returned the range [" + streamStart + "," + streamEnd + "] but we should have requested [" + start + "," + end + "]"));
            }
            return streamStart == start && streamEnd >= end;
        }
        return false;
    }

    @Override
    @Nonnull
    public SeekableSourceDataInput openSeekableSourceDataInput() throws IOException {
        this.prepare();
        if (this.lastHttpStatusCode >= 200 && this.lastHttpStatusCode < 400) {
            return new SeekableSourceDataInput(new SeekableSourceInputStream(this.sourceURL.toExternalForm(), this));
        }
        if (this.lastHttpStatusCode == 404) {
            throw new FileNotFoundException("Received 404 while constructing SeekableSourceDataInput from url " + this.sourceURL);
        }
        throw new IOException("Received " + this.lastHttpStatusCode + " while constructing SeekableSourceDataInput from url " + this.sourceURL);
    }

    @Override
    public void release() throws IOException {
        if (this.getMethod != null) {
            this.getMethod.releaseConnection();
        }
    }

    @Override
    public boolean allowPartial() {
        return this.allowPartial;
    }

    @Override
    public void setAllowPartial(boolean anAllowPartial) {
        this.allowPartial = anAllowPartial;
    }

    public String toString() {
        String msg = this.getClass().getSimpleName() + ": " + this.name + " " + this.sourceURL;
        try {
            URI finalURI = this.headMethod.getURI();
            if (!finalURI.toString().equals(this.sourceURL.toString())) {
                msg = msg + " --redirect--> " + finalURI;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }
}

