/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io.multisource;

import com.apple.jingle.media.foundation.io.multisource.SeekableSourceDataInput;
import com.apple.jingle.media.foundation.io.multisource.SeekableSourceInputStream;
import com.apple.jingle.media.foundation.io.multisource.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileSource
implements Source {
    protected File file;
    protected FileInputStream fileInputStream;
    private String name = "unnamed";

    public FileSource(File file) {
        this.file = file;
    }

    public FileSource(File file, String name) {
        this(file);
        this.name = name;
    }

    @Override
    public void prepare() throws IOException {
    }

    @Override
    public boolean isAvailable(long start, long end) throws IOException {
        return this.file.exists() && this.file.canRead() && end < this.file.length();
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public InputStream getInputStreamWithRange(long start, long end) throws IOException {
        this.fileInputStream = new FileInputStream(this.file);
        while (start > 0L) {
            start -= this.fileInputStream.skip(start);
        }
        return this.fileInputStream;
    }

    @Override
    public void release() throws IOException {
        if (this.fileInputStream != null) {
            this.fileInputStream.close();
        }
    }

    @Override
    public boolean allowPartial() {
        return false;
    }

    @Override
    public void setAllowPartial(boolean allowPartial) {
    }

    public String toString() {
        return "FileSource: " + this.name + " " + this.file.getAbsolutePath();
    }

    @Override
    public SeekableSourceDataInput openSeekableSourceDataInput() throws IOException {
        return new SeekableSourceDataInput(new SeekableSourceInputStream(this.name, this));
    }
}

