/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io.multisource;

import com.apple.jingle.media.foundation.io.multisource.Source;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class FailoverInputStream
extends InputStream {
    private final List<Source> allSources;
    private final Iterator<Source> sourceIterator;
    protected Source currentSource;
    protected InputStream currentInputStream;
    private final Multiset<Source> sourceRetries = HashMultiset.create();
    protected long currentSourceStart;
    protected long currentSourceEnd;
    protected long minimumBytesExpected;
    protected long totalBytesRead;
    protected FailoverInputStreamEventListener eventListener;

    public FailoverInputStream(List<Source> aSources, long aMinimumBytesExpected, FailoverInputStreamEventListener listener, short retryCount) {
        if (aSources == null || aSources.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one source.");
        }
        if (aMinimumBytesExpected < 0L) {
            throw new IllegalArgumentException("Minimum expected bytes must be non-negative");
        }
        if (retryCount < 0) {
            throw new IllegalArgumentException("Retry count must be non-negative");
        }
        this.allSources = aSources;
        this.sourceIterator = Iterables.concat(Collections.nCopies(retryCount + 1, aSources)).iterator();
        this.minimumBytesExpected = aMinimumBytesExpected;
        this.currentSourceStart = 0L;
        this.currentSourceEnd = this.minimumBytesExpected - 1L;
        this.eventListener = listener;
    }

    public FailoverInputStream(List<Source> aSources, long aMinimumBytesExpected, short retryCount) {
        this(aSources, aMinimumBytesExpected, new DefaultFailoverInputStreamEventListener(), retryCount);
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public long getMinimumBytesExpected() {
        return this.minimumBytesExpected;
    }

    @Override
    public int read() throws IOException {
        byte[] byteArray = new byte[1];
        int bytesRead = 0;
        while (bytesRead == 0) {
            bytesRead = this.read(byteArray, 0, 1);
        }
        return bytesRead == -1 ? -1 : 0xFF & byteArray[0];
    }

    @Override
    public int read(@Nonnull byte[] bytes, int offset, int length) throws IOException {
        int bytesRead;
        this.primeSource();
        try {
            bytesRead = this.currentInputStream.read(bytes, offset, length);
            if (bytesRead == -1) {
                this.eventListener.didRead(this, this.currentSource, bytes, this.currentSourceStart, this.totalBytesRead);
                if (this.totalBytesRead < this.minimumBytesExpected) {
                    this.eventListener.notAvailable(this, this.currentSource, this.currentSourceStart, this.currentSourceEnd);
                    this.nextSource();
                    return 0;
                }
            } else {
                this.totalBytesRead += (long)bytesRead;
            }
        }
        catch (IOException ioe) {
            this.eventListener.didRead(this, this.currentSource, bytes, this.currentSourceStart, this.totalBytesRead);
            this.eventListener.exception(this, this.currentSource, this.currentSourceStart, this.currentSourceEnd, "read", ioe);
            this.nextSource();
            return 0;
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentSource();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void primeSource() throws IOException {
        while (this.currentSource == null) {
            this.nextSource();
        }
    }

    private void nextSource() throws IOException {
        if (!this.sourceIterator.hasNext()) {
            throw new EOFException("Exhausted sources: " + this);
        }
        this.switchSources(this.sourceIterator.next());
    }

    protected void switchSources(Source newSource) throws IOException {
        this.sourceRetries.add((Object)newSource);
        int currentSourceRetry = this.sourceRetries.count((Object)newSource) - 1;
        this.closeCurrentSource();
        boolean shouldCloseNewSource = true;
        try {
            this.eventListener.willPrepare(this, newSource, currentSourceRetry);
            newSource.prepare();
            this.eventListener.didPrepare(this, newSource);
            if (newSource.isAvailable(this.totalBytesRead, this.currentSourceEnd)) {
                this.eventListener.willRead(this, newSource, currentSourceRetry, this.totalBytesRead, this.currentSourceEnd);
                this.currentInputStream = newSource.getInputStreamWithRange(this.totalBytesRead, this.currentSourceEnd);
                this.currentSource = newSource;
                this.currentSourceStart = this.totalBytesRead;
                shouldCloseNewSource = false;
            } else {
                long newSourceLength = newSource.getLength() - 1L;
                if (newSource.allowPartial() && newSourceLength > this.totalBytesRead && newSource.isAvailable(this.totalBytesRead, newSourceLength)) {
                    this.eventListener.willRead(this, newSource, currentSourceRetry, this.totalBytesRead, newSourceLength);
                    this.currentInputStream = newSource.getInputStreamWithRange(this.totalBytesRead, newSourceLength);
                    this.currentSource = newSource;
                    this.currentSourceStart = this.totalBytesRead;
                    shouldCloseNewSource = false;
                } else {
                    this.eventListener.notAvailable(this, newSource, this.totalBytesRead, this.currentSourceEnd);
                }
            }
        }
        catch (IOException ioe) {
            this.eventListener.exception(this, newSource, this.totalBytesRead, this.currentSourceEnd, "opening", ioe);
        }
        if (shouldCloseNewSource) {
            try {
                this.eventListener.willRelease(this, newSource, null);
                newSource.release();
                this.eventListener.didRelease(this, newSource);
            }
            catch (IOException ioe2) {
                this.eventListener.exception(this, newSource, this.totalBytesRead, this.currentSourceEnd, "closing", ioe2);
            }
        }
    }

    private void closeCurrentSource() {
        if (this.currentSource != null) {
            this.eventListener.willRelease(this, this.currentSource, this.currentInputStream);
            try {
                if (this.currentInputStream != null) {
                    this.currentInputStream.close();
                }
                this.currentSource.release();
                this.eventListener.didRelease(this, this.currentSource);
                this.currentSource = null;
                this.currentInputStream = null;
            }
            catch (IOException ioe) {
                this.eventListener.exception(this, this.currentSource, this.totalBytesRead, this.currentSourceEnd, "closing", ioe);
            }
        }
    }

    public String toString() {
        return "FailoverInputStream: totalBytesRead=" + this.getTotalBytesRead() + "; minimumBytesExpected=" + this.getMinimumBytesExpected() + "; sources.size=" + this.allSources.size();
    }

    public static class DefaultFailoverInputStreamEventListener
    implements FailoverInputStreamEventListener {
        protected Logger LOG = Logger.getLogger((String)"DefaultFailoverInputStreamEventListener");
        private long startTime;

        @Override
        public void willPrepare(FailoverInputStream fis, Source source, int retry) {
            this.LOG.info((Object)("willPrepare: fis=" + fis + "; retry=" + retry + "; source=" + source));
        }

        @Override
        public void didPrepare(FailoverInputStream fis, Source source) {
            this.LOG.debug((Object)("didPrepare: fis=" + fis + "; source=" + source));
        }

        @Override
        public void willRelease(FailoverInputStream fis, Source source, InputStream inputStream) {
            this.LOG.debug((Object)("willRelease: fis=" + fis + "; source=" + source + "; inputStream=" + inputStream));
        }

        @Override
        public void didRelease(FailoverInputStream fis, Source source) {
            this.LOG.debug((Object)("didRelease: fis=" + fis + "; source=" + source));
        }

        @Override
        public void notAvailable(FailoverInputStream fis, Source source, long start, long end) {
            this.LOG.info((Object)("notAvailable: fis=" + fis + "; source=" + source + "; start=" + start + "; end=" + end));
        }

        @Override
        public void willRead(FailoverInputStream fis, Source source, int retry, long start, long end) {
            this.startTime = System.currentTimeMillis();
            this.LOG.info((Object)("willRead: fis=" + fis + "; retry=" + retry + "; source=" + source + "; start=" + start + "; end=" + end));
        }

        @Override
        public void didRead(FailoverInputStream fis, Source source, byte[] bytes, long start, long end) {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            double rate = -1.0;
            if (elapsedTime > 0L) {
                rate = (double)(fis.getTotalBytesRead() - start) / (double)elapsedTime;
            }
            this.LOG.info((Object)("didRead: fis=" + fis + "; source=" + source + "; start=" + start + "; end=" + end + "; rate=" + rate));
        }

        @Override
        public void exception(FailoverInputStream fis, Source source, long start, long end, String message, Exception e) {
            this.LOG.info((Object)("exception: fis=" + fis + "; source=" + source + "; start=" + start + "; end=" + end + "; message=" + message + "; exception=" + e));
        }
    }

    public static interface FailoverInputStreamEventListener {
        public void willPrepare(FailoverInputStream var1, Source var2, int var3);

        public void didPrepare(FailoverInputStream var1, Source var2);

        public void notAvailable(FailoverInputStream var1, Source var2, long var3, long var5);

        public void willRead(FailoverInputStream var1, Source var2, int var3, long var4, long var6);

        public void didRead(FailoverInputStream var1, Source var2, byte[] var3, long var4, long var6);

        public void willRelease(FailoverInputStream var1, Source var2, InputStream var3);

        public void didRelease(FailoverInputStream var1, Source var2);

        public void exception(FailoverInputStream var1, Source var2, long var3, long var5, String var7, Exception var8);
    }
}

