/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io;

import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SeekableInputStream
extends InputStream {
    SeekableDataInput sdi;
    long curPos;

    public SeekableInputStream(SeekableDataInput sdi) {
        if (null == sdi) {
            throw new IllegalArgumentException("SeekableDataInput was null.");
        }
        this.sdi = sdi;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.sdi.readByte() & 0xFF;
        }
        catch (EOFException eofe) {
            return -1;
        }
    }

    @Override
    public long skip(long bytes) throws IOException {
        return this.sdi.skipBytes((int)bytes);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        this.curPos = this.sdi.getFilePointer();
        try {
            if (this.curPos + (long)len > this.sdi.length()) {
                int toRead = (int)(this.sdi.length() - this.sdi.getFilePointer());
                this.sdi.readFully(bytes, off, toRead);
                if (this.sdi.length() - this.curPos == 0L) {
                    return -1;
                }
                return toRead;
            }
            this.sdi.readFully(bytes, off, len);
            return len;
        }
        catch (EOFException eofe) {
            return -1;
        }
    }
}

