/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io;

import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.multisource.HttpClientSource;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.net.URI;

public interface SeekableDataInput
extends DataInput,
ByteSequence,
Closeable {
    public long getFilePointer() throws IOException;

    public String getFileName();

    public long length() throws IOException;

    public void seek(long var1) throws IOException;

    @Override
    public void close() throws IOException;

    public static class Factory {
        private Factory() {
        }

        public static SeekableDataInput fromURI(URI uri) throws IOException {
            if (uri.getScheme().equalsIgnoreCase("http")) {
                return new HttpClientSource(uri.toURL()).openSeekableSourceDataInput();
            }
            return new FileSeekableDataInput(uri.getPath());
        }
    }
}

