/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io;

import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;

public class FileSeekableDataInput
extends RandomAccessFile
implements SeekableDataInput {
    private final String filePath;
    private String fileName;

    public FileSeekableDataInput(File file) throws FileNotFoundException {
        super(file, "r");
        this.filePath = file.getAbsolutePath();
        this.fileName = file.getName();
    }

    public FileSeekableDataInput(String name) throws FileNotFoundException {
        super(name, "r");
        int index;
        this.filePath = name;
        if (this.filePath != null && !this.filePath.trim().isEmpty() && (index = this.filePath.lastIndexOf("/")) > 0) {
            this.fileName = this.filePath.substring(index + 1);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public String getFileName() {
        return this.fileName == null ? this.getFilePath() : this.fileName;
    }
}

