/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.media.foundation.io;

import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class ByteArraySeekableDataInput
extends DataInputStream
implements SeekableDataInput {
    private String fileName;
    private ByteStream bStream;
    private long movieLength;
    private URI uri;

    public ByteArraySeekableDataInput(byte[] data, long fileLength) {
        super(new ByteStream(data));
        this.bStream = (ByteStream)this.in;
        this.movieLength = fileLength;
        try {
            this.uri = new URI("/");
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.bStream.getFilePointer();
    }

    @Override
    public long length() throws IOException {
        return this.movieLength;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.reset();
        this.skip(pos);
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private static class ByteStream
    extends ByteArrayInputStream {
        public ByteStream(byte[] data) {
            super(data);
        }

        public long getFilePointer() throws IOException {
            return this.pos;
        }

        public long length() throws IOException {
            return this.buf.length;
        }
    }
}

