/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl.matching;

import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.LanguageTagMatch;
import com.apple.jingle.locale.impl.LanguageTagMatchImpl;

public class BCP47TagNaiveMatcher {
    public static LanguageTagMatch getBestMatch(LanguageTag thiz, LanguageTag other) {
        String otherValue = other.getPreferredValue();
        String thisValue = thiz.getPreferredValue();
        boolean exactMatch = false;
        int index = -1;
        String match = null;
        if (thisValue.equals(otherValue)) {
            exactMatch = true;
            match = thisValue;
        } else {
            index = thisValue.indexOf(otherValue);
            if (index >= 0) {
                match = thisValue.substring(index, otherValue.length());
            } else {
                index = otherValue.indexOf(thisValue);
                if (index >= 0) {
                    match = otherValue.substring(index, thisValue.length());
                }
            }
        }
        if (match == null) {
            return new LanguageTagMatchImpl(LanguageTagMatch.LanguageTagMatchQuality.NoMatch, null);
        }
        try {
            match = BCP47TagNaiveMatcher.stipOffDanglingDashes(match);
            LanguageTag matchedTag = BCP47TagSupport.createTag(match, false);
            return new LanguageTagMatchImpl(exactMatch ? LanguageTagMatch.LanguageTagMatchQuality.Exact : LanguageTagMatch.LanguageTagMatchQuality.Unknown, matchedTag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new LanguageTagMatchImpl(LanguageTagMatch.LanguageTagMatchQuality.NoMatch, null);
        }
    }

    private static String stipOffDanglingDashes(String match) {
        if (match.startsWith("-")) {
            match = match.substring(1, match.length());
        }
        if (match.endsWith("-")) {
            match = match.substring(0, match.length() - 1);
        }
        return match;
    }
}

