/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl.matching;

import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.Code;
import com.apple.jingle.locale.ExtendedLanguageCode;
import com.apple.jingle.locale.ExtensionCode;
import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.LanguageTagMatch;
import com.apple.jingle.locale.PrimaryLanguageCode;
import com.apple.jingle.locale.PrivateUseCode;
import com.apple.jingle.locale.RegionCode;
import com.apple.jingle.locale.ScriptCode;
import com.apple.jingle.locale.VariantCode;
import com.apple.jingle.locale.impl.BCP47TagComponents;
import com.apple.jingle.locale.impl.BCP47TagImpl;
import com.apple.jingle.locale.impl.LanguageTagMatchImpl;
import com.apple.jingle.locale.impl.matching.BCP47TagNaiveMatcher;
import com.apple.jingle.util.Pair;
import java.util.Arrays;
import java.util.HashSet;

public class BCP47TagComponentBasedMatching {
    public static LanguageTagMatch getBestMatch(LanguageTag thiz, LanguageTag other) {
        Pair<Boolean, Code> privateUseCodeMatch;
        Pair<Boolean, Code> extensionCodeMatch;
        Pair<Boolean, Code[]> variantCodesMatch;
        Pair<Boolean, Code> regionCodeMatch;
        LanguageTagMatch match = BCP47TagNaiveMatcher.getBestMatch(thiz, other);
        if (match != null && LanguageTagMatch.LanguageTagMatchQuality.Exact.equals((Object)match.getLanguageTagMatchQuality())) {
            return match;
        }
        if (!(thiz instanceof BCP47TagImpl) || !(other instanceof BCP47TagImpl)) {
            return new LanguageTagMatchImpl(LanguageTagMatch.LanguageTagMatchQuality.NoMatch, null);
        }
        BCP47TagImpl thisBcp47 = (BCP47TagImpl)thiz;
        BCP47TagImpl otherBcp47 = (BCP47TagImpl)other;
        Pair<Boolean, Code> primaryLanguageCodeMatch = BCP47TagComponentBasedMatching.getMatchingCode(thisBcp47.getPrimaryLanguageCode(), otherBcp47.getPrimaryLanguageCode());
        if (!primaryLanguageCodeMatch.getFirst().booleanValue()) {
            return new LanguageTagMatchImpl(LanguageTagMatch.LanguageTagMatchQuality.NoMatch, null).withMismatchFactor(LanguageTagMatch.MismatchFactor.PrimaryLanguageSubtag);
        }
        Pair<Boolean, Code> scriptCodeMatch = BCP47TagComponentBasedMatching.getMatchingCode(thisBcp47.getScriptCode(), otherBcp47.getScriptCode());
        if (!scriptCodeMatch.getFirst().booleanValue()) {
            return new LanguageTagMatchImpl(LanguageTagMatch.LanguageTagMatchQuality.NoMatch, null).withMismatchFactor(LanguageTagMatch.MismatchFactor.ScriptSubtag);
        }
        HashSet<LanguageTagMatch.MismatchFactor> mismatchFactors = new HashSet<LanguageTagMatch.MismatchFactor>();
        Pair<Boolean, Code[]> extlangCodesMatch = BCP47TagComponentBasedMatching.getMatchingCodes(thisBcp47.getExtendedLanguageCodes(), otherBcp47.getExtendedLanguageCodes());
        if (!extlangCodesMatch.getFirst().booleanValue()) {
            mismatchFactors.add(LanguageTagMatch.MismatchFactor.ExtendedLanguageSubtags);
        }
        if (!(regionCodeMatch = BCP47TagComponentBasedMatching.getMatchingCode(thisBcp47.getRegionCode(), otherBcp47.getRegionCode())).getFirst().booleanValue()) {
            mismatchFactors.add(LanguageTagMatch.MismatchFactor.RegionSubtag);
        }
        if (!(variantCodesMatch = BCP47TagComponentBasedMatching.getMatchingCodes(thisBcp47.getVariantCodes(), otherBcp47.getVariantCodes())).getFirst().booleanValue()) {
            mismatchFactors.add(LanguageTagMatch.MismatchFactor.VariantSubtags);
        }
        if (!(extensionCodeMatch = BCP47TagComponentBasedMatching.getMatchingCode(thisBcp47.getExtensionCode(), otherBcp47.getExtensionCode())).getFirst().booleanValue()) {
            mismatchFactors.add(LanguageTagMatch.MismatchFactor.ExtensionSubtag);
        }
        if (!(privateUseCodeMatch = BCP47TagComponentBasedMatching.getMatchingCode(thisBcp47.getPrivateUseCode(), otherBcp47.getPrivateUseCode())).getFirst().booleanValue()) {
            mismatchFactors.add(LanguageTagMatch.MismatchFactor.PrivateUseSubtag);
        }
        BCP47TagComponents newTagComponents = new BCP47TagComponents((PrimaryLanguageCode)primaryLanguageCodeMatch.getSecond(), (ExtendedLanguageCode[])extlangCodesMatch.getSecond(), (ScriptCode)scriptCodeMatch.getSecond(), (RegionCode)regionCodeMatch.getSecond(), (VariantCode[])variantCodesMatch.getSecond(), (ExtensionCode)extensionCodeMatch.getSecond(), (PrivateUseCode)privateUseCodeMatch.getSecond());
        String newValue = newTagComponents.createValue();
        try {
            LanguageTag newTag = BCP47TagSupport.createTag(newValue, true);
            return new LanguageTagMatchImpl(LanguageTagMatch.LanguageTagMatchQuality.PartialMatch, newTag, mismatchFactors);
        }
        catch (BCP47TagParseException e) {
            return new LanguageTagMatchImpl(LanguageTagMatch.LanguageTagMatchQuality.Unknown, null);
        }
    }

    private static Pair<Boolean, Code> getMatchingCode(Code code1, Code code2) {
        if (code1 == null && code2 == null) {
            return new Pair<Boolean, Object>(true, null);
        }
        if (code1 == null) {
            return new Pair<Boolean, Object>(false, null);
        }
        if (code1.equals(code2)) {
            return new Pair<Boolean, Code>(true, code1);
        }
        return new Pair<Boolean, Object>(false, null);
    }

    private static Pair<Boolean, Code[]> getMatchingCodes(Code[] thisCodes, Code[] otherCodes) {
        HashSet<Code> otherCodesSet;
        if (thisCodes == null || otherCodes == null) {
            return new Pair<Boolean, Object>(true, null);
        }
        HashSet<Code> thisCodesSet = new HashSet<Code>(Arrays.asList(thisCodes));
        if (thisCodesSet.equals(otherCodesSet = new HashSet<Code>(Arrays.asList(otherCodes)))) {
            return new Pair<Boolean, Code[]>(true, thisCodes);
        }
        thisCodesSet.retainAll(otherCodesSet);
        if (!thisCodesSet.isEmpty()) {
            Code[] newArray = new Code[thisCodesSet.size()];
            return new Pair<Boolean, Code[]>(false, thisCodesSet.toArray(newArray));
        }
        return new Pair<Boolean, Object>(false, null);
    }
}

