/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl;

import com.apple.jingle.locale.BCP47TagParseException;
import com.apple.jingle.locale.BCP47TagParser;
import com.apple.jingle.locale.BCP47TagSupport;
import com.apple.jingle.locale.Code;
import com.apple.jingle.locale.CodeValue;
import com.apple.jingle.locale.ExtendedLanguageCode;
import com.apple.jingle.locale.ExtensionCode;
import com.apple.jingle.locale.ISO15924Alpha4ScriptCode;
import com.apple.jingle.locale.ISO3166Alpha2RegionCode;
import com.apple.jingle.locale.ISO639Alpha2PrimaryLanguageCode;
import com.apple.jingle.locale.ISO639Alpha3ExtendedLanguageCode;
import com.apple.jingle.locale.ISO639Alpha3PrimaryLanguageCode;
import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.PrimaryLanguageCode;
import com.apple.jingle.locale.PrimaryLanguageCodeImpl;
import com.apple.jingle.locale.PrivateUseCode;
import com.apple.jingle.locale.RegionCode;
import com.apple.jingle.locale.ScriptCode;
import com.apple.jingle.locale.UNM49RegionCode;
import com.apple.jingle.locale.VariantCode;
import com.apple.jingle.locale.impl.IANALanguageSubtagRegistry;
import com.apple.jingle.locale.impl.RFC5646GrandfatheredTag;
import com.apple.jingle.locale.impl.RFC5646NonConformantTag;
import com.apple.jingle.locale.impl.RFC5646PrivateUseTag;
import com.apple.jingle.locale.impl.RFC5646RedundantTag;
import com.apple.jingle.locale.impl.RFC5646Regex;
import com.apple.jingle.locale.impl.RFC5646Tag;
import com.apple.jingle.locale.impl.RFC5646TagParseException;
import com.apple.jingle.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class RFC5646TagParser
implements BCP47TagParser {
    protected IANALanguageSubtagRegistry getTagRegistry() {
        return IANALanguageSubtagRegistry.getInstance();
    }

    @Override
    public boolean isTagWellFormed(String tag) {
        return this.getRegex(tag).matches();
    }

    private RFC5646Regex getRegex(String tag) {
        return new RFC5646Regex(tag);
    }

    @Override
    public LanguageTag parse(String tag) throws BCP47TagParseException {
        return this.parse(tag, true);
    }

    @Override
    public LanguageTag parse(String tag, boolean validate) throws BCP47TagParseException {
        boolean redundant;
        RFC5646Regex regex = new RFC5646Regex(tag);
        boolean tagWellFormed = regex.matches();
        IANALanguageSubtagRegistry.RegistryEntry grandfathered = this.getTagRegistry().getEntryForTypeAndValue(IANALanguageSubtagRegistry.Type.grandfathered, tag);
        if (grandfathered != null) {
            return this.createGrandfatheredTag(tag, grandfathered, tagWellFormed);
        }
        if (!tagWellFormed) {
            throw new RFC5646TagParseException("[" + tag + "] is not well-formed w.r.t. RFC5646 Language tag rules");
        }
        if (regex.getExclusivelyPrivateUseSubtag() != null) {
            return this.createExclusivelyPrivateUseTag(regex.getExclusivelyPrivateUseSubtag());
        }
        PrimaryLanguageCode primaryLanguageCode = this.createPrimaryLanguageCode(regex.getPrimaryLanguageSubtag());
        ExtendedLanguageCode[] extendedLanguageCodes = this.createExtendedLanguageCode(regex.getExtendedLanguageSubtags());
        ScriptCode scriptCode = this.createScriptCode(regex.getScriptSubtag());
        RegionCode regionCode = this.createRegionCode(regex.getRegionSubtag());
        VariantCode[] variantCodes = this.createVariantCodes(regex.getVariantSubtags());
        ExtensionCode extensionCode = this.createExtensionCode(regex.getExtensionsSubtags());
        PrivateUseCode privateUseCode = this.createPrivateUseCode(regex.getPrivateUseSubtags());
        boolean bl = redundant = this.getTagRegistry().getEntryForTypeAndValue(IANALanguageSubtagRegistry.Type.redundant, tag) != null;
        if (validate) {
            return this.validateAndCreateRFC5646Tag(tag, primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode, redundant);
        }
        return this.attemptToValidateAndCreateRFC5646Tag(tag, primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode, redundant);
    }

    private LanguageTag createExclusivelyPrivateUseTag(String tag) {
        return new RFC5646PrivateUseTag(tag);
    }

    private LanguageTag attemptToValidateAndCreateRFC5646Tag(String tag, PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode, RegionCode regionCode, VariantCode[] variantCodes, ExtensionCode extensionCode, PrivateUseCode privateUseCode, boolean redundant) {
        try {
            return this.validateAndCreateRFC5646Tag(tag, primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode, redundant);
        }
        catch (BCP47TagParseException e) {
            return new RFC5646NonConformantTag(tag, primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode);
        }
    }

    private LanguageTag createGrandfatheredTag(String tag, IANALanguageSubtagRegistry.RegistryEntry grandfathered, boolean tagWellFormed) {
        IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue preferredValue = (IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue)grandfathered.getPreferredValue();
        String preferredValueString = preferredValue != null ? preferredValue.getValue() : null;
        IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue description = (IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue)grandfathered.getDescription();
        String displayName = description != null ? description.getValue() : null;
        return new RFC5646GrandfatheredTag(tag, preferredValueString, displayName, tagWellFormed);
    }

    private void enrich(PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode, RegionCode regionCode, VariantCode[] variantCodes) throws RFC5646TagParseException {
        this.enrich(primaryLanguageCode);
        this.enrich(primaryLanguageCode, extendedLanguageCodes);
        this.enrich(scriptCode);
        this.enrich(regionCode);
        this.enrich(variantCodes);
    }

    private void enrich(PrimaryLanguageCode code) throws RFC5646TagParseException {
        this.enrich(IANALanguageSubtagRegistry.Type.language, code);
        this.enrichSuppressScript(code);
        this.setScope(code);
        this.setMacroLanguage(code);
    }

    private void setMacroLanguage(PrimaryLanguageCode code) throws RFC5646TagParseException {
        IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue macrolanguage;
        IANALanguageSubtagRegistry.RegistryEntry entry = this.getTagRegistry().getEntryForTypeAndValue(IANALanguageSubtagRegistry.Type.language, code.getValue());
        if (entry != null && (macrolanguage = (IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue)entry.getMacroLanguage()) != null) {
            try {
                ((PrimaryLanguageCodeImpl)code).setMacrolanguage(BCP47TagSupport.createTag(macrolanguage.getValue()));
            }
            catch (BCP47TagParseException bcpe) {
                throw new RFC5646TagParseException("Unable to find macrolanguage [" + macrolanguage.getValue() + "] in the registry");
            }
        }
    }

    private void setScope(PrimaryLanguageCode code) {
        IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue scope;
        IANALanguageSubtagRegistry.RegistryEntry entry = this.getTagRegistry().getEntryForTypeAndValue(IANALanguageSubtagRegistry.Type.language, code.getValue());
        if (entry != null && (scope = (IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue)entry.getScope()) != null) {
            ((PrimaryLanguageCodeImpl)code).setScope(PrimaryLanguageCode.Scope.fromValue(scope.getValue()));
        }
    }

    private void enrichSuppressScript(PrimaryLanguageCode code) {
        IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue suppressScript;
        IANALanguageSubtagRegistry.RegistryEntry entry = this.getTagRegistry().getEntryForTypeAndValue(IANALanguageSubtagRegistry.Type.language, code.getValue());
        if (entry != null && (suppressScript = (IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue)entry.getSuppressScript()) != null) {
            ((PrimaryLanguageCodeImpl)code).setSuppressScript(suppressScript.getValue());
        }
    }

    private void enrich(PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] codes) {
        if (codes != null) {
            for (ExtendedLanguageCode code : codes) {
                this.enrich(IANALanguageSubtagRegistry.Type.extlang, code);
                String extlangPreferredValue = code.getPreferredValue();
                IANALanguageSubtagRegistry.RegistryEntry entry = this.getTagRegistry().getEntryForTypeAndValue(IANALanguageSubtagRegistry.Type.language, extlangPreferredValue);
                if (entry == null) continue;
                ((CodeValue)((Object)primaryLanguageCode)).setPreferredValue(extlangPreferredValue);
                ((CodeValue)((Object)code)).reset();
            }
        }
    }

    private void enrich(ScriptCode code) {
        this.enrich(IANALanguageSubtagRegistry.Type.script, code);
    }

    private void enrich(RegionCode code) {
        this.enrich(IANALanguageSubtagRegistry.Type.region, code);
    }

    private void enrich(VariantCode[] codes) {
        if (codes != null) {
            for (VariantCode code : codes) {
                this.enrich(IANALanguageSubtagRegistry.Type.variant, code);
            }
        }
    }

    private void enrich(IANALanguageSubtagRegistry.Type type, Code code) {
        IANALanguageSubtagRegistry.RegistryEntry entry;
        if (code != null && (entry = this.getTagRegistry().getEntryForTypeAndValue(type, code.getValue())) != null) {
            IANALanguageSubtagRegistry.RegistryEntry.RegistryEntryValue<?> description;
            IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue preferredValue = (IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue)entry.getPreferredValue();
            if (preferredValue != null) {
                ((CodeValue)code).setPreferredValue(preferredValue.getValue());
            }
            if ((description = entry.getDescription()) != null) {
                ((CodeValue)code).setDescription(this.handleCollection(description.getValue()));
            }
        }
    }

    private String handleCollection(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Collection) {
            return StringUtils.join((Iterable)((Collection)value), (String)", ");
        }
        return "";
    }

    private LanguageTag validateAndCreateRFC5646Tag(String tag, PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode, RegionCode regionCode, VariantCode[] variantCodes, ExtensionCode extensionCode, PrivateUseCode privateUseCode, boolean redundant) throws BCP47TagParseException {
        this.validate(primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode);
        this.enrich(primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes);
        if (redundant) {
            return new RFC5646RedundantTag(tag, primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode);
        }
        return new RFC5646Tag(tag, primaryLanguageCode, extendedLanguageCodes, scriptCode, regionCode, variantCodes, extensionCode, privateUseCode);
    }

    private void validate(PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode, RegionCode regionCode, VariantCode[] variantCodes, ExtensionCode extensionCode, PrivateUseCode privateUseCode) throws RFC5646TagParseException {
        this.validate(primaryLanguageCode);
        this.validate(primaryLanguageCode, extendedLanguageCodes);
        this.validate(scriptCode);
        this.validate(regionCode);
        this.validate(primaryLanguageCode, extendedLanguageCodes, scriptCode, variantCodes);
    }

    private void validate(PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode, VariantCode[] codes) throws RFC5646TagParseException {
        if (codes != null && codes.length > 0) {
            HashSet<String> values = new HashSet<String>();
            for (VariantCode code : codes) {
                String value = code.getValue();
                this.validate(value, IANALanguageSubtagRegistry.Type.variant);
                this.validateForPrefixes(IANALanguageSubtagRegistry.Type.variant, this.createPrefix(primaryLanguageCode, extendedLanguageCodes, scriptCode), value);
                values.add(value);
            }
            if (values.size() < codes.length) {
                throw new RFC5646TagParseException("Duplicate variant codes [" + ((Object)values).toString() + "]");
            }
        }
    }

    private String createPrefix(PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] extendedLanguageCodes, ScriptCode scriptCode) {
        StringBuilder s = new StringBuilder();
        s.append(primaryLanguageCode.getValue());
        if (extendedLanguageCodes != null) {
            for (ExtendedLanguageCode code : extendedLanguageCodes) {
                s.append("-");
                s.append(code.getValue());
            }
        }
        if (scriptCode != null) {
            s.append("-");
            s.append(scriptCode.getValue());
        }
        return s.toString();
    }

    private void validateForPrefixes(IANALanguageSubtagRegistry.Type type, String availablePrefix, String value) throws RFC5646TagParseException {
        String prefix;
        IANALanguageSubtagRegistry.RegistryEntry.RegistryEntryValue<?> prefixEntries = this.getTagRegistry().getEntryForTypeAndValue(type, value).getPrefixes();
        if (prefixEntries instanceof IANALanguageSubtagRegistry.RegistryEntry.StringCollectionRegistryEntryValue) {
            Object prefixes = ((IANALanguageSubtagRegistry.RegistryEntry.StringCollectionRegistryEntryValue)prefixEntries).getValue();
            if (!prefixes.contains(availablePrefix)) {
                throw new RFC5646TagParseException(type.name() + " code [" + value + "] requires prefixes [" + prefixes + "], instead got [" + availablePrefix + "]");
            }
        } else if (prefixEntries instanceof IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue && !(prefix = ((IANALanguageSubtagRegistry.RegistryEntry.StringRegistryEntryValue)prefixEntries).getValue()).equals(availablePrefix)) {
            throw new RFC5646TagParseException(type.name() + " code [" + value + "] requires prefix [" + prefix + "], instead got [" + availablePrefix + "]");
        }
    }

    private void validate(RegionCode code) throws RFC5646TagParseException {
        if (code != null) {
            this.validate(code.getValue(), IANALanguageSubtagRegistry.Type.region);
        }
    }

    private void validate(ScriptCode code) throws RFC5646TagParseException {
        if (code != null) {
            this.validate(code.getValue(), IANALanguageSubtagRegistry.Type.script);
        }
    }

    private void validate(PrimaryLanguageCode primaryLanguageCode, ExtendedLanguageCode[] codes) throws RFC5646TagParseException {
        if (codes != null && codes.length > 0) {
            for (ExtendedLanguageCode code : codes) {
                String value = code.getValue();
                this.validate(value, IANALanguageSubtagRegistry.Type.extlang);
                this.validateForPrefixes(IANALanguageSubtagRegistry.Type.extlang, primaryLanguageCode.getValue(), value);
            }
        }
    }

    private void validate(PrimaryLanguageCode code) throws RFC5646TagParseException {
        if (code != null) {
            this.validate(code.getValue(), IANALanguageSubtagRegistry.Type.language);
        }
    }

    private void validate(String value, IANALanguageSubtagRegistry.Type registryEntryType) throws RFC5646TagParseException {
        IANALanguageSubtagRegistry.RegistryEntry entry = this.getTagRegistry().getEntryForTypeAndValue(registryEntryType, value);
        if (entry == null) {
            throw new RFC5646TagParseException("No registry entry for " + (Object)((Object)registryEntryType) + " [" + value + "]");
        }
    }

    private PrivateUseCode createPrivateUseCode(String privateUseSubtags) {
        if (privateUseSubtags != null) {
            return new PrivateUseCode(privateUseSubtags);
        }
        return null;
    }

    private ExtensionCode createExtensionCode(Pair<String, String> extensionsSubtags) {
        if (extensionsSubtags != null) {
            return new ExtensionCode(extensionsSubtags.getFirst(), extensionsSubtags.getSecond());
        }
        return null;
    }

    private VariantCode[] createVariantCodes(String[] variantSubtags) throws RFC5646TagParseException {
        if (variantSubtags != null && variantSubtags.length > 0) {
            VariantCode[] variantCodes = new VariantCode[variantSubtags.length];
            for (int i = 0; i < variantSubtags.length; ++i) {
                String variantSubtag = variantSubtags[i];
                if (!StringUtils.isNotBlank((CharSequence)variantSubtag)) {
                    throw new RFC5646TagParseException("Blank variant subtag [" + variantSubtag + "]");
                }
                variantCodes[i] = new VariantCode(variantSubtag.toLowerCase());
            }
            return variantCodes;
        }
        return null;
    }

    private RegionCode createRegionCode(String regionSubtag) throws RFC5646TagParseException {
        if (regionSubtag != null) {
            if (regionSubtag.length() == 2 && StringUtils.isAlpha((CharSequence)regionSubtag)) {
                return new ISO3166Alpha2RegionCode(regionSubtag.toUpperCase());
            }
            if (regionSubtag.length() == 3 && StringUtils.isNumeric((CharSequence)regionSubtag)) {
                return new UNM49RegionCode(regionSubtag);
            }
            throw new RFC5646TagParseException("Non-standard region subtag [" + regionSubtag + "]");
        }
        return null;
    }

    private ScriptCode createScriptCode(String scriptSubtag) throws RFC5646TagParseException {
        if (scriptSubtag != null) {
            if (scriptSubtag.length() == 4) {
                return new ISO15924Alpha4ScriptCode(StringUtils.capitalize((String)scriptSubtag.toLowerCase()));
            }
            throw new RFC5646TagParseException("Non-standard script subtag [" + scriptSubtag + "]");
        }
        return null;
    }

    private ExtendedLanguageCode[] createExtendedLanguageCode(String[] extendedLanguageSubtags) throws RFC5646TagParseException {
        if (extendedLanguageSubtags != null && extendedLanguageSubtags.length > 0) {
            ExtendedLanguageCode[] extendedLanguageCodes = new ISO639Alpha3ExtendedLanguageCode[extendedLanguageSubtags.length];
            for (int i = 0; i < extendedLanguageSubtags.length; ++i) {
                String extlangSubtag = extendedLanguageSubtags[i];
                if (extlangSubtag == null || extlangSubtag.length() != 3) {
                    throw new RFC5646TagParseException("Non-standard extended language subtag [" + extlangSubtag + "]");
                }
                extendedLanguageCodes[i] = new ISO639Alpha3ExtendedLanguageCode(extlangSubtag.toLowerCase());
            }
            return extendedLanguageCodes;
        }
        return null;
    }

    private PrimaryLanguageCode createPrimaryLanguageCode(String primaryLanguageSubtag) throws RFC5646TagParseException {
        if (primaryLanguageSubtag.length() == 2) {
            return new ISO639Alpha2PrimaryLanguageCode(primaryLanguageSubtag.toLowerCase());
        }
        if (primaryLanguageSubtag.length() == 3) {
            return new ISO639Alpha3PrimaryLanguageCode(primaryLanguageSubtag.toLowerCase());
        }
        throw new RFC5646TagParseException("Non-standard primary language subtag [" + primaryLanguageSubtag + "]");
    }
}

