/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl;

import com.apple.jingle.util.Pair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RFC5646Regex {
    public static final String RFC5646TAG_REGULAR_EXPRESSION = TagGroup.ExclusivelyPrivateUse.regex() + "|((" + TagGroup.PrimaryLanguage.regex() + TagGroup.ExtendedLanguagePrefixedWithDash.regex() + TagGroup.Script.regex() + TagGroup.Region.regex() + TagGroup.Variants.regex() + TagGroup.Extensions.regex() + TagGroup.PrivateUse.regex() + ")?)\\z";
    private static final Pattern RFC5646TAG_PATTERN = Pattern.compile(RFC5646TAG_REGULAR_EXPRESSION);
    private Matcher matcher;

    public RFC5646Regex(String tag) {
        this.matcher = this.createMatcher(tag);
    }

    private Matcher createMatcher(String tag) {
        Matcher matcher = RFC5646TAG_PATTERN.matcher(tag);
        return matcher;
    }

    protected boolean matches() {
        return this.matcher.matches();
    }

    protected String getExclusivelyPrivateUseSubtag() {
        return this.matcher.group(TagGroup.ExclusivelyPrivateUse.position());
    }

    protected String getPrimaryLanguageSubtag() {
        return this.matcher.group(TagGroup.PrimaryLanguage.position());
    }

    protected String[] getExtendedLanguageSubtags() {
        String extendedLanguageSubtags = this.matcher.group(TagGroup.ExtendedLanguagePrefixedWithDash.position());
        if (extendedLanguageSubtags != null) {
            return StringUtils.split((String)extendedLanguageSubtags, (String)"-");
        }
        return null;
    }

    protected String getScriptSubtag() {
        return this.matcher.group(TagGroup.Script.position());
    }

    protected String getRegionSubtag() {
        return this.matcher.group(TagGroup.Region.position());
    }

    protected String[] getVariantSubtags() {
        String variantSubtags = this.matcher.group(TagGroup.Variants.position());
        if (variantSubtags != null) {
            return StringUtils.split((String)variantSubtags, (String)"-");
        }
        return null;
    }

    protected Pair<String, String> getExtensionsSubtags() {
        String extensionSubtags = this.matcher.group(TagGroup.Extensions.position());
        if (extensionSubtags != null) {
            String singleton = extensionSubtags.substring(1, 2);
            String theRest = extensionSubtags.substring(2);
            return new Pair<String, String>(singleton, theRest);
        }
        return null;
    }

    protected String getPrivateUseSubtags() {
        return this.matcher.group(TagGroup.PrivateUse.position());
    }

    private static enum TagGroup {
        ExclusivelyPrivateUse(1, "(\\A[xX]([\\x2d]\\p{Alnum}{1,8})*\\z)"),
        PrimaryLanguage(5, "(\\A\\p{Alpha}{2,8}(?=\\x2d|\\z)){1}"),
        ExtendedLanguagePrefixedWithDash(6, "(([\\x2d]\\p{Alpha}{3}(?=\\x2d|\\z)){0,3})"),
        Script(9, "([\\x2d](\\p{Alpha}{4})(?=\\x2d|\\z))?"),
        Region(11, "([\\x2d](\\p{Alpha}{2}|\\d{3})(?=\\x2d|\\z))?"),
        Variants(12, "(([\\x2d](\\d\\p{Alnum}{3}|\\p{Alnum}{5,8})(?=\\x2d|\\z))*))"),
        Extensions(16, "(([\\x2d]([a-wyzA-WYZ])([\\x2d]\\p{Alnum}{2,8})+)*)*"),
        PrivateUse(20, "([\\x2d][xX](([\\x2d]\\p{Alnum}{1,8})*)");

        private int position;
        private String regex;

        private TagGroup(int position, String regex) {
            this.position = position;
            this.regex = regex;
        }

        public int position() {
            return this.position;
        }

        public String regex() {
            return this.regex;
        }
    }
}

