/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl;

import com.apple.jingle.locale.LanguageTag;
import com.apple.jingle.locale.LanguageTagMatch;
import com.apple.jingle.locale.impl.matching.BCP47TagNaiveMatcher;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import javax.annotation.Nonnull;

public abstract class LanguageTagImpl
implements LanguageTag,
Externalizable {
    private String value;
    private String preferredValue;
    private String displayName;

    protected LanguageTagImpl() {
    }

    public LanguageTagImpl(@Nonnull String value) {
        if (value == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        this.value = value;
        this.preferredValue = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    protected void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getPreferredValue() {
        return this.preferredValue != null ? this.preferredValue : this.getValue();
    }

    protected void setPreferredValue(String preferredValue) {
        this.preferredValue = preferredValue;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LanguageTag)) {
            return false;
        }
        String otherValue = ((LanguageTag)other).getValue();
        return this.getValue().equals(otherValue);
    }

    public int hashCode() {
        int hash = 7;
        String value = this.getValue();
        hash = 31 * hash + (null == value ? 0 : value.hashCode());
        return hash;
    }

    @Override
    public LanguageTagMatch getBestMatch(LanguageTag other) {
        return BCP47TagNaiveMatcher.getBestMatch(this, other);
    }

    @Override
    public Locale getLocale() {
        return new Locale(this.getPreferredValue());
    }

    @Override
    public boolean isMacrolanguage() {
        return LanguageTag.TagAttribute.Macrolanguage.equals((Object)this.getTagAttribute());
    }

    @Override
    public boolean isCollection() {
        return LanguageTag.TagAttribute.Collection.equals((Object)this.getTagAttribute());
    }

    @Override
    public boolean isRedundant() {
        return LanguageTag.TagAttribute.Redundant.equals((Object)this.getTagAttribute());
    }

    @Override
    public boolean isGrandfathered() {
        return LanguageTag.TagAttribute.Grandfathered.equals((Object)this.getTagAttribute());
    }

    @Override
    public boolean isValid() {
        return LanguageTag.TagAttribute.Valid.equals((Object)this.getTagAttribute());
    }

    @Override
    public boolean isPrivateUse() {
        return LanguageTag.TagAttribute.PrivateUse.equals((Object)this.getTagAttribute());
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setValue(input.readUTF());
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF(this.getValue());
    }
}

