/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.locale.impl;

import com.apple.jingle.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.log4j.Logger;

public class IANALanguageSubtagRegistry {
    private static final Logger log = Logger.getLogger(IANALanguageSubtagRegistry.class);
    private static final String IANA_REGISTRY_LOCATION = "language-subtag-registry";
    private static final Object REGISTRY_ENTRY_SEPARATOR = "%%";
    private static final IANALanguageSubtagRegistry singleton;
    private EnumMap<Type, CaseInsensitiveMap> types = new EnumMap(Type.class);

    public IANALanguageSubtagRegistry() throws Exception {
        BufferedReader registryFileReader = this.openRegistryFileReader();
        try {
            this.createRegistryEntries(registryFileReader);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.closeRegistryFileReader(registryFileReader);
        }
    }

    protected void closeRegistryFileReader(BufferedReader registryFileReader) {
        block3: {
            if (registryFileReader != null) {
                try {
                    registryFileReader.close();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Exception while closing registry file reader", (Throwable)e);
                }
            }
        }
    }

    protected void createRegistryEntries(BufferedReader registryFileReader) throws Exception {
        RegistryEntry registryEntry = this.getNextRegistryEntry(registryFileReader);
        while (registryEntry != null) {
            this.addToTypes(registryEntry);
            registryEntry = this.getNextRegistryEntry(registryFileReader);
        }
    }

    private void addToTypes(RegistryEntry registryEntry) {
        CaseInsensitiveMap map = this.types.get((Object)registryEntry.getType());
        if (map == null) {
            map = new CaseInsensitiveMap();
            this.types.put(registryEntry.getType(), map);
        }
        map.put((Object)registryEntry.getEffectiveSubtag(), (Object)registryEntry);
    }

    private RegistryEntry getNextRegistryEntry(BufferedReader registryFileReader) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = registryFileReader.readLine()) != null && !REGISTRY_ENTRY_SEPARATOR.equals(line)) {
            if (line.startsWith(RegistryEntry.RegistryEntryKey.comments.value())) {
                line = this.readAndConsumeMultilineValues(line, RegistryEntry.RegistryEntryKey.comments, registryFileReader);
            } else if (line.startsWith(RegistryEntry.RegistryEntryKey.description.value())) {
                line = this.readAndConsumeMultilineValues(line, RegistryEntry.RegistryEntryKey.description, registryFileReader);
            }
            lines.add(line);
        }
        return this.newRegistryEntryOrNull(lines);
    }

    private String readAndConsumeMultilineValues(String line, RegistryEntry.RegistryEntryKey key, BufferedReader registryFileReader) throws Exception {
        assert (line != null);
        StringBuilder commentsBuilder = new StringBuilder(line);
        while ((line = this.nextLine(registryFileReader)) != null) {
            commentsBuilder.append("\n" + line);
        }
        return commentsBuilder.toString();
    }

    private String nextLine(BufferedReader registryFileReader) throws Exception {
        registryFileReader.mark(256);
        String line = registryFileReader.readLine();
        if (line == null || REGISTRY_ENTRY_SEPARATOR.equals(line) || this.isDifferentProperty(line)) {
            registryFileReader.reset();
            return null;
        }
        return line;
    }

    private boolean isDifferentProperty(String line) {
        for (RegistryEntry.RegistryEntryKey key : RegistryEntry.RegistryEntryKey.values()) {
            if (!line.startsWith(key.value())) continue;
            return true;
        }
        return false;
    }

    private RegistryEntry newRegistryEntryOrNull(List<String> lines) throws Exception {
        if (lines == null || lines.isEmpty()) {
            return null;
        }
        return new RegistryEntry(lines);
    }

    private BufferedReader openRegistryFileReader() throws Exception {
        String registryLocation = this.getRegistryLocation();
        InputStream registryFileStream = this.getClass().getResourceAsStream(registryLocation);
        if (registryFileStream == null) {
            throw new Exception("Did not find registry at configured location [" + registryLocation + "]");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(registryFileStream, "UTF8"));
        this.movePointerToFirstRegistryEntrySeparator(bufferedReader);
        return bufferedReader;
    }

    private String getRegistryLocation() {
        return IANA_REGISTRY_LOCATION;
    }

    private void movePointerToFirstRegistryEntrySeparator(BufferedReader bufferedReader) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null && !REGISTRY_ENTRY_SEPARATOR.equals(line)) {
        }
    }

    CaseInsensitiveMap getEntriesOfType(Type type) {
        return this.types.get((Object)type);
    }

    public RegistryEntry getEntryForTypeAndValue(Type type, String value) {
        CaseInsensitiveMap map = this.getEntriesOfType(type);
        if (map != null) {
            return (RegistryEntry)map.get((Object)value);
        }
        return null;
    }

    public static IANALanguageSubtagRegistry getInstance() {
        return singleton;
    }

    static {
        try {
            singleton = new IANALanguageSubtagRegistry();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }

    protected static class RegistryEntry {
        private static final String REGISTRY_ENTRY_LINE_KEY_VALUE_SEPARATOR = ":";
        private EnumMap<RegistryEntryKey, RegistryEntryValue<?>> entryMap = new EnumMap(RegistryEntryKey.class);
        private Type type;

        public Type getType() {
            return this.type;
        }

        private RegistryEntryValue<?> getTag() {
            return this.entryMap.get((Object)RegistryEntryKey.tag);
        }

        private RegistryEntryValue<?> getSubtag() {
            return this.entryMap.get((Object)RegistryEntryKey.subtag);
        }

        public RegistryEntryValue<?> getDescription() {
            return this.entryMap.get((Object)RegistryEntryKey.description);
        }

        public RegistryEntryValue<?> getAdded() {
            return this.entryMap.get((Object)RegistryEntryKey.added);
        }

        public RegistryEntryValue<?> getMacroLanguage() {
            return this.entryMap.get((Object)RegistryEntryKey.macroLanguage);
        }

        public RegistryEntryValue<?> getSuppressScript() {
            return this.entryMap.get((Object)RegistryEntryKey.suppressScript);
        }

        public RegistryEntryValue<?> getScope() {
            return this.entryMap.get((Object)RegistryEntryKey.scope);
        }

        public RegistryEntryValue<?> getPrefixes() {
            return this.entryMap.get((Object)RegistryEntryKey.prefix);
        }

        public RegistryEntryValue<?> getDeprecated() {
            return this.entryMap.get((Object)RegistryEntryKey.deprecated);
        }

        public RegistryEntryValue<?> getPreferredValue() {
            return this.entryMap.get((Object)RegistryEntryKey.preferredValue);
        }

        public RegistryEntryValue<?> getComments() {
            return this.entryMap.get((Object)RegistryEntryKey.comments);
        }

        protected RegistryEntry(List<String> entryLines) throws Exception {
            for (String line : entryLines) {
                Pair<String, String> nameValuePair = this.split(line);
                String name = nameValuePair.getFirst();
                RegistryEntryKey key = RegistryEntryKey.fromValue(name);
                RegistryEntryValue<?> registryEntryValue = this.entryMap.get((Object)key);
                String value = nameValuePair.getSecond();
                if (registryEntryValue == null) {
                    this.entryMap.put(key, new StringRegistryEntryValue(value));
                } else if (registryEntryValue instanceof StringRegistryEntryValue) {
                    String existingValue = ((StringRegistryEntryValue)registryEntryValue).getValue();
                    StringCollectionRegistryEntryValue newRegistryEntryValue = new StringCollectionRegistryEntryValue(existingValue);
                    newRegistryEntryValue.addValue(value);
                    this.entryMap.put(key, newRegistryEntryValue);
                } else if (registryEntryValue instanceof StringCollectionRegistryEntryValue) {
                    ((StringCollectionRegistryEntryValue)registryEntryValue).addValue(value);
                }
                if (!RegistryEntryKey.type.equals((Object)key)) continue;
                this.type = Type.fromValue(value);
            }
        }

        private Pair<String, String> split(String line) throws Exception {
            int separatorIndex = line.indexOf(REGISTRY_ENTRY_LINE_KEY_VALUE_SEPARATOR);
            if (separatorIndex > 1 && separatorIndex < line.length() - 1) {
                String name = line.substring(0, separatorIndex);
                String value = line.substring(separatorIndex + 1);
                return new Pair<String, String>(name.trim(), value.trim());
            }
            throw new Exception("Registry line is not well-formed: [" + line + "]");
        }

        public String getEffectiveSubtag() {
            RegistryEntryValue<?> grandfatheredTag = Type.grandfathered.equals((Object)this.type) || Type.redundant.equals((Object)this.type) ? this.getTag() : this.getSubtag();
            return ((StringRegistryEntryValue)grandfatheredTag).getValue();
        }

        class StringCollectionRegistryEntryValue
        implements RegistryEntryValue<Collection<String>> {
            private Collection<String> value = new ArrayList<String>();

            StringCollectionRegistryEntryValue(String value) {
                this.value.add(value);
            }

            public void addValue(String value) {
                this.value.add(value);
            }

            @Override
            public Collection<String> getValue() {
                return this.value;
            }
        }

        class StringRegistryEntryValue
        implements RegistryEntryValue<String> {
            private String value;

            StringRegistryEntryValue(String value) {
                this.value = value;
            }

            @Override
            public String getValue() {
                return this.value;
            }
        }

        static interface RegistryEntryValue<T> {
            public T getValue();
        }

        private static enum RegistryEntryKey {
            type("Type"),
            subtag("Subtag"),
            description("Description"),
            added("Added"),
            macroLanguage("Macrolanguage"),
            suppressScript("Suppress-Script"),
            scope("Scope"),
            prefix("Prefix"),
            deprecated("Deprecated"),
            preferredValue("Preferred-Value"),
            comments("Comments"),
            tag("Tag");

            private String value;

            private RegistryEntryKey(String value) {
                this.value = value;
            }

            protected String value() {
                return this.value;
            }

            protected static RegistryEntryKey fromValue(String value) {
                for (RegistryEntryKey e : RegistryEntryKey.values()) {
                    if (!e.value().equals(value)) continue;
                    return e;
                }
                return null;
            }
        }
    }

    public static enum Type {
        language,
        extlang,
        script,
        region,
        variant,
        grandfathered,
        redundant,
        extension,
        privateUse;


        public static Type fromValue(String value) {
            for (Type type : Type.values()) {
                if (!type.name().equals(value)) continue;
                return type;
            }
            return null;
        }
    }
}

